/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.QuantumQuarryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class QuantumQuarrySerializer
implements RecipeSerializer<QuantumQuarryRecipe> {
    public static final MapCodec<QuantumQuarryRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> {
        Codec singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
            if ("tag".equals(type)) {
                return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
            }
            return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
        }));
        return builder.group((App)Codec.STRING.fieldOf("recipe_type").forGetter(QuantumQuarryRecipe::getRecipeType), (App)Codec.STRING.fieldOf("recipeOperation").forGetter(QuantumQuarryRecipe::getTypeOperation), (App)Codec.list((Codec)singleInputCodec).fieldOf("inputs").forGetter(QuantumQuarryRecipe::getInputs)).apply((Applicative)builder, (recipeType, recipeOperation, inputs) -> {
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            for (IInputItemStack o : inputs) {
                input.add(o.getInputs().get(0));
            }
            block6 : switch (recipeOperation) {
                case "default": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "furnace": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_furnace_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_furnace_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "macerator": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_crushed_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_crushed_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "comb_macerator": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_comb_crushed_adding.addAll(input);
                            break block6;
                        }
                        case "remove": {
                            IUCore.list_comb_crushed_removing.addAll(input);
                        }
                    }
                }
            }
            return new QuantumQuarryRecipe((String)recipeType, (List<ItemStack>)new ArrayList<ItemStack>(), (String)recipeOperation);
        });
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, QuantumQuarryRecipe> STREAM_CODEC = StreamCodec.of(QuantumQuarrySerializer::toNetwork, QuantumQuarrySerializer::fromNetwork);

    private static QuantumQuarryRecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
        return new QuantumQuarryRecipe("", new ArrayList<ItemStack>(), "");
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, QuantumQuarryRecipe p_320586_) {
    }

    public MapCodec<QuantumQuarryRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, QuantumQuarryRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

