/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.compressor;

import com.denfop.IUItem;
import com.denfop.tiles.mechanism.TileEntityCompressor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.ClientHooks;

public class TileEntityRenderCompressor
implements BlockEntityRenderer<TileEntityCompressor> {
    private final BlockEntityRendererProvider.Context contex;
    private ItemStack stack;
    private float rotation;
    private float prevRotation;

    public TileEntityRenderCompressor(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public void render(TileEntityCompressor te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        ItemStack itemstack = te.outputSlot.get(0);
        poseStack.pushPose();
        if (te.durability == 0) {
            if (this.stack == null) {
                this.stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(76));
            }
            this.renderItem(this.stack, te.getLevel(), poseStack, bufferSource, packedLight, combinedOverlay, partialTicks);
        }
        poseStack.popPose();
        if (!itemstack.isEmpty()) {
            poseStack.pushPose();
            if (itemstack.getItem() instanceof BlockItem) {
                if (te.facing == 4 || te.facing == 5) {
                    poseStack.translate(0.5, 0.41, 0.31);
                } else {
                    poseStack.translate(0.5, 0.41, 0.3);
                }
            } else {
                poseStack.translate(0.5, 0.42, 0.37501);
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.contex.getItemRenderer().renderStatic(itemstack, ItemDisplayContext.GROUND, packedLight, combinedOverlay, poseStack, bufferSource, te.getLevel(), 0);
            poseStack.popPose();
        }
        if (!(itemstack = te.inputSlotA.get(0)).isEmpty()) {
            poseStack.pushPose();
            if (itemstack.getItem() instanceof BlockItem) {
                if (te.facing == 4 || te.facing == 5) {
                    poseStack.translate(0.5, 0.41, 0.31);
                } else {
                    poseStack.translate(0.5, 0.41, 0.3);
                }
            } else {
                poseStack.translate(0.5, 0.42, 0.37501);
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.contex.getItemRenderer().renderStatic(itemstack, ItemDisplayContext.GROUND, packedLight, combinedOverlay, poseStack, bufferSource, te.getLevel(), 0);
            poseStack.popPose();
        }
    }

    private int transformModelCount(PoseStack poseStack, float partialTicks) {
        int modelCount = 1;
        float offsetY = 1.0f;
        poseStack.translate(0.5, (double)(0.25f * offsetY) + 0.25, 0.5);
        poseStack.scale(0.4f, 0.4f, 0.4f);
        this.prevRotation = this.rotation = (this.prevRotation + (this.rotation - this.prevRotation) * partialTicks) % 360.0f;
        this.rotation += 2.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(this.rotation));
        return modelCount;
    }

    public void renderItem(ItemStack itemStack, Level level, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float partialTicks) {
        if (itemStack.isEmpty()) {
            return;
        }
        BakedModel bakedModel = this.contex.getItemRenderer().getModel(itemStack, level, null, 0);
        RandomSource random = level.random;
        if (bakedModel != null) {
            boolean isGui3d = bakedModel.isGui3d();
            poseStack.pushPose();
            poseStack.translate(0.0f, 2.0f, 0.0f);
            int count = this.transformModelCount(poseStack, partialTicks);
            for (int i = 0; i < 1; ++i) {
                poseStack.pushPose();
                if (isGui3d) {
                    if (i > 0) {
                        float xOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        yOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float zOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        poseStack.translate(xOffset, yOffset, zOffset);
                    }
                } else if (i > 0) {
                    float xOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    yOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    poseStack.translate(xOffset, yOffset, 0.0f);
                }
                BakedModel transformedModel = ClientHooks.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)bakedModel, (ItemDisplayContext)ItemDisplayContext.GROUND, (boolean)false);
                this.contex.getItemRenderer().render(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, light, overlay, transformedModel);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }
}

