/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.api.Recipes;
import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.IPatternStorage;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.Fluids;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerReplicator;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiReplicator;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileBaseReplicator
extends TileElectricMachine
implements IUpgradableBlock,
IType,
IUpdatableTileEvent {
    public final InvSlotFluid fluidSlot;
    public final InvSlotOutput cellSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final FluidTank fluidTank;
    protected final Fluids fluids;
    private final double coef;
    private final ComponentUpgrade componentUpgrades;
    private final ComponentUpgradeSlots componentUpgrade;
    public double uuProcessed = 0.0;
    public RecipeInfo pattern;
    public int index;
    public int maxIndex;
    public double patternUu;
    public double patternEu;
    public Mode mode;
    Map<BlockPos, IPatternStorage> iPatternStorageMap = new HashMap<BlockPos, IPatternStorage>();
    List<IPatternStorage> iPatternStorageList = new ArrayList<IPatternStorage>();
    private double uuPerTick = 1.0E-4;
    private double euPerTick = 512.0;
    private double extraUuStored = 0.0;
    private boolean instant = false;
    private boolean stack = false;

    public TileBaseReplicator(double coef, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(2000000.0, 4, 0, block, pos, state);
        this.mode = Mode.STOPPED;
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.INPUT, (Fluid)FluidName.fluiduu_matter.getInstance().get());
        this.cellSlot = new InvSlotOutput(this, 1);
        this.outputSlot = new InvSlotOutput(this, 1);
        this.upgradeSlot = new InvSlotUpgrade(this, 4);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", 16000, Fluids.fluidPredicate((Fluid)FluidName.fluiduu_matter.getInstance().get()));
        this.coef = coef;
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this, this.upgradeSlot){

            @Override
            public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
                super.setOverclockRates(invSlotUpgrade);
                ((TileBaseReplicator)this.getParent()).setOverclockRates();
            }
        });
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(int base, double extra, double multiplier) {
        return Math.round(((double)base + extra) * multiplier);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.uuProcessed = (Double)DecoderHandler.decode(customPacketBuffer);
            this.pattern = (RecipeInfo)DecoderHandler.decode(customPacketBuffer);
            this.mode = Mode.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.index = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.maxIndex = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.patternUu = (Double)DecoderHandler.decode(customPacketBuffer);
            this.patternEu = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.uuProcessed);
            EncoderHandler.encode(packet, this.pattern);
            EncoderHandler.encode(packet, (Object)this.mode);
            EncoderHandler.encode(packet, this.index);
            EncoderHandler.encode(packet, this.maxIndex);
            EncoderHandler.encode(packet, this.patternUu);
            EncoderHandler.encode(packet, this.patternEu);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        IPatternStorage storage;
        super.onNeighborChange(neighbor, neighborPos);
        BlockEntity tile = this.getWorld().getBlockEntity(neighborPos);
        if (tile instanceof IPatternStorage) {
            if (!this.iPatternStorageList.contains((IPatternStorage)tile)) {
                this.iPatternStorageList.add((IPatternStorage)tile);
                this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
            }
        } else if (tile == null && (storage = this.iPatternStorageMap.get(neighborPos)) != null) {
            this.iPatternStorageList.remove(storage);
            this.iPatternStorageMap.remove(neighborPos, storage);
        }
        this.refreshInfo();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            this.gainFluid();
        }
        if (this.componentUpgrades.isChange()) {
            this.instant = this.componentUpgrades.hasUpgrade(TypeUpgrade.INSTANT);
            this.stack = this.componentUpgrades.hasUpgrade(TypeUpgrade.STACK);
            this.componentUpgrades.setChange(false);
        }
        boolean newActive = false;
        double energyConsume = this.euPerTick;
        if (this.instant) {
            energyConsume *= 10.0;
        }
        if (this.mode != Mode.STOPPED && this.energy.getEnergy() >= energyConsume && this.pattern != null && this.outputSlot.canAdd(this.pattern.getStack())) {
            boolean finish;
            double uuRemaining = this.patternUu - this.uuProcessed;
            if (this.instant) {
                if (uuRemaining <= (double)this.fluidTank.getFluidAmount() * 1.0) {
                    uuRemaining = this.patternUu;
                    finish = true;
                } else if (uuRemaining <= this.uuPerTick) {
                    finish = true;
                } else {
                    uuRemaining = this.uuPerTick;
                    finish = false;
                }
            } else if (uuRemaining <= this.uuPerTick) {
                finish = true;
            } else {
                uuRemaining = this.uuPerTick;
                finish = false;
            }
            double size = 1.0;
            if (this.stack) {
                size = (double)this.fluidTank.getFluidAmount() / (this.patternUu * 1000.0);
                size = Math.min(size, (double)this.pattern.getStack().getMaxStackSize());
                int amount = this.outputSlot.get(0).isEmpty() ? 64 : this.outputSlot.get(0).getMaxStackSize() - this.outputSlot.get(0).getCount();
                size = Math.min((double)amount, size);
                if (size >= 1.0) {
                    uuRemaining = this.patternUu;
                    finish = true;
                }
            }
            if (this.consumeUu(uuRemaining * size)) {
                newActive = true;
                this.energy.useEnergy(energyConsume);
                this.uuProcessed += uuRemaining * size;
                if (finish) {
                    this.uuProcessed = 0.0;
                    if (this.mode == Mode.SINGLE) {
                        this.mode = Mode.STOPPED;
                    } else {
                        this.refreshInfo();
                    }
                    if (this.pattern != null) {
                        if (size > 1.0) {
                            int i = 0;
                            while ((double)i < size - 1.0) {
                                this.outputSlot.add(this.pattern.getStack());
                                ++i;
                            }
                        } else {
                            this.outputSlot.add(this.pattern.getStack());
                        }
                    }
                }
            }
        }
        this.setActive(newActive);
    }

    private boolean consumeUu(double amount) {
        if (amount <= this.extraUuStored) {
            this.extraUuStored -= amount;
            return true;
        }
        int toDrain = (int)Math.ceil((amount -= this.extraUuStored) * 1000.0);
        FluidStack drained = this.fluidTank.drain(toDrain, IFluidHandler.FluidAction.SIMULATE);
        if (!drained.isEmpty() && drained.getFluid() == FluidName.fluiduu_matter.getInstance().get() && drained.getAmount() == toDrain) {
            this.fluidTank.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
            this.extraUuStored = amount < 0.0 ? -(amount -= (double)drained.getAmount() / 1000.0) : 0.0;
            return true;
        }
        return false;
    }

    public void refreshInfo() {
        IPatternStorage storage = this.getPatternStorage();
        RecipeInfo oldPattern = this.pattern;
        if (storage == null) {
            this.pattern = null;
        } else {
            List<RecipeInfo> patterns = storage.getPatterns();
            if (this.index < 0 || this.index >= patterns.size()) {
                this.index = 0;
            }
            this.maxIndex = patterns.size();
            if (patterns.isEmpty()) {
                this.pattern = null;
            } else {
                this.pattern = patterns.get(this.index);
                this.patternUu = this.pattern.getCol() * this.coef;
                this.patternEu = this.patternUu * 1.0E9;
                if (oldPattern == null || !ModUtils.checkItemEqualityStrict(this.pattern.getStack(), oldPattern.getStack())) {
                    this.uuProcessed = 0.0;
                    this.mode = Mode.STOPPED;
                }
            }
        }
        if (this.pattern == null) {
            this.uuProcessed = 0.0;
            this.mode = Mode.STOPPED;
        }
    }

    public IPatternStorage getPatternStorage() {
        if (this.iPatternStorageList.isEmpty()) {
            return null;
        }
        return this.iPatternStorageList.get(0);
    }

    public void setOverclockRates() {
        this.uuPerTick = 1.0E-4 / this.upgradeSlot.processTimeMultiplier;
        this.euPerTick = (512.0 + this.upgradeSlot.extraEnergyDemand) * this.upgradeSlot.energyDemandMultiplier;
        this.energy.setSinkTier(TileBaseReplicator.applyModifier(4, this.upgradeSlot.extraTier, 1.0));
        this.energy.setCapacity(TileBaseReplicator.applyModifier(2000000, this.upgradeSlot.extraEnergyStorage, this.upgradeSlot.energyStorageMultiplier));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player player, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiReplicator((ContainerReplicator)isAdmin);
    }

    public ContainerReplicator getGuiContainer(Player player) {
        return new ContainerReplicator(player, this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getLevel().isClientSide) {
            this.setOverclockRates();
            for (Direction facing : Direction.values()) {
                IPatternStorage storage;
                BlockPos neighborPos = this.pos.offset(facing.getNormal());
                BlockEntity tile = this.getWorld().getBlockEntity(neighborPos);
                if (tile instanceof IPatternStorage) {
                    if (this.iPatternStorageList.contains((IPatternStorage)tile)) continue;
                    this.iPatternStorageList.add((IPatternStorage)tile);
                    this.iPatternStorageMap.put(neighborPos, (IPatternStorage)tile);
                    continue;
                }
                if (tile != null || (storage = this.iPatternStorageMap.get(neighborPos)) == null) continue;
                this.iPatternStorageList.remove(storage);
                this.iPatternStorageMap.remove(neighborPos, storage);
            }
            this.refreshInfo();
        }
    }

    public void gainFluid() {
        this.fluidSlot.processIntoTank((IFluidTank)this.fluidTank, this.cellSlot);
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.extraUuStored = nbt.getDouble("extraUuStored");
        this.uuProcessed = nbt.getDouble("uuProcessed");
        this.index = nbt.getInt("index");
        int modeIdx = nbt.getInt("mode");
        this.mode = modeIdx < Mode.values().length ? Mode.values()[modeIdx] : Mode.STOPPED;
        boolean isPattern = nbt.getBoolean("isPattern");
        if (isPattern) {
            CompoundTag contentTag = nbt.getCompound("pattern");
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.provider, (CompoundTag)contentTag);
            this.pattern = new RecipeInfo(stack, Recipes.recipes.getRecipeOutput((String)"replicator", (boolean)false, (ItemStack[])new ItemStack[]{stack}).getOutput().metadata.getDouble("matter"));
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.putDouble("extraUuStored", this.extraUuStored);
        nbt.putDouble("uuProcessed", this.uuProcessed);
        nbt.putInt("index", this.index);
        nbt.putInt("mode", this.mode.ordinal());
        if (this.pattern != null) {
            nbt.putBoolean("isPattern", true);
            CompoundTag contentTag = new CompoundTag();
            this.pattern.getStack().save(this.provider, (Tag)contentTag);
            nbt.put("pattern", (Tag)contentTag);
        } else {
            nbt.putBoolean("isPattern", false);
        }
        return nbt;
    }

    @Override
    public void updateTileServer(Player player, double event) {
        switch ((int)event) {
            case 0: 
            case 1: {
                List<RecipeInfo> patterns;
                IPatternStorage storage;
                if (this.mode == Mode.STOPPED && (storage = this.getPatternStorage()) != null && !(patterns = storage.getPatterns()).isEmpty()) {
                    this.index = event == 0.0 ? (this.index <= 0 ? patterns.size() - 1 : --this.index) : (this.index >= patterns.size() - 1 ? 0 : ++this.index);
                    this.refreshInfo();
                }
            }
            default: {
                break;
            }
            case 3: {
                if (this.mode == Mode.STOPPED) break;
                this.uuProcessed = 0.0;
                this.mode = Mode.STOPPED;
                break;
            }
            case 4: {
                if (this.pattern == null) break;
                this.mode = Mode.SINGLE;
                break;
            }
            case 5: {
                if (this.pattern == null) break;
                this.mode = Mode.CONTINUOUS;
            }
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.FluidInput);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    public static enum Mode {
        STOPPED,
        SINGLE,
        CONTINUOUS;

    }
}

