/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.componets.Energy;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerMagnet;
import com.denfop.container.SlotInfo;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiMagnet;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.tiles.base.TileEntityAntiMagnet;
import com.denfop.utils.ParticleUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileMagnet
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final SlotInfo slot;
    private final ComponentVisibleArea visible;
    public int energyconsume = 1000;
    public boolean work = true;
    public String player = "";
    public int x = 11;
    public int y = 11;
    public int z = 11;
    List<ChunkAccess> list = Lists.newArrayList();
    private AABB axisalignedbb;
    private ChunkPos chunkPos;

    public TileMagnet(BlockPos pos, BlockState state) {
        super(100000.0, 14, 24, BlockBaseMachine1.magnet, pos, state);
        this.slot = new SlotInfo(this, 18, false);
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.energyconsume = (Integer)DecoderHandler.decode(customPacketBuffer);
            int prevX = this.x;
            int prevY = this.y;
            int prevZ = this.z;
            this.x = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.y = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.z = (Integer)DecoderHandler.decode(customPacketBuffer);
            if (prevX != this.x || prevY != this.y || prevZ != this.z) {
                this.updateData();
                this.visible.aabb = this.axisalignedbb;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.energyconsume);
            EncoderHandler.encode(packet, this.x);
            EncoderHandler.encode(packet, this.y);
            EncoderHandler.encode(packet, this.z);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.magnet.getSoundEvent();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.magnet_work_info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine1.magnet;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.player = player.getName().getString();
            for (int x = this.pos.getX() - this.x; x <= this.pos.getX() + this.x; ++x) {
                for (int y = this.pos.getY() - this.y; y <= this.pos.getY() + this.y; ++y) {
                    for (int z = this.pos.getZ() - this.z; z <= this.pos.getZ() + this.z; ++z) {
                        BlockPos pos1 = new BlockPos(x, y, z);
                        BlockEntity tileEntity = this.getWorld().getBlockEntity(pos1);
                        if (tileEntity == null || pos1.equals((Object)this.pos) || !(tileEntity instanceof TileEntityAntiMagnet)) continue;
                        TileEntityAntiMagnet tile = (TileEntityAntiMagnet)tileEntity;
                        if (tile.player.equals(this.player)) continue;
                        this.work = false;
                    }
                }
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.player = nbttagcompound.getString("player");
        this.work = nbttagcompound.getBoolean("work");
        this.x = nbttagcompound.getInt("x1");
        this.y = nbttagcompound.getInt("y1");
        this.z = nbttagcompound.getInt("z1");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putString("player", this.player);
        nbttagcompound.putBoolean("work", this.work);
        nbttagcompound.putInt("x1", this.x);
        nbttagcompound.putInt("y1", this.y);
        nbttagcompound.putInt("z1", this.z);
        return nbttagcompound;
    }

    public boolean canInsertOrExtract(ItemStack stack) {
        List<ItemStack> BlackItemStacks = this.slot.getListBlack();
        if (BlackItemStacks.isEmpty()) {
            List<ItemStack> WhiteItemStacks = this.slot.getListWhite();
            if (!WhiteItemStacks.isEmpty()) {
                for (ItemStack stack1 : WhiteItemStacks) {
                    if (!stack1.is(stack.getItem())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (ItemStack stack1 : BlackItemStacks) {
            if (!stack1.is(stack.getItem())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateData();
    }

    public void updateData() {
        this.axisalignedbb = new AABB((double)(this.getBlockPos().getX() - this.x), (double)(this.getBlockPos().getY() - this.y), (double)(this.getBlockPos().getZ() - this.z), (double)(this.getBlockPos().getX() + this.x + 1), (double)(this.getBlockPos().getY() + this.y + 1), (double)(this.getBlockPos().getZ() + this.z + 1));
        this.chunkPos = new ChunkPos(this.getPos());
        int j2 = (int)Math.floor(this.axisalignedbb.minX / 16.0);
        int k2 = (int)Math.ceil(this.axisalignedbb.maxX / 16.0);
        int l2 = (int)Math.floor(this.axisalignedbb.minZ / 16.0);
        int i3 = (int)Math.ceil(this.axisalignedbb.maxZ / 16.0);
        this.list = Lists.newArrayList();
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                LevelChunk chunk = this.getLevel().getChunk(j3, k3);
                if (this.list.contains(chunk)) continue;
                this.list.add((ChunkAccess)chunk);
            }
        }
        this.visible.aabb = this.axisalignedbb;
    }

    public List<ItemEntity> getEntitiesWithinAABB() {
        ArrayList list = Lists.newArrayList();
        LevelEntityGetter list1 = ((ServerLevel)this.level).getEntities();
        this.list.forEach(chunk -> list1.get(this.axisalignedbb.move((double)((chunk.getPos().x - this.chunkPos.x) * 16), 0.0, (double)((chunk.getPos().z - this.chunkPos.z) * 16)), p_151522_ -> {
            if (p_151522_ instanceof ItemEntity && this.axisalignedbb.contains(p_151522_.position())) {
                list.add((ItemEntity)p_151522_);
            }
        }));
        return list;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.work) {
            return;
        }
        if (this.getActive()) {
            ParticleUtils.spawnMagneticCatcherParticles(this.level, this.pos, this.level.random);
        }
        boolean ret = false;
        if (this.getWorld().getGameTime() % 4L == 0L) {
            List<ItemEntity> list = this.getEntitiesWithinAABB();
            for (ItemEntity item : list) {
                ItemStack stack;
                if (item.isRemoved() || !this.energy.canUseEnergy(this.energyconsume) || !this.outputSlot.canAdd(stack = item.getItem()) || !this.canInsertOrExtract(item.getItem())) continue;
                item.setRemoved(Entity.RemovalReason.KILLED);
                this.initiate(0);
                this.setActive(true);
                this.energy.useEnergy(this.energyconsume);
                this.outputSlot.add(stack);
                ret = true;
            }
        }
        if (this.getWorld().getGameTime() % 10L == 0L && !ret && this.getActive()) {
            this.setActive(false);
            this.initiate(2);
        }
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (event == 10.0) {
            super.updateTileServer(player, event);
        } else {
            if (event == 0.0) {
                --this.x;
                this.x = Math.max(1, this.x);
            }
            if (event == 1.0) {
                ++this.x;
                this.x = Math.min(11, this.x);
            }
            if (event == 2.0) {
                --this.y;
                this.y = Math.max(1, this.y);
            }
            if (event == 3.0) {
                ++this.y;
                this.y = Math.min(11, this.y);
            }
            if (event == 4.0) {
                --this.z;
                this.z = Math.max(1, this.z);
            }
            if (event == 5.0) {
                ++this.z;
                this.z = Math.min(11, this.z);
            }
            this.updateData();
        }
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiMagnet((ContainerMagnet)isAdmin);
    }

    public ContainerMagnet getGuiContainer(Player entityPlayer) {
        return new ContainerMagnet(entityPlayer, this);
    }
}

