/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSolidCoolMachine;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSolidCoolMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.Keyboard;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileSolidCooling
extends TileElectricMachine
implements IUpdatableTileEvent {
    public static boolean init = false;
    static Map<ItemStack, Integer> timerItem = new HashMap<ItemStack, Integer>();
    public final InvSlot slot;
    public int time;
    public CoolComponent cold = this.addComponent(CoolComponent.asBasicSource(this, 4.0, 14));
    public int max = 4;
    public boolean work;

    public TileSolidCooling(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockBaseMachine3.solid_cooling, pos, state);
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.REFRIGERATOR);
        this.time = 0;
        this.slot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                boolean find = false;
                for (Map.Entry<ItemStack, Integer> entry : timerItem.entrySet()) {
                    if (!entry.getKey().is(stack.getItem())) continue;
                    find = true;
                    break;
                }
                return find;
            }
        };
    }

    public static void init() {
        timerItem.put(new ItemStack((ItemLike)Items.SNOWBALL, 1), 2);
        timerItem.put(new ItemStack((ItemLike)Blocks.SNOW, 1), 10);
        timerItem.put(new ItemStack((ItemLike)Blocks.ICE, 1), 30);
        timerItem.put(new ItemStack((ItemLike)Blocks.PACKED_ICE, 1), 90);
        timerItem.put(new ItemStack((ItemLike)Blocks.BLUE_ICE, 1), 810);
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.max = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.time = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.max);
            EncoderHandler.encode(packet, this.work);
            EncoderHandler.encode(packet, this.time);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.solid_cooling;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.max = nbttagcompound.getInt("max");
        this.work = nbttagcompound.getBoolean("work");
        this.cold.setCapacity(this.max);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putInt("max", this.max);
        nbttagcompound.putBoolean("work", this.work);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i == 0.0) {
            this.cold.setCapacity(this.max + 4);
            if (this.cold.getCapacity() > 16.0) {
                this.cold.setCapacity(16.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 1.0) {
            this.cold.setCapacity(this.max - 4);
            if (this.cold.getCapacity() < 4.0) {
                this.cold.setCapacity(4.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 2.0) {
            boolean bl = this.work = !this.work;
        }
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        tooltip.add(Localization.translate("iu.solid_colling"));
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.time == 0 && !this.slot.isEmpty()) {
            for (Map.Entry<ItemStack, Integer> entry : timerItem.entrySet()) {
                if (!entry.getKey().is(this.slot.get(0).getItem())) continue;
                this.time = entry.getValue();
                this.slot.get(0).shrink(1);
                break;
            }
        }
        if ((this.cold.allow || this.work) && this.time > 0) {
            if (this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                --this.time;
                this.initiate(0);
                this.setActive(true);
            }
            if (this.level.getGameTime() % 400L == 0L) {
                this.initiate(2);
            }
            if (this.time == 0) {
                this.initiate(2);
                this.setActive(false);
            } else {
                this.initiate(0);
            }
        } else {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.level.getGameTime() % 20L == 0L && this.cold.getEnergy() >= 1.0) {
            this.cold.addEnergy(-1.0);
        }
    }

    public ContainerSolidCoolMachine getGuiContainer(Player entityPlayer) {
        return new ContainerSolidCoolMachine(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSolidCoolMachine((ContainerSolidCoolMachine)menu);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.cooling.getSoundEvent();
    }
}

