/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.blastfurnace.block;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBlastFurnace;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.mechanism.blastfurnace.api.IBlastInputFluid;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityFluidInput
extends TileEntityMultiBlockElement
implements IBlastInputFluid {
    private final Fluids fluids = this.addComponent(new Fluids(this));
    FluidTank tank = this.fluids.addTank("tank", 10000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.WATER}));

    public TileEntityFluidInput(BlockPos pos, BlockState state) {
        super(BlockBlastFurnace.blast_furnace_input_fluid, pos, state);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBlastFurnace.blast_furnace_input_fluid;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.blastfurnace.getBlock(this.getTeBlock().getId());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.blastfurnace.info1"));
        tooltip.add(Localization.translate("iu.blastfurnace.info3") + Localization.translate(new ItemStack(IUItem.blastfurnace.getItem(0)).getDescriptionId()));
        tooltip.add(Localization.translate("iu.blastfurnace.info4"));
        tooltip.add(Localization.translate("iu.blastfurnace.info5") + new ItemStack((ItemLike)IUItem.ForgeHammer.getItem()).getDisplayName().getString());
        tooltip.add(Localization.translate("iu.blastfurnace.info6"));
    }

    @Override
    public FluidTank getFluidTank() {
        return this.tank;
    }

    @Override
    public Fluids getFluid() {
        return this.fluids;
    }
}

