/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steamturbine.controller;

import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.steam.EnumSteamPhase;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.api.steam.Steam;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerBaseSteamTurbineController;
import com.denfop.gui.GuiBaseSteamTurbineController;
import com.denfop.gui.GuiCore;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.render.steam.SteamRod;
import com.denfop.render.windgenerator.WindGeneratorRenderer;
import com.denfop.tiles.mechanism.multiblocks.base.TileEntityMultiBlockElement;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.mechanism.steamturbine.IController;
import com.denfop.tiles.mechanism.steamturbine.IControllerRod;
import com.denfop.tiles.mechanism.steamturbine.ICoolant;
import com.denfop.tiles.mechanism.steamturbine.IExchanger;
import com.denfop.tiles.mechanism.steamturbine.IPressure;
import com.denfop.tiles.mechanism.steamturbine.IRod;
import com.denfop.tiles.mechanism.steamturbine.ISocket;
import com.denfop.tiles.mechanism.steamturbine.ITank;
import com.denfop.world.WorldBaseGen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityBaseSteamTurbineController
extends TileMultiBlockBase
implements IController,
IUpdatableTileEvent {
    private final int blocLevel;
    public List<IExchanger> listExchanger = new ArrayList<IExchanger>();
    public List<ICoolant> listCoolant = new ArrayList<ICoolant>();
    public ITank tankWater;
    public ITank tankSteam;
    public IPressure pressure;
    public List<IRod> iRodListMap = new ArrayList<IRod>();
    public EnumSteamPhase enumSteamPhase = EnumSteamPhase.ONE;
    public EnumSteamPhase stableenumSteamPhase = EnumSteamPhase.ONE;
    public int phase = 0;
    public double generation;
    public double heat;
    public boolean work;
    public Steam steam;
    public ISocket energy;
    private long lastcheck;
    private float angle;

    public TileEntityBaseSteamTurbineController(int blocLevel, IMultiTileBlock tileBlock, BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.SteamTurbineMultiBlock, tileBlock, pos, state);
        this.blocLevel = blocLevel;
    }

    @Override
    public int getBlockLevel() {
        return this.blocLevel;
    }

    @Override
    public ISocket getEnergy() {
        return this.energy;
    }

    @Override
    public List<ICoolant> getCoolant() {
        return this.listCoolant;
    }

    @Override
    public List<IExchanger> getExchanger() {
        return this.listExchanger;
    }

    public float getAngle() {
        if (this.getWorld().dimension() != Level.OVERWORLD) {
            return 0.0f;
        }
        if (this.work && this.phase > 0) {
            long k = System.currentTimeMillis() - this.lastcheck;
            this.angle = (float)((double)this.angle + Math.max(0.025, (double)((float)((double)((float)k * (float)this.phase * (float)this.enumSteamPhase.ordinal()) / 500.0))));
            this.angle %= 360.0f;
        }
        this.lastcheck = System.currentTimeMillis();
        return this.angle;
    }

    @Override
    public FluidTank getSteamFluid() {
        return this.tankSteam.getTank();
    }

    public ContainerBaseSteamTurbineController getGuiContainer(Player var1) {
        return new ContainerBaseSteamTurbineController(this, var1);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        try {
            EncoderHandler.encode(customPacketBuffer, this.getSteamFluid());
            EncoderHandler.encode(customPacketBuffer, this.getWaterFluid());
            customPacketBuffer.writeBytes((ByteBuf)this.energy.getEnergy().updateComponent());
            customPacketBuffer.writeInt(this.phase);
            customPacketBuffer.writeInt(this.enumSteamPhase.ordinal());
            customPacketBuffer.writeInt(this.stableenumSteamPhase.ordinal());
            customPacketBuffer.writeDouble(this.heat);
            customPacketBuffer.writeDouble(this.generation);
            customPacketBuffer.writeByte(this.listCoolant.size());
            for (ICoolant coolant : this.listCoolant) {
                EncoderHandler.encode(customPacketBuffer, coolant.getCoolant());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.phase = customPacketBuffer.readInt();
        this.enumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
        this.stableenumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
        this.heat = customPacketBuffer.readDouble();
        this.generation = customPacketBuffer.readDouble();
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.phase);
        customPacketBuffer.writeInt(this.enumSteamPhase.ordinal());
        customPacketBuffer.writeInt(this.stableenumSteamPhase.ordinal());
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeDouble(this.generation);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        if (!this.isFull()) {
            this.updateFull();
        }
        try {
            FluidTank fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank2 != null) {
                this.getSteamFluid().readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank2.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
            if ((fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer)) != null) {
                this.getWaterFluid().readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank2.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
            this.energy.getEnergy().onNetworkUpdate(customPacketBuffer);
            this.phase = customPacketBuffer.readInt();
            this.enumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
            this.stableenumSteamPhase = EnumSteamPhase.values()[customPacketBuffer.readInt()];
            this.heat = customPacketBuffer.readDouble();
            this.generation = customPacketBuffer.readDouble();
            int col = customPacketBuffer.readByte();
            for (int i = 0; i < col; ++i) {
                ICoolant coolant = this.listCoolant.get(i);
                fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
                if (fluidTank2 == null) continue;
                coolant.getCoolant().readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank2.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiBaseSteamTurbineController((ContainerBaseSteamTurbineController)menu);
    }

    @Override
    public FluidTank getWaterFluid() {
        return this.tankWater.getTank();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(TileMultiBlockBase tileEntityMultiBlockBase, RenderLevelStageEvent event) {
        super.render(tileEntityMultiBlockBase, event);
        if (this.isFull()) {
            int diameter = 2;
            BlockPos prev = this.pos;
            SteamRod model = WindGeneratorRenderer.rotorModels.get(diameter);
            if (model == null) {
                model = new SteamRod(diameter);
                WindGeneratorRenderer.rotorModels.put(diameter, model);
            }
            if (!(model instanceof SteamRod)) {
                model = new SteamRod(diameter);
                WindGeneratorRenderer.rotorModels.replace(diameter, model);
            }
            if (this.iRodListMap.isEmpty()) {
                List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRod.class);
                for (BlockPos pos2 : pos1) {
                    this.iRodListMap.add((IRod)this.getWorld().getBlockEntity(pos2));
                }
            }
            PoseStack poseStack = event.getPoseStack();
            for (IRod rod : this.iRodListMap) {
                BlockPos pos = rod.getBlockPos();
                poseStack.pushPose();
                float angle = this.getAngle();
                poseStack.translate((float)(pos.getX() - prev.getX()), (float)(pos.getY() - prev.getY()), (float)(pos.getZ() - prev.getZ()));
                Direction facing = this.getFacing();
                switch (facing) {
                    case NORTH: {
                        poseStack.translate(0.0f, 0.5f, 0.0f);
                        if (facing.getAxis() == Direction.Axis.X) {
                            poseStack.mulPose(Axis.XP.rotationDegrees(angle));
                        } else if (facing.getAxis() == Direction.Axis.Z) {
                            poseStack.mulPose(Axis.ZP.rotationDegrees(angle));
                        }
                        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.translate(0.0f, 0.5f, 0.0f);
                        if (facing.getAxis() != Direction.Axis.X) break;
                        poseStack.mulPose(Axis.XP.rotationDegrees(angle));
                        break;
                    }
                    case SOUTH: {
                        poseStack.translate(0.0f, 0.5f, 0.0f);
                        if (facing.getAxis() == Direction.Axis.X) {
                            poseStack.mulPose(Axis.XP.rotationDegrees(angle));
                        } else if (facing.getAxis() == Direction.Axis.Z) {
                            poseStack.mulPose(Axis.ZP.rotationDegrees(angle));
                        }
                        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.translate(0.25f, 0.5f, 0.0f);
                        if (facing.getAxis() == Direction.Axis.X) {
                            poseStack.mulPose(Axis.XP.rotationDegrees(angle));
                            break;
                        }
                        if (facing.getAxis() != Direction.Axis.Z) break;
                        poseStack.mulPose(Axis.ZP.rotationDegrees(angle));
                    }
                }
                for (ISteamBlade steamBlade : rod.getRods()) {
                    ResourceLocation rotorRL = steamBlade.getTexture();
                    GuiCore.bindTexture(rotorRL);
                    VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)rotorRL));
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    event.getLevelRenderer();
                    int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)this.getLevel(), (BlockPos)pos);
                    if (facing == Direction.EAST || facing == Direction.WEST) {
                        if (facing.getAxis() == Direction.Axis.X) {
                            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                        } else if (facing.getAxis() == Direction.Axis.Z) {
                            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                        }
                    } else {
                        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    }
                    model.renderToBuffer(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
                }
                poseStack.popPose();
            }
        }
    }

    @Override
    public EnumSteamPhase getSteamPhase() {
        return this.enumSteamPhase;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && this.work) {
            if (this.getWorld().getGameTime() % 20L == 0L) {
                if (this.steam.getCoef() > 0.0) {
                    this.steam.onTick();
                    for (IExchanger exchanger : this.listExchanger) {
                        if (exchanger.getExchanger() == null) continue;
                        this.removeHeat(exchanger.getPower());
                        boolean update = exchanger.getExchanger().damageItem(exchanger.getSlot().get(0), -1);
                        if (!update) continue;
                        exchanger.getSlot().set(0, ItemStack.EMPTY);
                    }
                }
                if (this.getWorld().getGameTime() % 120L == 0L) {
                    this.removePhase(WorldBaseGen.random.nextInt(this.blocLevel + 2));
                }
                this.steam.updateData();
            }
            this.generation = this.steam.getGeneration();
            this.energy.getEnergy().addEnergy(this.generation);
            this.energy.getEnergy().setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.generation));
        } else {
            this.generation = 0.0;
            if (this.getWorld().getGameTime() % 60L == 0L) {
                this.removePhase(WorldBaseGen.random.nextInt(this.blocLevel + 2));
            }
        }
    }

    @Override
    public void addPhase(int phase) {
        int oldphase = this.phase;
        this.phase += phase;
        if (oldphase != this.phase) {
            new PacketUpdateFieldTile(this, "phase", this.phase);
        }
        if (this.enumSteamPhase == this.stableenumSteamPhase && this.phase > this.enumSteamPhase.getMax()) {
            this.phase = this.enumSteamPhase.getMax();
        }
        if (this.phase < this.enumSteamPhase.getMin() || this.phase > this.enumSteamPhase.getMax()) {
            EnumSteamPhase old = this.enumSteamPhase;
            this.recalculatePhase();
            if (old != this.enumSteamPhase) {
                new PacketUpdateFieldTile(this, "enumSteamPhase", this.enumSteamPhase.ordinal());
            }
        }
        if (this.phase > this.enumSteamPhase.getMax()) {
            this.phase = this.enumSteamPhase.getMax();
        }
    }

    private void recalculatePhase() {
        for (EnumSteamPhase enumSteamPhase1 : EnumSteamPhase.values()) {
            if (this.phase < enumSteamPhase1.getMin() || this.phase > enumSteamPhase1.getMax()) continue;
            this.enumSteamPhase = enumSteamPhase1;
            break;
        }
    }

    @Override
    public void removePhase(int phase) {
        int oldphase = this.phase;
        this.phase -= phase;
        if (this.phase < 0) {
            this.phase = 0;
        }
        if (oldphase != this.phase) {
            new PacketUpdateFieldTile(this, "phase", this.phase);
        }
        if (this.phase < this.enumSteamPhase.getMin() || this.phase > this.enumSteamPhase.getMax()) {
            EnumSteamPhase old = this.enumSteamPhase;
            this.recalculatePhase();
            if (old != this.enumSteamPhase) {
                new PacketUpdateFieldTile(this, "enumSteamPhase", this.enumSteamPhase.ordinal());
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.trim().equals("phase")) {
            try {
                this.phase = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.trim().equals("enumSteamPhase")) {
            try {
                this.enumSteamPhase = EnumSteamPhase.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound = super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("work", this.work);
        nbttagcompound.putByte("enumSteamPhase", (byte)this.enumSteamPhase.ordinal());
        nbttagcompound.putByte("stableenumSteamPhase", (byte)this.stableenumSteamPhase.ordinal());
        nbttagcompound.putShort("phase", (short)this.phase);
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.getBoolean("work");
        this.enumSteamPhase = EnumSteamPhase.values()[nbttagcompound.getByte("enumSteamPhase")];
        this.stableenumSteamPhase = EnumSteamPhase.values()[nbttagcompound.getByte("stableenumSteamPhase")];
        this.phase = nbttagcompound.getShort("phase");
    }

    @Override
    public void updateInfo() {
        this.iRodListMap.forEach(IRod::updateBlades);
    }

    @Override
    public int getPressure() {
        return this.pressure.getPressure();
    }

    @Override
    public List<IRod> getInfo() {
        return this.iRodListMap;
    }

    @Override
    public boolean isWork() {
        return this.work;
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.iRodListMap.clear();
            this.listCoolant.clear();
            this.listExchanger.clear();
            this.pressure = null;
            this.tankWater = null;
            this.tankSteam = null;
            this.energy = null;
        }
    }

    @Override
    public void setGeneration(double generation) {
        this.generation = generation;
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public void removeHeat(double heat) {
        this.heat -= heat;
        if (this.heat < 0.0) {
            this.heat = 0.0;
        }
    }

    @Override
    public void addHeat(double heat) {
        this.heat += heat;
        if (this.heat > this.getMaxHeat()) {
            this.heat = this.getMaxHeat();
        }
    }

    @Override
    public double getMaxHeat() {
        return 500.0;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0) {
            this.work = !this.work;
        } else if (var2 < 0.0) {
            double index = var2 * -1.0 - 1.0;
            EnumSteamPhase[] values = EnumSteamPhase.values();
            this.stableenumSteamPhase = values[(int)index];
        }
    }

    @Override
    public EnumSteamPhase getStableSteamPhase() {
        return this.stableenumSteamPhase;
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IPressure.class);
        this.pressure = (IPressure)this.getWorld().getBlockEntity(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        this.energy = (ISocket)this.getWorld().getBlockEntity(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        this.tankWater = (ITank)this.getWorld().getBlockEntity(pos1.get(0));
        this.tankWater.setWaterTank();
        this.tankWater.clear(false);
        this.tankSteam = (ITank)this.getWorld().getBlockEntity(pos1.get(1));
        this.tankSteam.setSteamTank();
        this.tankSteam.clear(true);
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ICoolant.class);
        for (BlockPos pos2 : pos1) {
            this.listCoolant.add((ICoolant)this.getWorld().getBlockEntity(pos2));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IExchanger.class);
        for (BlockPos pos2 : pos1) {
            this.listExchanger.add((IExchanger)this.getWorld().getBlockEntity(pos2));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRod.class);
        for (BlockPos pos2 : pos1) {
            this.iRodListMap.add((IRod)this.getWorld().getBlockEntity(pos2));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IControllerRod.class);
        IControllerRod controllerRod = (IControllerRod)this.getWorld().getBlockEntity(pos1.get(0));
        controllerRod.setList(this.iRodListMap);
        this.steam = new Steam(this);
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer customPacketBuffer = super.writeUpdatePacket();
        customPacketBuffer.writeBoolean(this.isFull());
        if (this.isFull()) {
            for (IRod rod : this.iRodListMap) {
                customPacketBuffer.writeBlockPos(rod.getBlockPos());
                customPacketBuffer.writeBytes((ByteBuf)((TileEntityMultiBlockElement)((Object)rod)).writePacket());
            }
        }
        return customPacketBuffer;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
        boolean isFull = packetBuffer.readBoolean();
        if (isFull) {
            this.iRodListMap.clear();
            for (int i = 0; i < 9; ++i) {
                TileEntityMultiBlockElement multiBlockElement = (TileEntityMultiBlockElement)this.getWorld().getBlockEntity(packetBuffer.readBlockPos());
                packetBuffer.readShort();
                multiBlockElement.readPacket(packetBuffer);
                this.iRodListMap.add((IRod)((Object)multiBlockElement));
            }
            List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IControllerRod.class);
            IControllerRod controllerRod = (IControllerRod)this.getWorld().getBlockEntity(pos1.get(0));
            controllerRod.setList(this.iRodListMap);
        }
    }

    @Override
    public void usingBeforeGUI() {
    }
}

