/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.panels.entity;

import com.denfop.ElectricItem;
import com.denfop.Localization;
import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.SunCoef;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.tile.IWrenchable;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.componets.ComponentPollution;
import com.denfop.componets.ComponentTimer;
import com.denfop.componets.WirelessComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSolarPanels;
import com.denfop.container.ContainerSolarPanels1;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSolarPanels;
import com.denfop.gui.GuiSolarPanels1;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotPanel;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketChangeSolarPanel;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.panels.entity.EnumSolarPanels;
import com.denfop.tiles.panels.entity.EnumType;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class TileSolarPanel
extends TileEntityInventory
implements IEnergySource,
IWrenchable,
IUpdatableTileEvent {
    public static List<BlockEntityType<? extends TileSolarPanel>> list = new ArrayList<BlockEntityType<? extends TileSolarPanel>>();
    public final ComponentTimer timer;
    public final ComponentPollution pollution;
    public final WirelessComponent wirelessComponent;
    public final InvSlot slotDept;
    public double coef;
    public EnumSolarPanels solarpanels;
    public int tier;
    public InvSlotPanel inputslot;
    public Holder<Biome> biome;
    public int solarType = 0;
    public EnumType type;
    public boolean charge;
    public GenerationState activeState = GenerationState.NONE;
    public boolean wetBiome;
    public boolean noSunWorld;
    public boolean rain;
    public boolean sunIsUp;
    public boolean skyIsVisible;
    public double generating;
    public double genDay;
    public double genNight;
    public double storage;
    public double output;
    public double maxStorage;
    public double defaultMaxStorage;
    public double defaultDay;
    public double defaultNight;
    public double defaultOutoput;
    public double defaultTier;
    public double moonPhase = 1.0;
    public SunCoef sunCoef;
    public byte percent = 0;
    public double debt;
    public double debtMax;
    public int levelPanel = 0;
    public boolean canRain;
    public boolean hasSky;
    public double deptPercent;
    public double deptGenerate = 0.0;
    public boolean addedToEnergyNet = false;
    public boolean twoContainer = false;
    protected double pastEnergy;
    protected double perenergy;
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    int hashCodeSource;
    private long id;

    public TileSolarPanel(int tier, double gDay, double gOutput, double gmaxStorage, EnumSolarPanels type, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.genDay = gDay;
        this.genNight = gDay / 2.0;
        if (this.genNight < 1.0) {
            this.genNight = 0.0;
        }
        this.storage = 0.0;
        this.generating = 0.0;
        this.maxStorage = gmaxStorage;
        this.defaultMaxStorage = gmaxStorage;
        this.defaultDay = gDay;
        this.defaultNight = gDay / 2.0;
        if (this.defaultNight < 1.0) {
            this.defaultNight = 0.0;
        }
        this.debtMax = this.maxStorage * 4.0;
        this.output = gOutput;
        this.defaultOutoput = gOutput;
        this.tier = tier;
        this.defaultTier = tier;
        this.inputslot = new InvSlotPanel(this, tier, 9, InvSlot.TypeItemSlot.INPUT_OUTPUT);
        this.type = EnumType.DEFAULT;
        this.solarpanels = type;
        this.coef = 0.0;
        this.pastEnergy = 0.0;
        this.perenergy = 0.0;
        this.pollution = this.addComponent(new ComponentPollution(this));
        this.timer = this.addComponent(new ComponentTimer(this, this, new Timer[]{new Timer(8, 0, 0), new Timer(4, 0, 0), new Timer(4, 0, 0)}){

            @Override
            public boolean needWriteNBTToDrops() {
                return true;
            }
        });
        this.pollution.setTimer(this.timer);
        this.wirelessComponent = this.addComponent(new WirelessComponent(this));
        this.wirelessComponent.setEnergySource(this);
        this.slotDept = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof IEnergyItem && ((IEnergyItem)stack.getItem()).canProvideEnergy(stack);
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.BATTERY;
            }
        };
        if (list != null && pos.equals((Object)BlockPos.ZERO)) {
            list.add(block.getBlockType());
        }
    }

    public TileSolarPanel(EnumSolarPanels solarpanels, IMultiTileBlock block, BlockPos pos, BlockState state) {
        this(solarpanels.tier, solarpanels.genday, solarpanels.producing, solarpanels.maxstorage, solarpanels, block, pos, state);
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.getOpposite()));
        }
    }

    @Override
    public Map<Direction, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.pollution, false);
            EncoderHandler.encode(packet, this.timer, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.pollution.onNetworkUpdate(customPacketBuffer);
            this.timer.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.deptPercent = customPacketBuffer.readDouble();
            this.debt = customPacketBuffer.readDouble();
            this.sunIsUp = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.skyIsVisible = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.generating = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genDay = (Double)DecoderHandler.decode(customPacketBuffer);
            this.genNight = (Double)DecoderHandler.decode(customPacketBuffer);
            this.storage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.maxStorage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.output = (Double)DecoderHandler.decode(customPacketBuffer);
            this.rain = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.solarType = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.type = EnumType.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.defaultOutoput = (Double)DecoderHandler.decode(customPacketBuffer);
            this.defaultMaxStorage = (Double)DecoderHandler.decode(customPacketBuffer);
            this.defaultDay = (Double)DecoderHandler.decode(customPacketBuffer);
            this.defaultNight = (Double)DecoderHandler.decode(customPacketBuffer);
            this.tier = (Integer)DecoderHandler.decode(customPacketBuffer);
            boolean isNull = (Boolean)DecoderHandler.decode(customPacketBuffer);
            if (!isNull) {
                this.solarpanels = EnumSolarPanels.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            }
            this.activeState = GenerationState.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            packet.writeDouble(this.deptPercent);
            packet.writeDouble(this.debt);
            EncoderHandler.encode(packet, this.sunIsUp);
            EncoderHandler.encode(packet, this.skyIsVisible);
            EncoderHandler.encode(packet, this.generating);
            EncoderHandler.encode(packet, this.genDay);
            EncoderHandler.encode(packet, this.genNight);
            EncoderHandler.encode(packet, this.storage);
            EncoderHandler.encode(packet, this.maxStorage);
            EncoderHandler.encode(packet, this.output);
            EncoderHandler.encode(packet, this.rain);
            EncoderHandler.encode(packet, this.solarType);
            EncoderHandler.encode(packet, (Object)this.type);
            EncoderHandler.encode(packet, this.defaultOutoput);
            EncoderHandler.encode(packet, this.defaultMaxStorage);
            EncoderHandler.encode(packet, this.defaultDay);
            EncoderHandler.encode(packet, this.defaultNight);
            EncoderHandler.encode(packet, this.tier);
            EncoderHandler.encode(packet, this.solarpanels == null);
            if (this.solarpanels != null) {
                EncoderHandler.encode(packet, (Object)this.solarpanels);
            }
            EncoderHandler.encode(packet, (Object)this.activeState);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        this.inputslot.wirelessmodule();
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    public List<ItemStack> getDrop() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            if (this.inputslot.get(i).isEmpty()) continue;
            list.add(this.inputslot.get(i));
        }
        return list;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> info) {
        if (this.getWorld() == null || this.getBlockPos().equals((Object)BlockPos.ZERO)) {
            info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.genDay) + " EF/t ");
            info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.genNight) + " EF/t ");
        } else if (this.getWorld().isDay()) {
            info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.generating) + " EF/t ");
            info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.genNight) + " EF/t ");
        } else {
            info.add(Localization.translate("supsolpans.iu.GenerationDay.tooltip") + " " + ModUtils.getString(this.genDay) + " EF/t ");
            info.add(Localization.translate("supsolpans.iu.GenerationNight.tooltip") + " " + ModUtils.getString(this.generating) + " EF/t ");
        }
        info.add(Localization.translate("iu.item.tooltip.Output") + " " + ModUtils.getString(this.output) + " EF/t ");
        info.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.maxStorage) + " EF ");
        info.add(Localization.translate("iu.tier") + ModUtils.getString(this.tier));
    }

    public EnumSolarPanels getPanels() {
        return this.solarpanels;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void gainFuel() {
        double coefpollution = 1.0;
        switch (this.timer.getIndexWork()) {
            case -1: {
                coefpollution = 0.25;
                break;
            }
            case 1: {
                coefpollution = 0.75;
                break;
            }
            case 2: {
                coefpollution = 0.5;
            }
        }
        switch (this.activeState.ordinal()) {
            case 0: {
                this.generating = this.type.coefficient_day * this.genDay;
                break;
            }
            case 1: {
                this.generating = this.type.coefficient_night * this.genNight;
                break;
            }
            case 2: {
                this.generating = this.type.coefficient_rain * this.type.coefficient_day * this.genDay;
                break;
            }
            case 3: {
                this.generating = this.type.coefficient_rain * this.type.coefficient_night * this.genNight;
                break;
            }
            case 4: {
                this.generating = this.type.coefficient_nether * this.genDay;
                break;
            }
            case 5: {
                this.generating = this.type.coefficient_end * this.genDay;
                break;
            }
            case 6: {
                this.generating = 0.0;
            }
        }
        double coefficient_phase = this.experimental_generating();
        double coef = this.moonPhase;
        if (this.sunIsUp) {
            coef = 1.0;
        }
        this.generating *= coefpollution * coefficient_phase * coef;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        drop = Collections.singletonList(this.adjustDrop(drop.get(0), wrench, fortune));
        return drop;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench, int fortune) {
        drop = super.adjustDrop(drop, wrench, fortune);
        if (wrench || this.teBlock.getDefaultDrop() == DefaultDrop.Self) {
            CompoundTag nbt = ModUtils.nbt(drop);
            if (fortune == 100) {
                nbt.remove(this.timer.toString());
            }
        }
        return drop;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.getWorld().isClientSide() && this.addedToEnergyNet) {
            NeoForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), this));
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide()) {
            this.biome = this.getWorld().getBiome(this.pos);
            this.canRain = ((Biome)this.biome.value()).getPrecipitationAt(this.pos) == Biome.Precipitation.RAIN || ((Biome)this.biome.value()).getModifiedClimateSettings().downfall() > 0.0f;
            this.hasSky = this.getLevel().dimension() != Level.NETHER;
            this.updateVisibility();
            this.inputslot.checkmodule();
            this.solarType = this.inputslot.solartype();
            IAdvEnergyNet advEnergyNet = EnergyNetGlobal.instance;
            this.sunCoef = advEnergyNet.getSunCoefficient(this.getWorld());
            if (!this.addedToEnergyNet) {
                this.energyConductorMap.clear();
                this.addedToEnergyNet = true;
                this.validReceivers.clear();
                NeoForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), this));
            }
        }
    }

    private double experimental_generating() {
        if (this.sunCoef == null) {
            this.sunCoef = EnergyNetGlobal.instance.getSunCoefficient(this.getWorld());
        }
        double k = this.sunCoef.getCoef();
        double coef = this.coef;
        return Math.max(coef, k);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.storage = nbttagcompound.getDouble("storage");
        this.debt = nbttagcompound.getDouble("debt");
        this.deptPercent = nbttagcompound.getDouble("deptPercent");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putDouble("storage", this.storage);
        nbttagcompound.putDouble("debt", this.debt);
        nbttagcompound.putDouble("deptPercent", this.deptPercent);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.debt > 0.0 && !this.slotDept.isEmpty()) {
            double amount = ElectricItem.manager.discharge(this.slotDept.get(0), this.debt, this.tier, false, false, false);
            this.debt -= amount;
        }
        if (this.getWorld().getGameTime() % 40L == 0L) {
            this.updateVisibility();
            this.solarType = this.inputslot.solartypeFast();
            if (this.solarType == 0) {
                this.setActive("");
            } else {
                this.setActive(EnumType.getFromID(this.solarType).getNameType());
            }
        }
        if (this.charge) {
            this.inputslot.charge();
        }
        if (this.activeState == GenerationState.NONE) {
            this.generating = 0.0;
            return;
        }
        this.gainFuel();
        if (this.generating > 0.0) {
            if (this.storage + this.generating <= this.maxStorage) {
                double tempGenerate = this.generating + this.generating * this.deptPercent / 100.0;
                if (this.deptPercent < 0.0) {
                    this.debt += this.generating * this.deptPercent / 100.0;
                    if (this.debt < 0.0) {
                        this.debt = 0.0;
                    }
                } else {
                    this.debt += this.generating * this.deptPercent / 200.0;
                    if (this.debt >= this.debtMax) {
                        this.debt = this.debtMax;
                    }
                }
                this.generating = tempGenerate;
                if (this.debt < this.debtMax) {
                    this.storage += this.generating;
                } else if (this.solarpanels != null && this.solarpanels.solarold != null) {
                    new PacketChangeSolarPanel(this.solarpanels, this);
                }
            } else {
                this.storage = this.maxStorage;
            }
        }
    }

    public void updateVisibility() {
        if (this.biome == null) {
            this.biome = this.getLevel().getBiome(this.pos);
        }
        this.wetBiome = ((Biome)this.biome.value()).getModifiedClimateSettings().downfall() > 0.0f;
        this.noSunWorld = this.getLevel().dimension() == Level.NETHER;
        this.rain = this.wetBiome && (this.getLevel().isRaining() || this.getLevel().isThundering());
        this.sunIsUp = this.getLevel().isDay();
        boolean bl = this.skyIsVisible = this.getLevel().canSeeSky(this.worldPosition) && this.getLevel().getBlockState(this.worldPosition.above()).getMapColor((BlockGetter)this.getLevel(), this.worldPosition.above()) == MapColor.NONE && !this.noSunWorld;
        if (!this.skyIsVisible) {
            this.activeState = GenerationState.NONE;
        }
        if (this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? GenerationState.DAY : GenerationState.RAINDAY;
        }
        if (!this.sunIsUp && this.skyIsVisible) {
            this.activeState = !this.rain ? GenerationState.NIGHT : GenerationState.RAINNIGHT;
        }
        if (this.level.dimension() == Level.END) {
            this.activeState = GenerationState.END;
        }
        if (this.level.dimension() == Level.NETHER) {
            this.activeState = GenerationState.NETHER;
        }
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, Direction side) {
        return true;
    }

    @Override
    public void extractEnergy(double amount) {
        this.storage -= amount;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public List<ItemStack> getWrenchDrops(Level world, BlockPos blockPos, BlockState iBlockState, BlockEntity tileEntity, Player entityPlayer, int i) {
        return new ArrayList<ItemStack>(this.inputslot);
    }

    @Override
    public void wrenchBreak(Level world, BlockPos pos) {
        this.wrenchBreak();
    }

    @Override
    public Direction getFacing(Level world, BlockPos blockPos) {
        return this.getFacing();
    }

    @Override
    public boolean setFacing(Level world, BlockPos blockPos, Direction enumFacing, Player entityPlayer) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        return super.canEntityDestroy(entity) && this.debt == 0.0;
    }

    @Override
    public boolean wrenchCanRemove(Level world, BlockPos blockPos, Player entityPlayer) {
        return this.getComponentPrivate().wrenchCanRemove(entityPlayer) && this.debt == 0.0;
    }

    @Override
    public ContainerBase<TileSolarPanel> getGuiContainer(Player player) {
        if (this.twoContainer) {
            return new ContainerSolarPanels1(player, this);
        }
        return new ContainerSolarPanels(player, this);
    }

    @Override
    public double canExtractEnergy() {
        return Math.min(this.output, this.storage);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player player, ContainerBase<? extends IAdvInventory> isAdmin) {
        if (this.twoContainer) {
            this.twoContainer = false;
            ((ContainerSolarPanels1)isAdmin).tileentity.twoContainer = false;
            return new GuiSolarPanels1((ContainerSolarPanels1)isAdmin);
        }
        return new GuiSolarPanels((ContainerSolarPanels)isAdmin);
    }

    public double gaugeEnergyScaled(float i) {
        if (this.storage * (double)i / this.maxStorage > 84.0) {
            return 84.0;
        }
        return (float)(this.storage * (double)i / this.maxStorage);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.solarType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.solarType = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (event == 1000.0) {
            this.twoContainer = true;
            this.onActivated(player, player.getUsedItemHand(), Direction.NORTH, new Vec3(0.0, 0.0, 0.0));
        } else {
            this.deptPercent = event;
        }
    }

    public EnumType getTypePanel() {
        return this.type;
    }

    public void setType(EnumType type) {
        this.type = type;
    }

    public int setSolarType(EnumType type) {
        if (type == null) {
            this.setType(EnumType.DEFAULT);
            return 0;
        }
        this.setType(type);
        switch (type) {
            case AIR: {
                if (this.pos.getY() < 130) break;
                return 1;
            }
            case EARTH: {
                if (this.pos.getY() > 40) break;
                return 2;
            }
            case NETHER: {
                if (this.getLevel().dimension() != Level.NETHER) break;
                return 3;
            }
            case END: {
                if (this.getLevel().dimension() != Level.END) break;
                return 4;
            }
            case NIGHT: {
                if (this.sunIsUp) break;
                return 5;
            }
            case DAY: {
                if (!this.sunIsUp) break;
                return 6;
            }
            case RAIN: {
                if (!this.getLevel().isRaining() && !this.getLevel().isThundering()) break;
                return 7;
            }
        }
        this.setType(EnumType.DEFAULT);
        return 0;
    }

    @Override
    public double getPerEnergy() {
        return this.perenergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    public boolean canRender() {
        return true;
    }

    public static enum GenerationState {
        DAY,
        NIGHT,
        RAINDAY,
        RAINNIGHT,
        NETHER,
        END,
        NONE;

    }
}

