/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.toast;

import com.denfop.Localization;
import com.denfop.api.guidebook.Quest;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class GuideToast
implements Toast {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private final Quest quest;
    private boolean visible = false;

    public GuideToast(Quest quest) {
        this.quest = quest;
    }

    public Toast.Visibility render(GuiGraphics pGuiGraphics, ToastComponent toastComponent, long time) {
        Minecraft mc = toastComponent.getMinecraft();
        pGuiGraphics.blitSprite(TEXTURE, 0, 0, this.width(), this.height());
        ItemStack icon = this.quest.icon;
        pGuiGraphics.renderFakeItem(icon, 8, 8);
        pGuiGraphics.drawString(toastComponent.getMinecraft().font, String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.quest.completed"), 30, 7, -1, false);
        pGuiGraphics.drawString(toastComponent.getMinecraft().font, this.quest.getLocalizedName(), 30, 18, -1, false);
        return time >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

