/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.Tags;

public class RubTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public RubTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected boolean canGrowInto(Block blockType) {
        BlockState material = blockType.defaultBlockState();
        return material.isAir() || material.is(BlockTags.LEAVES) || blockType == Blocks.GRASS_BLOCK || blockType == Blocks.DIRT || blockType.defaultBlockState().is(BlockTags.LOGS) || blockType.defaultBlockState().is(BlockTags.LEAVES) || blockType.defaultBlockState().is(BlockTags.SAPLINGS) || blockType == Blocks.VINE || blockType == IUItem.rubWood.getBlock().get() || blockType == IUItem.leaves.getBlock().get() || blockType == IUItem.rubberSapling.getBlock().get();
    }

    public boolean placeInstantly(ServerLevel pLevel, ChunkGenerator generator, BlockState pState, RandomSource pRandom, BlockPos pPos) {
        int i = pRandom.nextInt(5) + pRandom.nextInt(4) + pRandom.nextInt(2);
        ServerLevel worldIn = pLevel;
        BlockPos position = pPos;
        RandomSource rand = pRandom;
        if (i <= 3) {
            i = 4;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockState state = worldIn.getBlockState(position.offset(x, 0, z));
                if (state.getMapColor((BlockGetter)pLevel, position.offset(x, 0, z)) != MapColor.WOOD && state.getBlock() != IUItem.rubWood.getBlock().get()) continue;
                return false;
            }
        }
        boolean flag = true;
        Block woodBlock = (Block)IUItem.rubWood.getBlock().get();
        BlockState leaves = IUItem.leaves.getDefaultState();
        if (position.getY() >= 1 && position.getY() + i + 1 <= 256) {
            boolean isSoil;
            for (int j = position.getY(); j <= position.getY() + 1 + i; ++j) {
                int k = 1;
                if (j == position.getY()) {
                    k = 0;
                }
                if (j >= position.getY() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.getX() - k; l <= position.getX() + k && flag; ++l) {
                    for (int i1 = position.getZ() - k; i1 <= position.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getHeight()) {
                            if (this.isReplaceable((WorldGenLevel)worldIn, (BlockPos)blockpos$mutableblockpos.set(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.below();
            BlockState state = worldIn.getBlockState(down);
            boolean bl = isSoil = state.getBlock() == Blocks.GRASS_BLOCK || state.getBlock() == Blocks.DIRT;
            if (isSoil && position.getY() < worldIn.getHeight() - i - 1) {
                this.onPlantGrow(state, (WorldGenLevel)worldIn, down, position);
                Holder biome = worldIn.getBiome(position);
                if (!biome.is(Tags.Biomes.IS_SWAMP) && !biome.is(BiomeTags.IS_JUNGLE)) {
                    for (int i2 = position.getY() - i / 2 + i; i2 <= position.getY() + i + 1 + rand.nextInt(3); ++i2) {
                        int i3;
                        BlockPos blockpos;
                        BlockState state2;
                        int l1;
                        int k1;
                        BlockState state22;
                        BlockPos blockpos2;
                        int[][] offsets;
                        int k2 = i2 - (position.getY() + i + 1);
                        int l2 = 3;
                        if (i2 >= position.getY() + i) {
                            l2 = 1;
                        }
                        if (i2 == position.getY() + i) {
                            for (int[] offset : offsets = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}}) {
                                blockpos2 = new BlockPos(position.getX() + offset[0], i2, position.getZ() + offset[1]);
                                state22 = worldIn.getBlockState(blockpos2);
                                if (!state22.isAir()) continue;
                                worldIn.setBlock(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.getY() - i / 2 + i + 1) {
                            l2 = 3;
                            for (int[] offset : offsets = new int[][]{{-2, 0}, {0, -2}, {2, 0}, {0, 2}}) {
                                blockpos2 = new BlockPos(position.getX() + offset[0], i2, position.getZ() + offset[1]);
                                state22 = worldIn.getBlockState(blockpos2);
                                if (!state22.isAir()) continue;
                                worldIn.setBlock(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.getY() - i / 2 + i) {
                            l2 = 4;
                            if (i > 6) {
                                int i32;
                                for (i32 = position.getX() - l2 / 2; i32 <= position.getX() + l2 / 2; ++i32) {
                                    int j1 = i32 - position.getX();
                                    for (k1 = position.getZ() - l2 / 2; k1 <= position.getZ() + l2 / 2; ++k1) {
                                        l1 = k1 - position.getZ();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i32, i2 - 1, k1))).isAir()) continue;
                                        worldIn.setBlock(blockpos, leaves, 3);
                                    }
                                }
                                for (i32 = position.getX() - 2; i32 <= position.getX() + 2; i32 += 4) {
                                    int j1 = i32 - position.getX();
                                    for (k1 = position.getZ() - 2; k1 <= position.getZ() + 2; k1 += 4) {
                                        l1 = k1 - position.getZ();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i32, i2 - 1, k1))).isAir()) continue;
                                        this.setBlock((LevelWriter)worldIn, blockpos, Blocks.AIR.defaultBlockState());
                                    }
                                }
                            }
                            l2 = 4;
                        }
                        for (i3 = position.getX() - l2 / 2; i3 <= position.getX() + l2 / 2; ++i3) {
                            int j1 = i3 - position.getX();
                            for (k1 = position.getZ() - l2 / 2; k1 <= position.getZ() + l2 / 2; ++k1) {
                                l1 = k1 - position.getZ();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i3, i2, k1))).isAir()) continue;
                                this.setBlock((LevelWriter)worldIn, blockpos, leaves);
                            }
                        }
                        if (i2 != position.getY() - i / 2 + i) continue;
                        for (i3 = position.getX() - 2; i3 <= position.getX() + 2; i3 += 4) {
                            int j1 = i3 - position.getX();
                            for (k1 = position.getZ() - 2; k1 <= position.getZ() + 2; k1 += 4) {
                                l1 = k1 - position.getZ();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i3, i2, k1))).isAir()) continue;
                                this.setBlock((LevelWriter)worldIn, blockpos, Blocks.AIR.defaultBlockState());
                            }
                        }
                    }
                    int treeholechance = 40;
                    for (int j2 = 0; j2 < i; ++j2) {
                        BlockPos upN = position.above(j2);
                        BlockState state2 = worldIn.getBlockState(upN);
                        if (!state2.isAir() && !state2.is(BlockTags.LEAVES) && state2.getBlock() != IUItem.rubberSapling.getBlock().get()) continue;
                        if (rand.nextInt(100) <= treeholechance) {
                            treeholechance -= 10;
                            this.setBlock((LevelWriter)worldIn, position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                            continue;
                        }
                        this.setBlock((LevelWriter)worldIn, position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)));
                    }
                } else {
                    if (biome.is(Tags.Biomes.IS_SWAMP)) {
                        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                        boolean create = this.createSwampTree(WorldBaseGen.random, position, (WorldGenLevel)worldIn, map);
                        if (create) {
                            for (Map.Entry entry : map.entrySet()) {
                                this.setBlock((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                            }
                        }
                        return create;
                    }
                    HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                    boolean create = this.createRubTree(WorldBaseGen.random, position, (WorldGenLevel)worldIn, map);
                    if (create) {
                        for (Map.Entry entry : map.entrySet()) {
                            this.setBlock((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                        }
                    }
                    return create;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> p_159749_) {
        int rubberTrees;
        LinkedList<Holder> biomes = new LinkedList<Holder>();
        ChunkPos chunkPos = new ChunkPos(p_159749_.origin());
        for (rubberTrees = 0; rubberTrees < 5; ++rubberTrees) {
            int x = chunkPos.getMinBlockX() + 8 + (rubberTrees & 2) * 15;
            int z = chunkPos.getMinBlockZ() + 8 + ((rubberTrees & 2) >>> 1) * 15;
            int y = p_159749_.level().getHeight(Heightmap.Types.WORLD_SURFACE_WG, x, z);
            BlockPos pos = new BlockPos(x, y, z);
            ChunkAccess chunkAccess = p_159749_.level().getChunk(chunkPos.x, chunkPos.z, ChunkStatus.EMPTY);
            Holder biome = chunkAccess.getNoiseBiome(x >> 2, y >> 2, z >> 2);
            biomes.add(biome);
        }
        rubberTrees = 0;
        for (Holder biome : biomes) {
            if (biome == null) continue;
            if (biome.is(Tags.Biomes.IS_SWAMP)) {
                rubberTrees += WorldBaseGen.random.nextInt(10) + 2;
            }
            if (biome.is(BiomeTags.IS_JUNGLE)) {
                rubberTrees += WorldBaseGen.random.nextInt(15) + 5;
            }
            if (!biome.is(BiomeTags.IS_FOREST)) continue;
            rubberTrees += WorldBaseGen.random.nextInt(5) + 1;
        }
        rubberTrees = Math.round((float)rubberTrees * 2.0f);
        if (WorldBaseGen.random.nextInt(100) >= (rubberTrees /= 2)) {
            return false;
        }
        int i = p_159749_.random().nextInt(5) + p_159749_.random().nextInt(4) + p_159749_.random().nextInt(2);
        WorldGenLevel worldIn = p_159749_.level();
        BlockPos position = p_159749_.origin();
        RandomSource rand = p_159749_.random();
        if (i <= 3) {
            i = 4;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockState state = worldIn.getBlockState(position.offset(x, 0, z));
                if (state.getMapColor((BlockGetter)worldIn, position.offset(x, 0, z)) != MapColor.WOOD && state.getBlock() != IUItem.rubWood.getBlock().get()) continue;
                return false;
            }
        }
        boolean flag = true;
        Block woodBlock = (Block)IUItem.rubWood.getBlock().get();
        BlockState leaves = IUItem.leaves.getDefaultState();
        if (position.getY() >= 1 && position.getY() + i + 1 <= 256) {
            boolean isSoil;
            for (int j = position.getY(); j <= position.getY() + 1 + i; ++j) {
                int k = 1;
                if (j == position.getY()) {
                    k = 0;
                }
                if (j >= position.getY() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.getX() - k; l <= position.getX() + k && flag; ++l) {
                    for (int i1 = position.getZ() - k; i1 <= position.getZ() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getHeight()) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.set(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.below();
            BlockState state = worldIn.getBlockState(down);
            boolean bl = isSoil = state.getBlock() == Blocks.GRASS_BLOCK || state.getBlock() == Blocks.DIRT;
            if (isSoil && position.getY() < worldIn.getHeight() - i - 1) {
                this.onPlantGrow(state, worldIn, down, position);
                Holder biome = worldIn.getBiome(position);
                if (!biome.is(Tags.Biomes.IS_SWAMP) && !biome.is(BiomeTags.IS_JUNGLE)) {
                    for (int i2 = position.getY() - i / 2 + i; i2 <= position.getY() + i + 1 + rand.nextInt(3); ++i2) {
                        int i3;
                        BlockPos blockpos;
                        BlockState state2;
                        int l1;
                        int k1;
                        BlockState state22;
                        BlockPos blockpos2;
                        int[][] offsets;
                        int k2 = i2 - (position.getY() + i + 1);
                        int l2 = 3;
                        if (i2 >= position.getY() + i) {
                            l2 = 1;
                        }
                        if (i2 == position.getY() + i) {
                            for (int[] offset : offsets = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}}) {
                                blockpos2 = new BlockPos(position.getX() + offset[0], i2, position.getZ() + offset[1]);
                                state22 = worldIn.getBlockState(blockpos2);
                                if (!state22.isAir()) continue;
                                worldIn.setBlock(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.getY() - i / 2 + i + 1) {
                            l2 = 3;
                            for (int[] offset : offsets = new int[][]{{-2, 0}, {0, -2}, {2, 0}, {0, 2}}) {
                                blockpos2 = new BlockPos(position.getX() + offset[0], i2, position.getZ() + offset[1]);
                                state22 = worldIn.getBlockState(blockpos2);
                                if (!state22.isAir()) continue;
                                worldIn.setBlock(blockpos2, leaves, 3);
                            }
                        }
                        if (i2 == position.getY() - i / 2 + i) {
                            l2 = 4;
                            if (i > 6) {
                                int i32;
                                for (i32 = position.getX() - l2 / 2; i32 <= position.getX() + l2 / 2; ++i32) {
                                    int j1 = i32 - position.getX();
                                    for (k1 = position.getZ() - l2 / 2; k1 <= position.getZ() + l2 / 2; ++k1) {
                                        l1 = k1 - position.getZ();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i32, i2 - 1, k1))).isAir()) continue;
                                        worldIn.setBlock(blockpos, leaves, 3);
                                    }
                                }
                                for (i32 = position.getX() - 2; i32 <= position.getX() + 2; i32 += 4) {
                                    int j1 = i32 - position.getX();
                                    for (k1 = position.getZ() - 2; k1 <= position.getZ() + 2; k1 += 4) {
                                        l1 = k1 - position.getZ();
                                        if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i32, i2 - 1, k1))).isAir()) continue;
                                        this.setBlock((LevelWriter)worldIn, blockpos, Blocks.AIR.defaultBlockState());
                                    }
                                }
                            }
                            l2 = 4;
                        }
                        for (i3 = position.getX() - l2 / 2; i3 <= position.getX() + l2 / 2; ++i3) {
                            int j1 = i3 - position.getX();
                            for (k1 = position.getZ() - l2 / 2; k1 <= position.getZ() + l2 / 2; ++k1) {
                                l1 = k1 - position.getZ();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i3, i2, k1))).isAir()) continue;
                                this.setBlock((LevelWriter)worldIn, blockpos, leaves);
                            }
                        }
                        if (i2 != position.getY() - i / 2 + i) continue;
                        for (i3 = position.getX() - 2; i3 <= position.getX() + 2; i3 += 4) {
                            int j1 = i3 - position.getX();
                            for (k1 = position.getZ() - 2; k1 <= position.getZ() + 2; k1 += 4) {
                                l1 = k1 - position.getZ();
                                if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.getBlockState(blockpos = new BlockPos(i3, i2, k1))).isAir()) continue;
                                this.setBlock((LevelWriter)worldIn, blockpos, Blocks.AIR.defaultBlockState());
                            }
                        }
                    }
                    int treeholechance = 40;
                    for (int j2 = 0; j2 < i; ++j2) {
                        BlockPos upN = position.above(j2);
                        BlockState state2 = worldIn.getBlockState(upN);
                        if (!state2.isAir() && !state2.is(BlockTags.LEAVES) && state2.getBlock() != IUItem.rubberSapling.getBlock().get()) continue;
                        if (rand.nextInt(100) <= treeholechance) {
                            treeholechance -= 10;
                            this.setBlock((LevelWriter)worldIn, position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                            continue;
                        }
                        this.setBlock((LevelWriter)worldIn, position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)));
                    }
                } else {
                    if (biome.is(Tags.Biomes.IS_SWAMP)) {
                        HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                        boolean create = this.createSwampTree(WorldBaseGen.random, position, worldIn, map);
                        if (create) {
                            for (Map.Entry entry : map.entrySet()) {
                                this.setBlock((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                            }
                        }
                        return create;
                    }
                    HashMap<BlockPos, BlockState> map = new HashMap<BlockPos, BlockState>();
                    boolean create = this.createRubTree(WorldBaseGen.random, position, worldIn, map);
                    if (create) {
                        for (Map.Entry entry : map.entrySet()) {
                            this.setBlock((LevelWriter)worldIn, (BlockPos)entry.getKey(), (BlockState)entry.getValue());
                        }
                    }
                    return create;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean createRubTree(Random rand, BlockPos position, WorldGenLevel worldIn, Map<BlockPos, BlockState> map) {
        BlockPos pos2;
        int max = 6 + WorldBaseGen.random.nextInt(3);
        int treeholechance = 90;
        BlockTropicalRubWood woodBlock = (BlockTropicalRubWood)IUItem.tropicalRubWood.getBlock().get();
        BlockState leaves = IUItem.leaves.getDefaultState();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                BlockPos upN = position.below().offset(x, 0, z);
                BlockTropicalRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                pos2 = upN;
                map.put(pos2, (BlockState)woodBlock.defaultBlockState().setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
            }
        }
        for (int j2 = 0; j2 < max; ++j2) {
            BlockPos upN = position.above(j2);
            BlockState state2 = worldIn.getBlockState(upN);
            if (j2 == max - 1) {
                BlockPos upN1;
                for (int x = -2; x < 3; ++x) {
                    for (int z = -2; z < 3; ++z) {
                        int j;
                        int yy;
                        int zz;
                        BlockPos upN2;
                        int xx;
                        if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                        upN1 = upN.offset(x, 0, z);
                        BlockTropicalRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                        BlockPos pos22 = upN1;
                        map.put(pos22, (BlockState)woodBlock.defaultBlockState().setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        upN1 = upN1.above();
                        if (x <= -1) {
                            upN1 = upN1.offset(-1, 0, 0);
                        } else if (z <= -1) {
                            upN1 = upN1.offset(0, 0, -1);
                        } else if (x >= 1) {
                            upN1 = upN1.offset(1, 0, 0);
                        } else if (z >= 1) {
                            upN1 = upN1.offset(0, 0, 1);
                        }
                        pos22 = upN1;
                        map.put(pos22, (BlockState)woodBlock.defaultBlockState().setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        for (xx = -1; xx < 2; ++xx) {
                            for (int zz2 = -1; zz2 < 2; ++zz2) {
                                if (xx == 0 && zz2 == 0 || xx == -1 && zz2 == -1 || xx == 1 && zz2 == 1 || xx == 1 && zz2 == -1 || xx == -1 && zz2 == 1) continue;
                                upN2 = upN1.offset(xx, 0, zz2);
                                map.put(upN2, leaves);
                            }
                        }
                        pos22 = upN1 = upN1.above();
                        map.put(pos22, leaves);
                        upN1 = upN1.below();
                        if (x == -2) {
                            for (zz = -1; zz < 2; ++zz) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.offset(0, yy, zz);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.offset(-1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN22;
                                pos22 = upN22 = upN1.offset(0, j, 0);
                                map.put(pos22, leaves);
                                if (j != 0) continue;
                                for (int zz3 = -1; zz3 < 2; ++zz3) {
                                    for (int yy2 = -1; yy2 < 2; ++yy2) {
                                        BlockPos upN3;
                                        if (zz3 == 0 && yy2 == 0 || zz3 == -1 && yy2 == -1 || zz3 == 1 && yy2 == 1 || zz3 == 1 && yy2 == -1 || zz3 == -1 && yy2 == 1) continue;
                                        pos22 = upN3 = upN1.offset(0, yy2, zz3);
                                        map.put(pos22, leaves);
                                    }
                                }
                            }
                            continue;
                        }
                        if (z == -2) {
                            for (xx = -1; xx < 2; ++xx) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.offset(xx, yy, 0);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.offset(0, 0, -1);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN23;
                                pos22 = upN23 = upN1.offset(0, j, 0);
                                map.put(pos22, leaves);
                            }
                            continue;
                        }
                        if (x == 2) {
                            for (zz = -1; zz < 2; ++zz) {
                                for (yy = -1; yy < 2; ++yy) {
                                    pos22 = upN2 = upN1.offset(0, yy, zz);
                                    map.put(pos22, leaves);
                                }
                            }
                            upN1 = upN1.offset(1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN24;
                                pos22 = upN24 = upN1.offset(0, j, 0);
                                map.put(pos22, leaves);
                            }
                            continue;
                        }
                        if (z != 2) continue;
                        for (xx = -1; xx < 2; ++xx) {
                            for (yy = -1; yy < 2; ++yy) {
                                pos22 = upN2 = upN1.offset(xx, yy, 0);
                                map.put(pos22, leaves);
                            }
                        }
                        upN1 = upN1.offset(0, 0, 1);
                        for (j = 1; j > -4; --j) {
                            BlockPos upN25;
                            pos22 = upN25 = upN1.offset(0, j, 0);
                            map.put(pos22, leaves);
                        }
                    }
                }
                upN1 = upN.above();
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        if (!(xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1 || xx == -1 && zz == 1)) continue;
                        BlockPos upN2 = upN1.offset(xx, 0, zz);
                        map.put(upN2, leaves);
                    }
                }
                pos2 = upN1;
                map.put(pos2, leaves);
                upN1 = upN.above().above();
                for (int xx = -1; xx < 2; ++xx) {
                    for (int zz = -1; zz < 2; ++zz) {
                        if (xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1 || xx == -1 && zz == 1) continue;
                        BlockPos upN2 = upN1.offset(xx, 0, zz);
                        map.put(upN2, leaves);
                    }
                }
            }
            if (!state2.isAir() && !state2.is(BlockTags.LEAVES) && state2.getBlock() != IUItem.rubberSapling.getBlock().get()) continue;
            if (rand.nextInt(100) <= treeholechance && j2 < max - 1) {
                treeholechance -= 10;
                map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                continue;
            }
            map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)));
        }
        return true;
    }

    private boolean createSwampTree(Random rand, BlockPos position, WorldGenLevel worldIn, Map<BlockPos, BlockState> map) {
        int treeholechance = 60;
        BlockState leaves = IUItem.leaves.getDefaultState();
        BlockSwampRubWood woodBlock = (BlockSwampRubWood)IUItem.swampRubWood.getBlock().get();
        if (rand.nextInt(2) == 0) {
            int max = 7 + rand.nextInt(4);
            Direction facing = null;
            for (int j2 = 0; j2 < max; ++j2) {
                BlockPos upN = position.above(j2);
                BlockState state2 = worldIn.getBlockState(upN);
                int type = WorldBaseGen.random.nextInt(3);
                if (WorldBaseGen.random.nextInt(100) <= 50 && j2 > 1 && j2 != max - 1) {
                    if (type == 0) {
                        prevFacing = facing;
                        facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        while (facing == prevFacing) {
                            facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        }
                        BlockPos pos1 = upN.offset(facing.getNormal());
                        BlockState state1 = worldIn.getBlockState(pos1);
                        if (!state1.isAir() && !state1.is(BlockTags.LEAVES) && state1.getBlock() != IUItem.rubberSapling.getBlock().get()) {
                            return false;
                        }
                        BlockSwampRubWood.RubberWoodState rubberWoodState = facing.getAxis() == Direction.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                        map.put(pos1, (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        for (int x = -1; x < 2; ++x) {
                            for (int z = -1; z < 2; ++z) {
                                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                BlockPos pos2 = pos1.offset(x, 0, z);
                                BlockState state3 = worldIn.getBlockState(pos2);
                                if (state3.isAir()) {
                                    map.put(pos2, leaves);
                                    continue;
                                }
                                return false;
                            }
                        }
                    } else if (type == 1) {
                        int ii;
                        prevFacing = facing;
                        facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        while (facing == prevFacing) {
                            facing = Direction.values()[2 + WorldBaseGen.random.nextInt(4)];
                        }
                        BlockPos pos1 = upN;
                        int max1 = 2;
                        for (ii = 0; ii < max1; ++ii) {
                            BlockState state1 = worldIn.getBlockState(pos1 = pos1.offset(facing.getNormal()));
                            if (!state1.isAir() && !state1.is(BlockTags.LEAVES) && state1.getBlock() != IUItem.rubberSapling.getBlock().get()) {
                                return false;
                            }
                            BlockSwampRubWood.RubberWoodState rubberWoodState = facing.getAxis() == Direction.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                            map.put(pos1, (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                            for (int x = -1; x < 2; ++x) {
                                for (int z = -1; z < 2; ++z) {
                                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                    BlockPos pos2 = pos1.offset(x, 0, z);
                                    BlockState state3 = worldIn.getBlockState(pos2);
                                    if (state3.isAir()) {
                                        map.put(pos2, leaves);
                                        continue;
                                    }
                                    return false;
                                }
                            }
                        }
                        max1 = 1;
                        for (ii = 0; ii < max1; ++ii) {
                            pos1 = pos1.above();
                            if (rand.nextInt(100) <= treeholechance) {
                                treeholechance -= 10;
                                this.setBlock((LevelWriter)worldIn, pos1, (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                            } else {
                                this.setBlock((LevelWriter)worldIn, pos1, (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                            }
                            for (int x = -1; x < 2; ++x) {
                                for (int z = -1; z < 2; ++z) {
                                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                    BlockPos pos2 = pos1.offset(x, 0, z);
                                    BlockState state3 = worldIn.getBlockState(pos2);
                                    if (state3.isAir()) {
                                        map.put(pos2, leaves);
                                        continue;
                                    }
                                    return false;
                                }
                            }
                            BlockPos pos2 = pos1.above();
                            BlockState state3 = worldIn.getBlockState(pos2);
                            if (!state3.isAir()) {
                                return false;
                            }
                            map.put(pos2, leaves);
                        }
                    }
                }
                if (!state2.isAir() && !state2.is(BlockTags.LEAVES) && state2.getBlock() != IUItem.rubberSapling.getBlock().get()) continue;
                if (rand.nextInt(100) <= treeholechance) {
                    treeholechance -= 10;
                    map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                } else {
                    map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                }
                BlockPos pos = position.above(j2);
                if (j2 >= 3) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0 || j2 >= max - 3 && (x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1)) continue;
                            BlockPos pos1 = pos.offset(x, 0, z);
                            BlockState state1 = worldIn.getBlockState(pos1);
                            if (state1.isAir()) {
                                map.put(pos1, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                if (j2 != max - 1) continue;
                BlockPos pos2 = pos.above();
                BlockState state3 = worldIn.getBlockState(pos2);
                if (state3.isAir()) {
                    map.put(pos2, leaves);
                    continue;
                }
                return false;
            }
        } else {
            treeholechance = 60;
            woodBlock = (BlockSwampRubWood)IUItem.swampRubWood.getBlock().get();
            int max = 5 + rand.nextInt(4);
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                    BlockPos upN = position.below().offset(x, 0, z);
                    BlockSwampRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                    BlockPos pos2 = upN;
                    BlockState state3 = worldIn.getBlockState(pos2);
                    if (state3.isAir()) {
                        return false;
                    }
                    map.put(pos2, (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                }
            }
            for (int j2 = 0; j2 < max; ++j2) {
                BlockState state3;
                int y;
                BlockPos upN = position.above(j2);
                BlockState state2 = worldIn.getBlockState(upN);
                if (j2 < max - 1) {
                    if (!state2.isAir() && !state2.is(BlockTags.LEAVES) && state2.getBlock() != IUItem.rubberSapling.getBlock().get()) continue;
                    if (rand.nextInt(100) <= treeholechance) {
                        treeholechance -= 10;
                        map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                        continue;
                    }
                    map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                    continue;
                }
                if (j2 != max - 1) continue;
                if (state2.isAir() || state2.is(BlockTags.LEAVES) || state2.getBlock() == IUItem.rubberSapling.getBlock().get()) {
                    if (rand.nextInt(100) <= treeholechance) {
                        treeholechance -= 10;
                        map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(ModUtils.HORIZONTALS[rand.nextInt(4)]))));
                    } else {
                        map.put(position.above(j2), (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                    }
                }
                BlockPos upN1 = position.above(j2);
                for (y = 0; y < 5; ++y) {
                    int radius = 0;
                    if (y < 3) {
                        radius = 3;
                    }
                    if (y == 3) {
                        radius = 1;
                    }
                    if (y == 4) {
                        radius = 0;
                    }
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            if (x * x + z * z > radius * radius || Math.abs(x) == Math.abs(z) && Math.abs(x) == 2 || y == 2 && (Math.abs(z) == 0 && Math.abs(x) == 3 || Math.abs(z) == 3 && Math.abs(x) == 0)) continue;
                            BlockPos pos = upN1.offset(x, y, z);
                            state2 = worldIn.getBlockState(pos);
                            if (state2.isAir()) {
                                map.put(pos, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                upN1 = position.above(j2).below().below();
                for (y = 0; y < 2; ++y) {
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0 || (y != 0 ? Math.abs(x) != Math.abs(z) : Math.abs(x) == Math.abs(z))) continue;
                            BlockPos upN2 = upN1.offset(x, y, z);
                            state3 = worldIn.getBlockState(upN2);
                            if (state3.isAir()) {
                                map.put(upN2, leaves);
                                continue;
                            }
                            return false;
                        }
                    }
                }
                for (int x = -2; x < 3; ++x) {
                    for (int z = -2; z < 3; ++z) {
                        if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                        upN1 = upN.offset(x, 0, z);
                        BlockSwampRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                        BlockPos pos2 = upN1;
                        state3 = worldIn.getBlockState(pos2);
                        if (state3.isAir()) {
                            return false;
                        }
                        map.put(pos2, (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        upN1 = upN1.below();
                        state3 = worldIn.getBlockState(upN1);
                        if (!state3.isAir()) {
                            return false;
                        }
                        map.put(upN1, leaves);
                        upN1 = upN1.above().above();
                        if (x == -1) {
                            upN1 = upN1.offset(-1, 0, 0);
                        } else if (z == -1) {
                            upN1 = upN1.offset(0, 0, -1);
                        } else if (x == 1) {
                            upN1 = upN1.offset(1, 0, 0);
                        } else {
                            if (z != 1) continue;
                            upN1 = upN1.offset(0, 0, 1);
                        }
                        rubberWoodState = BlockSwampRubWood.RubberWoodState.plain_y;
                        pos2 = upN1;
                        state3 = worldIn.getBlockState(pos2);
                        if (!state3.isAir()) {
                            return false;
                        }
                        map.put(pos2, (BlockState)woodBlock.defaultBlockState().setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    }
                }
            }
        }
        return true;
    }

    public void onPlantGrow(BlockState state, WorldGenLevel world, BlockPos pos, BlockPos source) {
        if (state.getBlock() == Blocks.GRASS_BLOCK || state.getBlock() == Blocks.FARMLAND) {
            world.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        }
    }

    public boolean isReplaceable(WorldGenLevel world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.isAir() || state.is(BlockTags.LEAVES) || state.is(BlockTags.LOGS) || this.canGrowInto(state.getBlock());
    }
}

