/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein.noise;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;

class Center {
    double x;
    double y;

    public Center(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static ArrayList<Center> generateCenters(int maxCenters, double minDist, int width, int height) {
        Random rnd = new Random();
        LinkedList<Center> centers = new LinkedList<Center>();
        for (int attempts = 0; centers.size() < maxCenters && attempts < maxCenters * 10; ++attempts) {
            double cx = rnd.nextDouble() * (double)width;
            double cy = rnd.nextDouble() * (double)height;
            boolean tooClose = false;
            for (Center c : centers) {
                double dist = Math.hypot(cx - c.x, cy - c.y);
                if (!(dist < minDist)) continue;
                tooClose = true;
                break;
            }
            if (tooClose) continue;
            centers.add(new Center(cx, cy));
        }
        return new ArrayList<Center>(centers);
    }
}

