/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crafting;

import com.denfop.api.Recipes;
import com.denfop.items.ItemToolCrafting;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class BaseShapelessRecipe
implements CraftingRecipe {
    final NonNullList<Ingredient> listIngridient;
    private final ItemStack output;
    private final List<IInputItemStack> recipeInputList;
    private final String id;
    private ResourceLocation name;

    public BaseShapelessRecipe(ItemStack output, List<IInputItemStack> recipeInputList) {
        this.output = output;
        this.recipeInputList = recipeInputList;
        this.listIngridient = NonNullList.create();
        for (IInputItemStack recipeInput : this.recipeInputList) {
            if (recipeInput.getInputs().size() == 1 && !recipeInput.getInputs().get(0).getComponents().isEmpty()) {
                List list = recipeInput.getInputs().get(0).getComponents().stream().collect(Collectors.toList());
                list.removeIf(typedDataComponent -> ModUtils.ignoredNbtKeys.contains(typedDataComponent.type()));
                if (!list.isEmpty()) {
                    HolderSet.Direct holders = HolderSet.direct((Holder[])new Holder[]{recipeInput.getInputs().get(0).getItemHolder()});
                    this.listIngridient.add((Object)new Ingredient((ICustomIngredient)new DataComponentIngredient((HolderSet)holders, DataComponentPredicate.allOf((DataComponentMap)recipeInput.getInputs().get(0).getComponents()), false)));
                    continue;
                }
                if (recipeInput instanceof InputOreDict) {
                    this.listIngridient.add((Object)Ingredient.of(recipeInput.getTag()));
                    continue;
                }
                this.listIngridient.add((Object)Ingredient.of((ItemStack[])recipeInput.getInputs().toArray(new ItemStack[0])));
                continue;
            }
            if (recipeInput instanceof InputOreDict) {
                this.listIngridient.add((Object)Ingredient.of(recipeInput.getTag()));
                continue;
            }
            this.listIngridient.add((Object)Ingredient.of((ItemStack[])recipeInput.getInputs().toArray(new ItemStack[0])));
        }
        this.id = Recipes.registerRecipe((Recipe)this);
    }

    public static BaseShapelessRecipe create(CustomPacketBuffer customPacketBuffer) {
        try {
            ItemStack output = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            ArrayList<IInputItemStack> partRecipes = new ArrayList<IInputItemStack>();
            int size = customPacketBuffer.readInt();
            for (int i = 0; i < size; ++i) {
                partRecipes.add(InputItemStack.create((CompoundTag)DecoderHandler.decode(customPacketBuffer), (HolderLookup.Provider)customPacketBuffer.registryAccess()));
            }
            return new BaseShapelessRecipe(output, partRecipes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<IInputItemStack> getRecipeInputList() {
        return this.recipeInputList;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack matches(CraftingInput inv) {
        ArrayList<IInputItemStack> recipeInputList1 = new ArrayList<IInputItemStack>(this.recipeInputList);
        block0: for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Iterator iter = recipeInputList1.iterator();
            while (iter.hasNext()) {
                IInputItemStack recipeInput = (IInputItemStack)iter.next();
                if (!recipeInput.matches(stack)) continue;
                iter.remove();
                continue block0;
            }
        }
        if (!recipeInputList1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int col = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            ++col;
        }
        if (col == this.recipeInputList.size()) {
            return this.output.copy();
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(CraftingInput p_346065_, Level p_345375_) {
        return this.matches(p_346065_) != ItemStack.EMPTY;
    }

    public ItemStack assemble(CraftingInput p_345149_, HolderLookup.Provider p_346030_) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= this.recipeInputList.size();
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return this.output.copy();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput p_345383_) {
        NonNullList list = NonNullList.withSize((int)p_345383_.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < p_345383_.size(); ++i) {
            ItemStack stack = p_345383_.getItem(i);
            if (!(stack.getItem() instanceof ItemToolCrafting)) continue;
            stack = stack.getItem().getCraftingRemainingItem(stack);
            list.set(i, (Object)stack);
        }
        return list;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.listIngridient;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Register.RECIPE_SERIALIZER_SHAPELESS.get();
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer(buf);
        try {
            EncoderHandler.encode(packetBuffer, this.output);
            packetBuffer.writeInt(this.recipeInputList.size());
            for (IInputItemStack part : this.recipeInputList) {
                EncoderHandler.encode(packetBuffer, part.writeNBT((HolderLookup.Provider)buf.registryAccess()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

