/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.api.gui.GuiElement;
import com.denfop.gui.GuiCore;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class ItemStackImageText
extends GuiElement<ItemStackImageText> {
    private final Supplier<ItemStack> itemSupplier;
    private final String text;

    public ItemStackImageText(GuiCore<?> gui, int x, int y, Supplier<ItemStack> itemSupplier, String text) {
        super(gui, x, y, 16, 16);
        this.itemSupplier = itemSupplier;
        this.text = text;
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        super.drawBackground(poseStack, mouseX, mouseY);
        ItemStack stack = this.itemSupplier.get();
        if (!ModUtils.isEmpty(stack)) {
            this.gui.drawItemStack(poseStack, this.x, this.y, stack);
        }
    }

    @Override
    public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
        ItemStack stack;
        if (this.contains(mouseX, mouseY) && !ModUtils.isEmpty(stack = this.itemSupplier.get())) {
            String[] lines = this.text.split("\n");
            ArrayList<String> stringList = new ArrayList<String>(Arrays.asList(lines));
            this.gui.drawTooltipOnlyName(poseStack, mouseX, mouseY, stack, stringList);
        }
    }
}

