/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space;

import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class BaseResource
implements IBaseResource {
    private final FluidStack fluidStack;
    private final EnumTypeRovers typeRovers;
    private ItemStack stack;
    private int max;
    private int min;
    private IBody body;
    private int percentplanet;

    public BaseResource(ItemStack stack, int minchance, int maxchance, int percentplanet, IBody body, EnumTypeRovers typeRovers) {
        this.stack = stack;
        this.fluidStack = null;
        this.max = maxchance;
        this.typeRovers = typeRovers;
        this.min = minchance;
        this.body = body;
        this.percentplanet = percentplanet;
        SpaceNet.instance.addResource(this);
    }

    public BaseResource(FluidStack fluidStack, int minchance, int maxchance, int percentplanet, IBody body, EnumTypeRovers typeRovers) {
        this.stack = null;
        this.fluidStack = fluidStack;
        this.max = maxchance;
        this.min = minchance;
        this.body = body;
        this.typeRovers = typeRovers;
        this.percentplanet = percentplanet;
        SpaceNet.instance.addResource(this);
    }

    public BaseResource(CompoundTag tagCompound, HolderLookup.Provider p_323640_) {
        this.percentplanet = tagCompound.getByte("percentplanet");
        this.min = tagCompound.getByte("min");
        this.max = tagCompound.getByte("max");
        this.stack = tagCompound.getBoolean("hasItem") ? ItemStack.parseOptional((HolderLookup.Provider)p_323640_, (CompoundTag)tagCompound.getCompound("stack")) : null;
        this.fluidStack = tagCompound.getBoolean("hasFluid") ? FluidStack.parseOptional((HolderLookup.Provider)p_323640_, (CompoundTag)tagCompound.getCompound("fluidStack")) : null;
        this.typeRovers = EnumTypeRovers.values()[tagCompound.getByte("rovers")];
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    @Override
    public int getPercentResearchBody() {
        return this.percentplanet;
    }

    @Override
    public int getChance() {
        return this.min;
    }

    @Override
    public int getMaxChance() {
        return this.max;
    }

    @Override
    public IBody getBody() {
        return this.body;
    }

    @Override
    public int getPercentPanel() {
        return this.percentplanet;
    }

    @Override
    public CompoundTag writeNBTTag(CompoundTag tagCompound, HolderLookup.Provider p_323640_) {
        tagCompound.putByte("percentplanet", (byte)this.percentplanet);
        tagCompound.putByte("min", (byte)this.min);
        tagCompound.putByte("max", (byte)this.max);
        tagCompound.putByte("rovers", (byte)this.typeRovers.ordinal());
        tagCompound.putBoolean("hasItem", this.stack != null);
        if (this.stack != null) {
            tagCompound.put("stack", this.stack.save(p_323640_));
        }
        tagCompound.putBoolean("hasFluid", this.fluidStack != null);
        if (this.fluidStack != null) {
            tagCompound.put("fluidStack", this.fluidStack.save(p_323640_));
        }
        return tagCompound;
    }

    @Override
    public EnumTypeRovers getTypeRovers() {
        return this.typeRovers;
    }
}

