/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.audio;

import com.denfop.mixin.access.SoundEngineAccessor;
import com.denfop.mixin.access.SoundManagerAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSound
extends AbstractTickableSoundInstance {
    private final int subtitleFrequency;
    private Player player;
    private int consecutiveTicks;

    public PlayerSound(@NotNull Player player, @NotNull SoundEvent sound) {
        super(sound, SoundSource.PLAYERS, player.level().getRandom());
        this.player = player;
        this.subtitleFrequency = 60;
        this.delay = 0;
        this.looping = true;
        this.delay = 0;
        this.volume = 1.0f;
        this.pitch = 1.0f;
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
    }

    @Nullable
    private Player getPlayer() {
        return this.player;
    }

    public void tick() {
        Player player = this.getPlayer();
        if (player == null || !player.isAlive() || player.isRemoved()) {
            this.stop();
            this.volume = 0.0f;
            this.consecutiveTicks = 0;
            return;
        }
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
        if (this.consecutiveTicks % this.subtitleFrequency == 0) {
            SoundManager soundHandler = Minecraft.getInstance().getSoundManager();
            for (SoundEventListener soundEventListener : ((SoundEngineAccessor)((SoundManagerAccess)Minecraft.getInstance().getSoundManager()).getSoundEngine()).getListeners()) {
                WeighedSoundEvents soundEventAccessor = this.resolve(soundHandler);
                if (soundEventAccessor == null) continue;
                soundEventListener.onPlaySound((SoundInstance)this, soundEventAccessor, this.volume);
            }
            this.consecutiveTicks = 1;
        } else {
            ++this.consecutiveTicks;
        }
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        Player player = this.getPlayer();
        if (player == null) {
            return super.canPlaySound();
        }
        return !player.isSilent();
    }
}

