/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.audio;

import com.denfop.audio.EnumSound;
import com.denfop.audio.PlayerSound;
import com.denfop.mixin.access.SoundEngineAccess;
import com.denfop.mixin.access.SoundManagerAccess;
import com.mojang.blaze3d.audio.Channel;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SoundHandler {
    @OnlyIn(value=Dist.CLIENT)
    public static void stopSound(BlockPos pos) {
        SoundEngine soundEngine = ((SoundManagerAccess)Minecraft.getInstance().getSoundManager()).getSoundEngine();
        if (((SoundEngineAccess)soundEngine).getLoaded()) {
            for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> map : ((SoundEngineAccess)soundEngine).getInstanceToChannel().entrySet()) {
                BlockPos pos1 = new BlockPos((int)map.getKey().getX(), (int)map.getKey().getY(), (int)map.getKey().getZ());
                if (pos1.getX() < 0) {
                    pos1 = pos1.offset(-1, 0, 0);
                }
                if (pos1.getZ() < 0) {
                    pos1 = pos1.offset(0, 0, -1);
                }
                if (!pos1.equals((Object)pos)) continue;
                map.getValue().execute(Channel::stop);
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stopSound() {
        SoundEngine soundEngine = ((SoundManagerAccess)Minecraft.getInstance().getSoundManager()).getSoundEngine();
        if (((SoundEngineAccess)soundEngine).getLoaded()) {
            for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> map : ((SoundEngineAccess)soundEngine).getInstanceToChannel().entrySet()) {
                if (map.getKey().getSource() != SoundSource.PLAYERS || !map.getKey().getLocation().getNamespace().equals("industrialupgrade")) continue;
                map.getValue().execute(Channel::stop);
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stopSound(EnumSound sound1) {
        SoundEngine soundEngine = ((SoundManagerAccess)Minecraft.getInstance().getSoundManager()).getSoundEngine();
        ArrayList<SoundInstance> sounds = new ArrayList<SoundInstance>();
        if (((SoundEngineAccess)soundEngine).getLoaded()) {
            for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> map : ((SoundEngineAccess)soundEngine).getInstanceToChannel().entrySet()) {
                if (map.getKey().getSource() != SoundSource.PLAYERS || !map.getKey().getLocation().getNamespace().equals("industrialupgrade") || !map.getKey().getLocation().getPath().contains(sound1.getNameSounds().toLowerCase())) continue;
                sounds.add(map.getKey());
                break;
            }
        }
        sounds.forEach(arg_0 -> ((SoundEngine)soundEngine).stop(arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(Player player, EnumSound sound1) {
        SoundEngine soundEngine = ((SoundManagerAccess)Minecraft.getInstance().getSoundManager()).getSoundEngine();
        boolean can = true;
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> map : ((SoundEngineAccess)soundEngine).getInstanceToChannel().entrySet()) {
            if (map.getKey().getSource() != SoundSource.PLAYERS || !map.getKey().getLocation().getNamespace().equals("industrialupgrade") || !map.getKey().getLocation().getPath().contains(sound1.getNameSounds().toLowerCase())) continue;
            can = false;
            break;
        }
        if (can) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new PlayerSound(player, sound1.getSoundEvent()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSound(Player player, String sound1) {
        SoundEngine soundEngine = ((SoundManagerAccess)Minecraft.getInstance().getSoundManager()).getSoundEngine();
        boolean can = true;
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> map : ((SoundEngineAccess)soundEngine).getInstanceToChannel().entrySet()) {
            if (map.getKey().getSource() != SoundSource.PLAYERS || !map.getKey().getLocation().getNamespace().equals("industrialupgrade") || !map.getKey().getLocation().getPath().contains(sound1.toLowerCase())) continue;
            can = false;
            break;
        }
        if (can) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new PlayerSound(player, EnumSound.getSondFromString(sound1)));
        }
    }
}

