/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUItem;
import com.denfop.datagen.ConfiguredFeaturesGen;
import com.denfop.world.RubTreeFeature;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;

public class RubberSapling
extends SaplingBlock {
    public RubberSapling() {
        super(new TreeGrower("rubber", Optional.of(ConfiguredFeaturesGen.RUB_TREE), Optional.empty(), Optional.empty()), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().randomTicks().strength(0.0f).instabreak().sound(SoundType.GRASS));
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder p_60538_) {
        if (!p_60538_.getLevel().isClientSide) {
            return List.of(new ItemStack((ItemLike)IUItem.rubberSapling.getItem()));
        }
        return super.getDrops(p_60537_, p_60538_);
    }

    public void advanceTree(ServerLevel pLevel, BlockPos pPos, BlockState pState, RandomSource pRandom) {
        if ((Integer)pState.getValue((Property)STAGE) == 0) {
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)STAGE), 4);
        } else {
            ((RubTreeFeature)((Object)WorldBaseGen.RUB_TREE_GENERATOR.get())).placeInstantly(pLevel, pLevel.getChunkSource().getGenerator(), pState, pRandom, pPos);
        }
    }
}

