/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.sytem.IDual;
import com.denfop.api.sytem.ISource;
import com.denfop.blocks.FluidName;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Action;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.TypeLoad;
import com.denfop.componets.TypeUpgrade;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Timer;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ComponentProcess
extends AbstractComponent {
    protected final double defaultEnergyConsume;
    protected final int defaultOperationLength;
    protected double energyConsume;
    protected int operationLength;
    protected ComponentProgress componentProgress;
    protected InvSlotRecipes invSlotRecipes;
    protected int operationsPerTick;
    protected int tick;
    protected InvSlotOutput outputSlot;
    protected IUpdateTick updateTick;
    protected boolean hasTank = false;
    protected boolean hasAudio = false;
    protected HeatComponent heatComponent;
    protected CoolComponent coldComponent;
    protected ComponentBaseEnergy componentSE;
    Energy energy;
    private boolean audoFix;
    private Action action;
    private ComponentUpgrade componentUpgrade;
    private boolean instant;
    private boolean stack;
    private ComponentBaseEnergy componentRad;
    private boolean exp;
    private ComponentBaseEnergy componentExp;
    private Timer timer1 = new Timer(0, 0, 0);
    private Timer timer = null;

    public ComponentProcess(TileEntityInventory parent, int operationLength, double energyConsume) {
        super(parent);
        this.defaultEnergyConsume = this.energyConsume = energyConsume;
        this.defaultOperationLength = this.operationLength = operationLength;
        this.operationsPerTick = 1;
    }

    public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
        this.operationsPerTick = invSlotUpgrade.getOperationsPerTick1(this.defaultOperationLength);
        this.operationLength = invSlotUpgrade.getOperationLength1(this.defaultOperationLength);
        this.energyConsume = invSlotUpgrade.getEnergyDemand1(this.defaultEnergyConsume);
        this.getOperationLength();
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.componentProgress = (ComponentProgress)this.getParent().getComp("com.denfop.componets.ComponentProgress");
        this.energy = this.getParent().getComp(Energy.class);
        this.heatComponent = this.getParent().getComp(HeatComponent.class);
        this.coldComponent = this.getParent().getComp(CoolComponent.class);
        this.componentSE = (ComponentBaseEnergy)this.getParent().getComp("com.denfop.componets.ComponentBaseEnergysolarium");
        this.componentRad = (ComponentBaseEnergy)this.getParent().getComp("com.denfop.componets.ComponentBaseEnergyradiation");
        if (this.exp) {
            this.componentExp = (ComponentBaseEnergy)this.getParent().getComp("com.denfop.componets.ComponentBaseEnergyexperience");
        }
        this.audoFix = this.getParent() instanceof IAudioFixer;
        this.componentUpgrade = this.getParent().getComp(ComponentUpgrade.class);
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        IFluidHandlerItem handler;
        FluidStack fluid;
        ItemStack stack = player.getItemInHand(hand);
        if (!(!stack.getItem().equals(IUItem.canister.getItem()) || (fluid = (handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM, null)).getFluidInTank(0)).isEmpty() || fluid.getFluid() != FluidName.fluidmotoroil.getInstance().get() || fluid.getAmount() < 125 || this.timer1.canWork() && this.timer1.getBar() != 0 || this.timer != null && this.timer.canWork())) {
            this.timer = new Timer(0, 0, 35);
            handler.drain(125, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return super.onBlockActivated(player, hand);
    }

    public void setSlotOutput(InvSlotOutput slotOutput) {
        this.outputSlot = slotOutput;
    }

    public double getDefaultEnergyConsume() {
        return this.defaultEnergyConsume;
    }

    public double getEnergyConsume() {
        return this.energyConsume;
    }

    public int getOperationsPerTick() {
        return this.operationsPerTick;
    }

    public int getDefaultOperationLength() {
        return this.defaultOperationLength;
    }

    public void setHasTank(boolean hasTank) {
        this.hasTank = hasTank;
    }

    public void setHasAudio(boolean hasAudio) {
        this.hasAudio = hasAudio;
    }

    public void setInvSlotRecipes(InvSlotRecipes invSlotRecipes) {
        this.invSlotRecipes = invSlotRecipes;
        this.updateTick = invSlotRecipes.getTile();
    }

    public MachineRecipe getOutput() {
        this.updateTick.setRecipeOutput(this.invSlotRecipes.process());
        return this.updateTick.getRecipeOutput();
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public boolean checkSE() {
        int energy = 5;
        if (this.instant) {
            energy *= this.operationLength;
        }
        return this.componentSE == null || this.componentSE.getEnergy() > (double)energy;
    }

    public boolean checkFluidRecipe() {
        return !this.hasTank || this.updateTick.getRecipeOutput().getRecipe().input.getFluid() == null || !this.invSlotRecipes.getTank().getFluid().isEmpty() && this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null && this.invSlotRecipes.getTank().getFluid().getFluid().equals(this.updateTick.getRecipeOutput().getRecipe().input.getFluid().getFluid()) && this.invSlotRecipes.getTank().getFluidAmount() >= this.updateTick.getRecipeOutput().getRecipe().input.getFluid().getAmount();
    }

    public boolean checkRadiation(boolean consume) {
        if (this.componentRad == null) {
            return true;
        }
        if (this.componentRad.getDelegate() instanceof ISource && !(this.componentRad.getDelegate() instanceof IDual)) {
            return this.componentRad.getCapacity() - this.componentRad.getEnergy() >= 150.0;
        }
        if (this.updateTick.getRecipeOutput() == null) {
            return false;
        }
        int amount = this.updateTick.getRecipeOutput().getRecipe().output.metadata.getInt("rad_amount");
        if (consume) {
            this.componentRad.useEnergy(amount);
        }
        return this.componentRad.getEnergy() >= (double)amount;
    }

    public boolean checkExp(boolean consume) {
        if (this.componentExp == null) {
            return true;
        }
        if (this.updateTick.getRecipeOutput() == null) {
            return false;
        }
        int amount = this.updateTick.getRecipeOutput().getRecipe().output.metadata.getInt("exp");
        if (consume) {
            this.componentExp.useEnergy(amount);
        }
        return this.componentExp.getEnergy() >= (double)amount;
    }

    public boolean checkHeatRecipe() {
        if (this.heatComponent == null) {
            return true;
        }
        if ((double)this.updateTick.getRecipeOutput().getRecipe().output.metadata.getShort("temperature") <= this.heatComponent.getEnergy()) {
            return true;
        }
        if (!this.heatComponent.need) {
            this.heatComponent.need = true;
        }
        return false;
    }

    public void updateRecipe() {
    }

    public boolean checkRecipe() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        double energyConsume = this.energyConsume;
        int size = 64;
        if (this.componentUpgrade != null && this.componentUpgrade.isChange()) {
            this.instant = this.componentUpgrade.hasUpgrade(TypeUpgrade.INSTANT);
            this.stack = this.componentUpgrade.hasUpgrade(TypeUpgrade.STACK);
            this.componentUpgrade.setChange(false);
        }
        if (this.instant) {
            energyConsume *= (double)this.operationLength;
        }
        if (this.stack) {
            if (this.updateTick.getRecipeOutput() != null) {
                List<Integer> list = this.updateTick.getRecipeOutput().getList();
                for (int i = 0; i < list.size(); ++i) {
                    size = Math.min(size, this.invSlotRecipes.get(i).getCount() / list.get(i));
                }
                int count = this.outputSlot.get(0).isEmpty() ? this.updateTick.getRecipeOutput().getRecipe().output.items.get(0).getMaxStackSize() : this.outputSlot.get(0).getMaxStackSize() - this.outputSlot.get(0).getCount();
                ItemStack outputStack = this.updateTick.getRecipeOutput().getRecipe().output.items.get(0);
                size = Math.min(size, count /= Math.max(outputStack.getCount(), 1));
                size = Math.min(size, this.updateTick.getRecipeOutput().getRecipe().output.items.get(0).getMaxStackSize());
                if (this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null) {
                    int size1 = this.invSlotRecipes.getTank().getFluidAmount() / this.updateTick.getRecipeOutput().getRecipe().input.getFluid().getAmount();
                    size = Math.min(size, size1);
                }
            }
        } else {
            size = 1;
        }
        this.updateRecipe();
        if (this.updateTick.getRecipeOutput() != null && this.energy.canUseEnergy(energyConsume *= (double)size) && !this.invSlotRecipes.isEmpty() && this.canAddItemStack() && this.checkRecipe() && this.checkExp(false) && this.checkFluidRecipe() && this.checkHeatRecipe() && this.checkSE() && this.checkRadiation(false) && this.invSlotRecipes.continue_process(this.updateTick.getRecipeOutput())) {
            if (this.heatComponent != null) {
                this.heatComponent.need = true;
            }
            if (!this.parent.getActive()) {
                this.parent.setActive(true);
            }
            if (this.componentProgress.getProgress() == 0 && this.hasAudio && (double)this.operationLength > (double)this.defaultOperationLength * 0.1 && this.audoFix) {
                ((IAudioFixer)((Object)this.getParent())).initiate(0);
            }
            this.componentProgress.addProgress();
            if (this.timer != null && this.timer.canWork()) {
                this.componentProgress.addProgress();
            }
            if (this.action != null && this.action.needAction(TypeLoad.PROGRESS)) {
                this.action.doAction();
            }
            if (this.componentProgress.getMaxValue() != this.operationLength) {
                this.componentProgress.setMaxValue((short)this.operationLength);
            }
            if (this.componentSE != null) {
                int energy = 5;
                if (this.instant) {
                    energy *= this.operationLength;
                }
                this.componentSE.useEnergy(energy);
            }
            this.consumeEnergy();
            this.energy.useEnergy(energyConsume);
            if (this.instant) {
                this.componentProgress.setProgress((short)this.operationLength);
            }
            if (this.componentProgress.getProgress() >= this.operationLength) {
                this.componentProgress.cancellationProgress();
                this.consumeEnergy1();
                if (size > 1) {
                    this.operateWithMax(this.updateTick.getRecipeOutput(), size);
                } else {
                    this.operateWithMax(this.updateTick.getRecipeOutput());
                }
                if (this.action != null && this.action.needAction(TypeLoad.AFTER_PROGRESS)) {
                    this.action.doAction();
                }
                if (this.hasAudio && this.audoFix) {
                    ((IAudioFixer)((Object)this.getParent())).initiate(2);
                }
            }
        } else {
            if (this.heatComponent != null && this.updateTick.getRecipeOutput() == null) {
                this.heatComponent.need = false;
            }
            this.onFailedProcess();
            if (this.componentProgress == null) {
                this.componentProgress = (ComponentProgress)this.getParent().getComp("com.denfop.componets.ComponentProgress");
                this.energy = this.getParent().getComp(Energy.class);
                this.heatComponent = this.getParent().getComp(HeatComponent.class);
                this.coldComponent = this.getParent().getComp(CoolComponent.class);
                this.componentSE = (ComponentBaseEnergy)this.getParent().getComp("com.denfop.componets.ComponentBaseEnergysolarium");
                this.audoFix = this.getParent() instanceof IAudioFixer;
                this.componentUpgrade = this.getParent().getComp(ComponentUpgrade.class);
            }
            if (this.componentProgress.getProgress() != 0 && this.getParent().getActive() && this.hasAudio && this.audoFix) {
                ((IAudioFixer)((Object)this.getParent())).initiate(1);
            }
            if (this.updateTick.getRecipeOutput() == null) {
                this.componentProgress.cancellationProgress();
            }
            if (this.getParent().getActive()) {
                this.getParent().setActive(false);
            }
        }
        if (this.action != null && this.action.needAction(TypeLoad.ALWAYS)) {
            this.action.doAction();
        }
        if (this.heatComponent != null) {
            this.heatComponent.useEnergy(1.0);
        }
        if (this.coldComponent != null) {
            ++this.tick;
            if (!this.getParent().getActive()) {
                if (this.tick - 120 >= 0) {
                    this.coldComponent.useEnergy(0.35);
                    this.tick = 0;
                }
            } else if (this.tick - 240 >= 0) {
                this.coldComponent.useEnergy(0.35);
                this.tick = 0;
            }
            this.getOperationDefaultLength();
        }
        if (this.parent.getActive() && this.parent.getWorld().getGameTime() % 20L == 0L) {
            if (this.timer != null && this.timer.canWork()) {
                this.timer.work();
                if (!this.timer.canWork()) {
                    this.timer1 = new Timer(0, 0, 10);
                }
            }
            if (this.timer1.canWork()) {
                this.timer1.work();
            }
        }
    }

    public void onFailedProcess() {
    }

    public void consumeEnergy1() {
    }

    public boolean canAddItemStack() {
        return this.updateTick.getRecipeOutput().getRecipe().output.items.size() < 2 ? this.outputSlot.canAdd(this.updateTick.getRecipeOutput().getRecipe().getOutput().items) : this.outputSlot.addWithoutIgnoring(this.updateTick.getRecipeOutput().getRecipe().output.items, true);
    }

    public void consumeEnergy() {
    }

    public void getOperationDefaultLength() {
        if (this.coldComponent == null) {
            return;
        }
        double fillratio = this.coldComponent.getFillRatio();
        if (fillratio >= 0.75 && fillratio < 1.0) {
            this.operationLength = this.defaultOperationLength * 2;
        }
        if (fillratio >= 1.0) {
            this.operationLength = Integer.MAX_VALUE;
        }
        if (fillratio >= 0.5 && fillratio < 0.75) {
            this.operationLength = (int)((double)this.defaultOperationLength * 1.5);
        }
    }

    public void getOperationLength() {
        if (this.coldComponent == null) {
            return;
        }
        double fillratio = this.coldComponent.getFillRatio();
        if (fillratio >= 0.75 && fillratio < 1.0) {
            this.operationLength *= 2;
        }
        if (fillratio >= 1.0) {
            this.operationLength = Integer.MAX_VALUE;
        }
        if (fillratio >= 0.5 && fillratio < 0.75) {
            this.operationLength = (int)((double)this.operationLength * 1.5);
        }
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.invSlotRecipes.consume();
        this.outputSlot.add(processResult);
        this.checkRadiation(true);
        this.checkExp(true);
    }

    public void operateWithMax(MachineRecipe output, int size) {
        if (output.getRecipe() == null) {
            return;
        }
        int maxSize = 64;
        List<Integer> list = this.updateTick.getRecipeOutput().getList();
        for (int i = 0; i < list.size(); ++i) {
            maxSize = Math.min(maxSize, this.invSlotRecipes.get(i).getCount() / list.get(i));
        }
        size = Math.min(this.getSESize(size), this.getRadiationSize(size));
        this.invSlotRecipes.consume(size, output);
        this.outputSlot.add(output.getRecipe().getOutput().items, size);
        this.consumeSE(size);
        this.consumeRadiation(size);
        if (maxSize == size) {
            this.updateTick.setRecipeOutput(null);
        }
    }

    public void operateWithMax(MachineRecipe output) {
        if (output.getRecipe() == null) {
            return;
        }
        int size = 64;
        List<Integer> list = this.updateTick.getRecipeOutput().getList();
        if (this.invSlotRecipes.getRecipe().workbench()) {
            size = 1;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                size = Math.min(size, this.invSlotRecipes.get(i).getCount() / list.get(i));
            }
        }
        int maxSize = size;
        int count = this.outputSlot.get(0).isEmpty() ? output.getRecipe().output.items.get(0).getMaxStackSize() : this.outputSlot.get(0).getMaxStackSize() - this.outputSlot.get(0).getCount();
        ItemStack outputStack = this.updateTick.getRecipeOutput().getRecipe().output.items.get(0);
        size = Math.min(size, count /= Math.max(outputStack.getCount(), 1));
        size = Math.min(size, this.updateTick.getRecipeOutput().getRecipe().output.items.get(0).getMaxStackSize());
        if (this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null) {
            int size1 = this.invSlotRecipes.getTank().getFluidAmount() / this.updateTick.getRecipeOutput().getRecipe().input.getFluid().getAmount();
            size = Math.min(size, size1);
        }
        size = Math.min(size, this.operationsPerTick);
        size = Math.min(this.getSESize(size), this.getRadiationSize(size));
        this.invSlotRecipes.consume(size, output);
        this.outputSlot.add(output.getRecipe().getOutput().items, size);
        this.consumeSE(size);
        this.consumeRadiation(size);
        if (maxSize == size) {
            this.updateTick.setRecipeOutput(null);
        }
    }

    protected void consumeSE(int size) {
        if (this.componentSE == null) {
            return;
        }
        this.componentSE.useEnergy(5 * size);
    }

    protected void consumeRadiation(int size) {
        if (this.componentRad == null) {
            return;
        }
        if (this.componentRad.delegate instanceof ISource) {
            this.componentRad.addEnergy(150 * size);
            return;
        }
        int amount = this.updateTick.getRecipeOutput().getRecipe().output.metadata.getInt("rad_amount");
        this.componentRad.useEnergy(amount * size);
    }

    protected int getRadiationSize(int size) {
        if (this.componentRad == null) {
            return size;
        }
        if (this.componentRad.delegate instanceof ISource) {
            return (int)((this.componentRad.getCapacity() - this.componentRad.getEnergy()) / 150.0);
        }
        int amount = this.updateTick.getRecipeOutput().getRecipe().output.metadata.getInt("rad_amount");
        return (int)Math.min((double)size, this.componentRad.getEnergy() / (double)amount);
    }

    protected int getSESize(int size) {
        if (this.componentSE == null) {
            return size;
        }
        return (int)Math.min((double)size, this.componentSE.getEnergy() / 5.0);
    }

    public void operate(MachineRecipe output) {
        if (output.getRecipe() == null) {
            return;
        }
        for (int i = 0; i < this.operationsPerTick; ++i) {
            List<ItemStack> processResult = output.getRecipe().output.items;
            this.operateOnce(processResult);
            if (!(this.invSlotRecipes.continue_process(this.updateTick.getRecipeOutput()) && this.outputSlot.canAdd(output.getRecipe().output.items) && this.checkRadiation(false) && this.checkExp(false))) {
                this.getOutput();
                break;
            }
            if (this.updateTick.getRecipeOutput() == null) break;
        }
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setExpSource() {
        this.exp = true;
    }
}

