/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.event.EnergyTileLoadEvent;
import com.denfop.api.energy.event.EnergyTileUnLoadEvent;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.EnergyNetDelegate;
import com.denfop.componets.EnergyNetDelegateDual;
import com.denfop.componets.EnergyNetDelegateMultiDual;
import com.denfop.componets.EnergyNetDelegateSink;
import com.denfop.componets.EnergyNetDelegateSource;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotCharge;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class Energy
extends AbstractComponent {
    public final boolean fullEnergy;
    public final double defaultCapacity;
    public final BufferEnergy buffer;
    public boolean upgrade;
    public int defaultSinkTier;
    public int defaultSourceTier;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public List<InvSlot> managedSlots = new ArrayList<InvSlot>();
    public boolean multiSource = false;
    public int sourcePackets = 1;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public boolean limit;
    public double limit_amount = 0.0;
    private ChunkPos chunkPos;

    public Energy(TileEntityInventory parent, double capacity) {
        this(parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public Energy(TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public Energy(TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.sinkDirections = sinkDirections == null ? Collections.emptySet() : sinkDirections;
        this.sourceDirections = sourceDirections == null ? Collections.emptySet() : sourceDirections;
        this.fullEnergy = fullEnergy;
        this.defaultSinkTier = sinkTier;
        this.defaultSourceTier = sourceTier;
        this.defaultCapacity = capacity;
        this.buffer = new BufferEnergy(0.0, capacity, sinkTier, sourceTier);
    }

    public Energy(TileEntityInventory parent, double capacity, List<Direction> sinkDirections, List<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(parent);
        this.sinkDirections = sinkDirections == null ? Collections.emptySet() : new HashSet<Direction>(sinkDirections);
        this.sourceDirections = sourceDirections == null ? Collections.emptySet() : new HashSet<Direction>(sourceDirections);
        this.fullEnergy = fullEnergy;
        this.defaultSinkTier = sinkTier;
        this.defaultSourceTier = sourceTier;
        this.defaultCapacity = capacity;
        this.buffer = new BufferEnergy(0.0, capacity, sinkTier, sourceTier);
    }

    public static Energy asBasicSink(TileEntityInventory parent, double capacity) {
        return Energy.asBasicSink(parent, capacity, 1);
    }

    public static Energy asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new Energy(parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static Energy asBasicSink(TileEntityInventory parent, double capacity, boolean meta) {
        return new Energy(parent, capacity, ModUtils.allFacings, Collections.emptySet(), 14, 14, false);
    }

    public static Energy asBasicSource(TileEntityInventory parent, double capacity) {
        return Energy.asBasicSource(parent, capacity, 1);
    }

    public static Energy asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new Energy(parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public void onNeighborChange(BlockState srcBlock, BlockPos srcPos) {
        super.onNeighborChange(srcBlock, srcPos);
    }

    @Override
    public void updateEntityServer() {
        if (this.delegate != null) {
            this.delegate.limit_amount = this.limit_amount;
        }
        if (!this.managedSlots.isEmpty()) {
            for (InvSlot slot : this.managedSlots) {
                InvSlotCharge charge;
                double energy;
                if (slot instanceof InvSlotDischarge) {
                    InvSlotDischarge discharge = (InvSlotDischarge)slot;
                    if (discharge.isEmpty()) continue;
                    if (discharge.get(0).getItem() == Items.REDSTONE) {
                        energy = discharge.dischargeWithRedstone(this.buffer.capacity, this.getFreeEnergy());
                        this.addEnergy(energy);
                        continue;
                    }
                    if (!(this.getFreeEnergy() > 0.0)) continue;
                    energy = discharge.discharge(this.getFreeEnergy(), false);
                    this.addEnergy(energy);
                    continue;
                }
                if (!(slot instanceof InvSlotCharge) || (charge = (InvSlotCharge)slot).isEmpty()) continue;
                energy = charge.charge(this.buffer.storage);
                this.useEnergy(energy);
            }
        }
    }

    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.getParent().getBlockPos());
        }
        return this.chunkPos;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public Energy addManagedSlot(InvSlot slot) {
        if (this.managedSlots == null) {
            this.managedSlots = new ArrayList<InvSlot>(4);
        }
        this.managedSlots.add(slot);
        return this;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        this.buffer.storage = nbt.getDouble("storage");
        this.limit_amount = nbt.getDouble("limit_amount");
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag ret = new CompoundTag();
        ret.putDouble("storage", this.buffer.storage);
        ret.putDouble("limit_amount", this.limit_amount);
        return ret;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (!this.parent.getLevel().isClientSide) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                NeoForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.getLevel(), this.delegate));
            }
            this.loaded = true;
        }
    }

    public int getComparatorValue() {
        return Math.min((int)(this.buffer.storage * 15.0 / this.buffer.capacity), 15);
    }

    public void setLimit(boolean limit) {
        this.limit = limit;
        if (this.delegate != null) {
            this.delegate.limit = limit;
        }
    }

    public void createDelegate() {
        if (this.delegate == null) {
            this.delegate = !this.multiSource ? (this.sinkDirections.isEmpty() ? new EnergyNetDelegateSource(this) : (this.sourceDirections.isEmpty() ? new EnergyNetDelegateSink(this) : new EnergyNetDelegateDual(this))) : new EnergyNetDelegateMultiDual(this);
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            NeoForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.getLevel(), this.delegate));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16, player.registryAccess());
        buffer.writeDouble(this.buffer.capacity);
        buffer.writeDouble(this.buffer.storage);
        buffer.writeDouble(this.limit_amount);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.buffer.capacity);
        buffer.writeDouble(this.buffer.storage);
        buffer.writeDouble(this.limit_amount);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.buffer.capacity = is.readDouble();
        this.buffer.storage = is.readDouble();
        this.limit_amount = is.readDouble();
    }

    public double getDefaultCapacity() {
        return this.defaultCapacity;
    }

    public double getCapacity() {
        return this.buffer.capacity;
    }

    public void setCapacity(double capacity) {
        this.buffer.capacity = capacity;
        this.buffer.storage = Math.min(this.buffer.capacity, this.buffer.storage);
    }

    public void addCapacity(double capacity) {
        this.buffer.capacity += capacity;
    }

    public double getEnergy() {
        return this.buffer.storage;
    }

    public double getFreeEnergy() {
        return Math.max(0.0, this.buffer.capacity - this.buffer.storage);
    }

    public double getFillRatio() {
        if (this.buffer.storage > this.buffer.capacity) {
            this.buffer.storage = this.buffer.capacity;
        }
        return this.buffer.storage / this.buffer.capacity;
    }

    public double addEnergy(double amount) {
        amount = Math.min(this.buffer.capacity - this.buffer.storage, amount);
        this.buffer.storage += amount;
        this.buffer.storage = Math.min(this.buffer.storage, this.buffer.capacity);
        return amount;
    }

    public void forceAddEnergy(double amount) {
        this.buffer.storage += amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.buffer.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.buffer.storage >= amount) {
            this.buffer.storage -= amount;
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.buffer.storage) - amount);
        if (!simulate) {
            this.buffer.storage -= ret;
        }
        return ret;
    }

    public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
        InvSlot discharge;
        int tier;
        if (this.getDelegate() instanceof IEnergySink) {
            tier = invSlotUpgrade.getTier(this.defaultSinkTier);
            this.setSinkTier(tier);
            for (InvSlot slot : this.managedSlots) {
                if (!(slot instanceof InvSlotDischarge)) continue;
                discharge = (InvSlotDischarge)slot;
                ((InvSlotDischarge)discharge).setTier(tier);
            }
        }
        if (this.getDelegate() instanceof IEnergySource) {
            tier = invSlotUpgrade.getTier(this.defaultSourceTier);
            this.setSourceTier(tier);
            for (InvSlot slot : this.managedSlots) {
                if (!(slot instanceof InvSlotCharge)) continue;
                discharge = (InvSlotCharge)slot;
                ((InvSlotCharge)discharge).setTier(tier);
            }
        }
        this.setCapacity(invSlotUpgrade.getEnergyStorage(this.defaultCapacity));
    }

    public int getSinkTier() {
        return this.buffer.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.buffer.sinkTier = tier;
        for (InvSlot slot : this.managedSlots) {
            if (!(slot instanceof InvSlotDischarge)) continue;
            InvSlotDischarge discharge = (InvSlotDischarge)slot;
            discharge.setTier(tier);
        }
    }

    public int getSourceTier() {
        return this.buffer.sourceTier;
    }

    public void setSourceTier(int tier) {
        for (InvSlot slot : this.managedSlots) {
            if (!(slot instanceof InvSlotCharge)) continue;
            InvSlotCharge discharge = (InvSlotCharge)slot;
            discharge.setTier(tier);
        }
        this.buffer.sourceTier = tier;
    }

    public void setEnabled(boolean enabled) {
        if (this.delegate != null) {
            this.delegate.sendingSidabled = !enabled;
            this.delegate.receivingDisabled = this.delegate.sendingSidabled;
        }
    }

    public void setReceivingEnabled(boolean enabled) {
        if (this.delegate != null) {
            this.delegate.receivingDisabled = !enabled;
        }
    }

    public void setSendingEnabled(boolean enabled) {
        if (this.delegate != null) {
            this.delegate.sendingSidabled = !enabled;
        }
    }

    public Energy setMultiSource(boolean multiSource) {
        this.multiSource = multiSource;
        if (!multiSource) {
            this.sourcePackets = 1;
        }
        return this;
    }

    public void setPacketOutput(int number) {
        if (this.multiSource) {
            this.sourcePackets = number;
        }
    }

    public void setDirections(Set<Direction> sinkDirections, Set<Direction> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.getLevel().isClientSide);
            NeoForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.getLevel(), this.delegate));
        }
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            this.delegate.sourceDirections = sourceDirections;
            this.delegate.sinkDirections = sinkDirections;
            assert (!this.parent.getLevel().isClientSide);
            this.delegate.energyConductorMap.clear();
            this.delegate.validReceivers.clear();
            NeoForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.getLevel(), this.delegate));
        }
    }

    public void setDirections(List<Direction> sinkDirections, List<Direction> sourceDirections) {
        if (this.delegate != null) {
            assert (!this.parent.getLevel().isClientSide);
            NeoForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.parent.getLevel(), this.delegate));
        }
        this.sinkDirections = new HashSet<Direction>(sinkDirections);
        this.sourceDirections = new HashSet<Direction>(sourceDirections);
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            this.delegate.sourceDirections = new HashSet<Direction>(sourceDirections);
            this.delegate.sinkDirections = new HashSet<Direction>(sinkDirections);
            this.delegate.energyConductorMap.clear();
            assert (!this.parent.getLevel().isClientSide);
            NeoForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.parent.getLevel(), this.delegate));
        }
    }

    public Set<Direction> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<Direction> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }

    public IEnergyTile getDelegate() {
        return this.delegate;
    }
}

