/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.container;

import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.container.ContainerHandHeldInventory;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.crop.ItemStackAgriculturalAnalyzer;
import com.denfop.utils.ModUtils;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerAgriculturalAnalyzer
extends ContainerHandHeldInventory<ItemStackAgriculturalAnalyzer> {
    public final int inventorySize;
    private final int current;

    public ContainerAgriculturalAnalyzer(Player player, final ItemStackAgriculturalAnalyzer Toolbox1) {
        super(Toolbox1, player);
        this.player = player;
        this.inventory = player.getInventory();
        this.inventorySize = Toolbox1.inventorySize;
        int slots = Toolbox1.inventorySize;
        this.addSlotToContainer(new Slot(this, Toolbox1, 0, 180, 65){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof ICropItem;
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void set(ItemStack stack) {
                super.set(stack);
                if (stack.isEmpty()) {
                    Toolbox1.crop = null;
                    Toolbox1.genome = null;
                } else {
                    Toolbox1.genome = new Genome(stack);
                    Toolbox1.crop = CropNetwork.instance.getCropFromStack(stack).copy();
                    Toolbox1.genome.loadCrop(Toolbox1.crop);
                }
            }
        });
        this.current = player.getInventory().selected;
        this.addPlayerInventorySlots(player.getInventory(), 233);
    }

    @Override
    protected void addPlayerInventorySlots(Inventory inventory, int width, int height) {
        int xStart = (width - 162) / 2;
        for (int col = 0; col < 9; ++col) {
            this.addSlotToContainer(new Slot((Container)this.player.getInventory(), col, xStart + col * 18, height + -24));
        }
    }

    @Override
    public void clicked(int slot, int button, ClickType type, Player player) {
        ItemStack held;
        if (slot >= 0 && slot < this.slots.size() && ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem())) {
            return;
        }
        boolean closeGUI = false;
        block0 : switch (type) {
            case CLONE: 
            case PICKUP_ALL: 
            case QUICK_CRAFT: {
                break;
            }
            case PICKUP: 
            case THROW: {
                if (slot < 0 || slot >= this.slots.size()) break;
                closeGUI = ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                break;
            }
            case QUICK_MOVE: {
                if (slot < 0 || slot >= this.slots.size() || !((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem())) break;
                this.setCarried(ModUtils.emptyStack);
                break;
            }
            case SWAP: {
                if (button == this.current) {
                    this.setCarried(ItemStack.EMPTY);
                    return;
                }
                assert (this.getSlotFromInventory((Container)player.getInventory(), button) != null);
                boolean swapOut = ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(this.getSlotFromInventory((Container)player.getInventory(), button).getItem());
                boolean swapTo = ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                if (!swapOut && !swapTo) break;
                for (int i = 0; i < 9; ++i) {
                    if ((!swapOut || slot != Objects.requireNonNull(this.getSlotFromInventory((Container)player.getInventory(), (int)i)).index) && (!swapTo || button != i)) continue;
                    if (!(player instanceof ServerPlayer)) break block0;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.send((Packet)new ClientboundSetCarriedItemPacket(i));
                    break block0;
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ClickType: " + String.valueOf(type));
            }
        }
        ItemStack stack = this.slotClick1(slot, button, type, player);
        if (closeGUI && !player.level().isClientSide()) {
            ((ItemStackAgriculturalAnalyzer)this.base).saveAsThrown(stack);
            player.closeContainer();
        } else if (type == ClickType.CLONE && ((ItemStackAgriculturalAnalyzer)this.base).isThisContainer(held = player.getInventory().getSelected())) {
            ((ContainerItem)held.getOrDefault(DataComponentsInit.CONTAINER, (Object)ContainerItem.EMPTY)).updateUUID(held, 0);
        }
        this.setCarried(stack);
    }

    public ItemStack slotClick1(int slotId, int dragType, ClickType clickType, Player player) {
        super.clicked(slotId, dragType, clickType, player);
        return this.getCarried();
    }
}

