/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datacomponent;

import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeModificator;
import com.denfop.datacomponent.DataComponentsInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record UpgradeItem(List<UpgradeItemInform> upgradeItemInforms, boolean isRegistry, List<UpgradeModificator> upgradeModificators, int amount, List<Integer> listUpgrades, List<String> blackList, boolean canupgrade) {
    public static final Codec<UpgradeItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UpgradeItemInform.CODEC.listOf().fieldOf("upgradeItemInforms").forGetter(UpgradeItem::upgradeItemInforms), (App)Codec.BOOL.fieldOf("isRegistry").forGetter(UpgradeItem::isRegistry), (App)UpgradeModificator.CODEC.listOf().fieldOf("upgradeModificators").forGetter(UpgradeItem::upgradeModificators), (App)Codec.INT.fieldOf("amount").forGetter(UpgradeItem::amount), (App)Codec.INT.listOf().fieldOf("listUpgrades").forGetter(UpgradeItem::listUpgrades), (App)Codec.STRING.listOf().fieldOf("blackList").forGetter(UpgradeItem::blackList), (App)Codec.BOOL.fieldOf("canUpgrade").forGetter(UpgradeItem::canupgrade)).apply((Applicative)instance, UpgradeItem::new));
    public static final StreamCodec<FriendlyByteBuf, UpgradeItem> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        buf.writeCollection(value.upgradeItemInforms(), (b, v) -> UpgradeItemInform.STREAM_CODEC.encode(b, v));
        buf.writeBoolean(value.isRegistry());
        buf.writeCollection(value.upgradeModificators(), (b, v) -> UpgradeModificator.STREAM_CODEC.encode(b, v));
        buf.writeInt(value.amount());
        buf.writeCollection(value.listUpgrades(), FriendlyByteBuf::writeInt);
        buf.writeCollection(value.blackList(), FriendlyByteBuf::writeUtf);
        buf.writeBoolean(value.isRegistry());
    }, buf -> {
        UpgradeItem upgradeItem = new UpgradeItem(buf.readList(arg_0 -> UpgradeItemInform.STREAM_CODEC.decode(arg_0)), buf.readBoolean(), buf.readList(arg_0 -> UpgradeModificator.STREAM_CODEC.decode(arg_0)), buf.readInt(), buf.readList(FriendlyByteBuf::readInt), buf.readList(FriendlyByteBuf::readUtf), buf.readBoolean());
        return upgradeItem;
    });
    public static UpgradeItem EMPTY = new UpgradeItem(new ArrayList<UpgradeItemInform>(), false, new ArrayList<UpgradeModificator>(), 0, new ArrayList<Integer>(), new ArrayList<String>(), true);

    public UpgradeItem copy() {
        return new UpgradeItem(new ArrayList<UpgradeItemInform>(), false, new ArrayList<UpgradeModificator>(), 0, new ArrayList<Integer>(), new ArrayList<String>(), true);
    }

    public UpgradeItem updateUpgrades(ItemStack stack, List<UpgradeItemInform> upgradeItemInforms) {
        UpgradeItem updated = new UpgradeItem(upgradeItemInforms, this.isRegistry, this.upgradeModificators, this.amount, this.listUpgrades, this.blackList, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ITEM.get(), (Object)updated);
        return updated;
    }

    public UpgradeItem updateRegistry(ItemStack stack, boolean isRegistry) {
        UpgradeItem updated = new UpgradeItem(this.upgradeItemInforms, isRegistry, this.upgradeModificators, this.amount, this.listUpgrades, this.blackList, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ITEM.get(), (Object)updated);
        return updated;
    }

    public UpgradeItem updateModificator(ItemStack stack, List<UpgradeModificator> upgradeModificators) {
        UpgradeItem updated = new UpgradeItem(this.upgradeItemInforms, this.isRegistry, upgradeModificators, this.amount, this.listUpgrades, this.blackList, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ITEM.get(), (Object)updated);
        return updated;
    }

    public UpgradeItem updateAmount(ItemStack stack, int amount) {
        UpgradeItem updated = new UpgradeItem(this.upgradeItemInforms, this.isRegistry, this.upgradeModificators, amount, this.listUpgrades, this.blackList, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ITEM.get(), (Object)updated);
        return updated;
    }

    public UpgradeItem updateListUpgrades(ItemStack stack, List<Integer> listUpgrades) {
        UpgradeItem updated = new UpgradeItem(this.upgradeItemInforms, this.isRegistry, this.upgradeModificators, this.amount, listUpgrades, this.blackList, this.canupgrade);
        stack.set(DataComponentsInit.UPGRADE_ITEM, (Object)updated);
        return updated;
    }

    public UpgradeItem updateBlackList(ItemStack stack, List<String> blackList) {
        UpgradeItem updated = new UpgradeItem(this.upgradeItemInforms, this.isRegistry, this.upgradeModificators, this.amount, this.listUpgrades, blackList, this.canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ITEM.get(), (Object)updated);
        return updated;
    }

    public UpgradeItem updateCanUpgrade(ItemStack stack, boolean canupgrade) {
        UpgradeItem updated = new UpgradeItem(this.upgradeItemInforms, this.isRegistry, this.upgradeModificators, this.amount, this.listUpgrades, this.blackList, canupgrade);
        stack.set((DataComponentType)DataComponentsInit.UPGRADE_ITEM.get(), (Object)updated);
        return updated;
    }
}

