/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.entity;

import com.denfop.entity.SmallBee;
import com.denfop.mixin.access.BeeAccessor;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

class CollectCustomNectarGoal
extends Goal {
    private final SmallBee bee;
    private BlockPos cropTarget;

    public CollectCustomNectarGoal(SmallBee bee) {
        this.bee = bee;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.bee.crops == null) {
            return true;
        }
        if (this.bee.hasCustomNectar()) {
            return false;
        }
        if (this.bee.crops.isEmpty()) {
            this.bee.discard();
            return false;
        }
        this.cropTarget = this.bee.crops.get((int)this.bee.level().random.nextInt((int)this.bee.crops.size())).pos;
        return true;
    }

    public void start() {
        if (this.cropTarget != null) {
            this.bee.pathfindRandomlyTowards(this.cropTarget);
        }
    }

    public void spawnBonemealParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = level.getRandom();
            for (int i = 0; i < 15; ++i) {
                double x = (double)pos.getX() + random.nextDouble();
                double y = pos.getY();
                double z = (double)pos.getZ() + random.nextDouble();
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x, y, z, 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public void tick() {
        if (this.bee.crops == null) {
            this.bee.discard();
            return;
        }
        if (this.cropTarget != null && this.bee.position().distanceTo(Vec3.atCenterOf((Vec3i)this.cropTarget)) < 1.0) {
            if (!this.bee.level().isClientSide()) {
                ((ServerLevel)this.bee.level()).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.8f, 0.2f), 1.0f), (double)this.cropTarget.getX(), (double)this.cropTarget.getY() + 0.3, (double)this.cropTarget.getZ(), 10, 0.1, 0.1, 0.1, 0.01);
                this.spawnBonemealParticles(this.bee.level(), this.cropTarget);
                ((BeeAccessor)((Object)this.bee)).invokeSetFlag(8, true);
            }
            this.bee.setHasCustomNectar(true);
            this.cropTarget = null;
        } else {
            this.bee.pathfindRandomlyTowards(this.cropTarget.below());
        }
    }

    public boolean canContinueToUse() {
        return this.cropTarget != null && !this.bee.hasCustomNectar();
    }
}

