/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockApatite;
import com.denfop.blocks.BlockClassicOre;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import com.denfop.blocks.BlockOre;
import com.denfop.blocks.BlockOres2;
import com.denfop.blocks.BlockOres3;
import com.denfop.blocks.BlockPreciousOre;
import com.denfop.blocks.BlockThoriumOre;
import com.denfop.blocks.BlocksRadiationOre;
import com.denfop.blocks.blockitem.ItemBlockApatite;
import com.denfop.blocks.blockitem.ItemBlockClassicOre;
import com.denfop.blocks.blockitem.ItemBlockHeavyOre;
import com.denfop.blocks.blockitem.ItemBlockMineral;
import com.denfop.blocks.blockitem.ItemBlockOre;
import com.denfop.blocks.blockitem.ItemBlockOre2;
import com.denfop.blocks.blockitem.ItemBlockOre3;
import com.denfop.blocks.blockitem.ItemBlockPreciousOre;
import com.denfop.blocks.blockitem.ItemBlockRadiationOre;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.events.ClientTickHandler;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.energy.instruments.EnumOperations;
import com.denfop.items.energy.instruments.ItemEnergyInstruments;
import com.denfop.mixin.invoker.ParticleInvoker;
import com.denfop.render.base.RenderType;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class TickHandler {
    final int latitudeSegments = 4;
    final int longitudeSegments = 4;
    double[] sinLat = new double[5];
    double[] cosLat = new double[5];
    double[] sinLng = new double[5];
    double[] cosLng = new double[5];
    boolean write = false;
    double[][] x1 = new double[4][4];
    double[][] x2 = new double[4][4];
    double[][] x3 = new double[4][4];
    double[][] x4 = new double[4][4];
    double[][] y1 = new double[4][4];
    double[][] y2 = new double[4][4];
    double[][] y3 = new double[4][4];
    double[][] y4 = new double[4][4];
    double[][] z1 = new double[4][4];
    double[][] z2 = new double[4][4];
    double[][] z3 = new double[4][4];
    double[][] z4 = new double[4][4];
    Set<UpgradableProperty> set = EnumSet.of(UpgradableProperty.FluidExtract, UpgradableProperty.FluidInput, UpgradableProperty.ItemInput, UpgradableProperty.ItemExtract);

    public TickHandler() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level p_41436_, Player p_41437_, ClipContext.Fluid p_41438_) {
        Vec3 vec3 = p_41437_.getEyePosition();
        Vec3 vec31 = vec3.add(p_41437_.calculateViewVector(p_41437_.getXRot(), p_41437_.getYRot()).scale(p_41437_.blockInteractionRange()));
        return p_41436_.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, (Entity)p_41437_));
    }

    @SubscribeEvent
    public void initData(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide) {
            IUCore.instance.registerData(event.getLevel());
        }
    }

    public int getOreColor(BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.IRON_ORE) {
            return ModUtils.convertRGBcolorToInt(156, 156, 156);
        }
        if (block == Blocks.GOLD_ORE || block == Blocks.NETHER_GOLD_ORE) {
            return -10496;
        }
        if (block == Blocks.DIAMOND_ORE) {
            return -16711681;
        }
        if (block == Blocks.LAPIS_ORE) {
            return ModUtils.convertRGBcolorToInt(30, 50, 173);
        }
        if (block == Blocks.REDSTONE_ORE) {
            return ModUtils.convertRGBcolorToInt(173, 30, 30);
        }
        if (block == Blocks.COAL_ORE) {
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block == Blocks.EMERALD_ORE) {
            return ModUtils.convertRGBcolorToInt(0, 232, 0);
        }
        if (block == Blocks.NETHER_QUARTZ_ORE) {
            return ModUtils.convertRGBcolorToInt(223, 223, 223);
        }
        if (block == IUItem.toriyore.getBlock(0)) {
            return ModUtils.convertRGBcolorToInt(134, 134, 139);
        }
        if (block instanceof BlockClassicOre) {
            int meta = IUItem.classic_ore.getMeta((ItemBlockClassicOre)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(255, 144, 0);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(223, 223, 223);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(168, 176, 150);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(89, 158, 73);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlocksRadiationOre) {
            int meta = IUItem.radiationore.getMeta((ItemBlockRadiationOre)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(120, 152, 183);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(97, 109, 88);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 166, 148);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockPreciousOre) {
            int meta = IUItem.preciousore.getMeta((ItemBlockPreciousOre)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(251, 140, 119);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(38, 60, 143);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(204, 180, 47);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOre) {
            int meta = IUItem.ore.getMeta((ItemBlockOre)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(119, 210, 202);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(108, 74, 108);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(142, 240, 216);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(199, 199, 199);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(0, 166, 226);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(170, 145, 160);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(145, 143, 88);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(104, 152, 237);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(71, 71, 71);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(83, 174, 85);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(184, 87, 145);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(211, 211, 211);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(186, 186, 186);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(235, 193, 207);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(234, 234, 234);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(138, 85, 34);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockHeavyOre) {
            int meta = IUItem.heavyore.getMeta((ItemBlockHeavyOre)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(137, 131, 149);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(249, 175, 44);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(150, 215, 206);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(211, 202, 110);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(212, 175, 55);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(250, 246, 241);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(70, 145, 15);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(230, 107, 0);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(139, 0, 0);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(55, 135, 135);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(170, 123, 44);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(109, 206, 167);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 110, 110);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(198, 147, 64);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(100, 76, 136);
                }
                case 15: {
                    return ModUtils.convertRGBcolorToInt(135, 84, 64);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockMineral) {
            int meta = IUItem.mineral.getMeta((ItemBlockMineral)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(12, 166, 166);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(55, 117, 104);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(113, 97, 81);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(99, 51, 4);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(117, 88, 86);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(118, 28, 17);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(123, 76, 10);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(126, 101, 36);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(30, 126, 56);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(112, 129, 30);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(39, 64, 63);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(110, 25, 24);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres3) {
            int meta = IUItem.ore3.getMeta((ItemBlockOre3)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(191, 212, 65);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(253, 242, 80);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(37, 145, 133);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(255, 180, 0);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(252, 187, 89);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(212, 231, 255);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(222, 101, 98);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(118, 84, 192);
                }
                case 8: {
                    return ModUtils.convertRGBcolorToInt(125, 122, 160);
                }
                case 9: {
                    return ModUtils.convertRGBcolorToInt(61, 148, 224);
                }
                case 10: {
                    return ModUtils.convertRGBcolorToInt(230, 105, 17);
                }
                case 11: {
                    return ModUtils.convertRGBcolorToInt(84, 194, 246);
                }
                case 12: {
                    return ModUtils.convertRGBcolorToInt(168, 90, 41);
                }
                case 13: {
                    return ModUtils.convertRGBcolorToInt(121, 229, 71);
                }
                case 14: {
                    return ModUtils.convertRGBcolorToInt(255, 225, 136);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockOres2) {
            int meta = IUItem.ore2.getMeta((ItemBlockOre2)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(190, 207, 214);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(194, 194, 194);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(62, 69, 71);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(165, 236, 244);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(141, 174, 83);
                }
                case 5: {
                    return ModUtils.convertRGBcolorToInt(177, 100, 197);
                }
                case 6: {
                    return ModUtils.convertRGBcolorToInt(43, 43, 43);
                }
                case 7: {
                    return ModUtils.convertRGBcolorToInt(212, 212, 212);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        if (block instanceof BlockApatite) {
            int meta = IUItem.apatite.getMeta((ItemBlockApatite)state.getBlock().asItem());
            switch (meta) {
                case 0: {
                    return ModUtils.convertRGBcolorToInt(48, 86, 16);
                }
                case 1: {
                    return ModUtils.convertRGBcolorToInt(134, 95, 11);
                }
                case 2: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 3: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
                case 4: {
                    return ModUtils.convertRGBcolorToInt(202, 202, 202);
                }
            }
            return ModUtils.convertRGBcolorToInt(4, 4, 4);
        }
        return -1;
    }

    private int getRadiationTier(Level world, ChunkPos chunkPos) {
        Radiation rad = RadiationSystem.rad_system.getMap().get(chunkPos);
        return rad == null ? 0 : rad.getLevel().ordinal();
    }

    public int clamp(int a, int min, int max) {
        return a < min ? min : (a > max ? max : a);
    }

    public void showRadiationEffects(LocalPlayer player, Level world, ChunkPos chunkPos, int tier) {
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        int particleCount = this.clamp(tier * 30, 30, 120);
        double minX = chunkPos.getMinBlockX();
        double maxX = chunkPos.getMaxBlockX() + 1;
        double minZ = chunkPos.getMinBlockZ();
        double maxZ = chunkPos.getMaxBlockZ() + 1;
        XoroshiroRandomSource rand = new XoroshiroRandomSource(world.getGameTime());
        for (int i = 0; i < particleCount; ++i) {
            Particle particle;
            double x;
            double y = player.getY() + rand.nextDouble() * 16.0;
            Vec3 position = new Vec3(x, y, switch (rand.nextInt(4)) {
                case 0 -> {
                    x = minX;
                    yield minZ + rand.nextDouble() * 16.0;
                }
                case 1 -> {
                    x = maxX;
                    yield minZ + rand.nextDouble() * 16.0;
                }
                case 2 -> {
                    x = minX + rand.nextDouble() * 16.0;
                    yield minZ;
                }
                default -> {
                    x = minX + rand.nextDouble() * 16.0;
                    yield maxZ;
                }
            });
            boolean isPortal = rand.nextBoolean();
            Particle particle2 = particle = isPortal ? particleEngine.createParticle((ParticleOptions)ParticleTypes.PORTAL, position.x, position.y, position.z, 0.0, 0.0, 0.0) : particleEngine.createParticle((ParticleOptions)ParticleTypes.SMOKE, position.x, position.y, position.z, 0.0, 0.0, 0.0);
            if (particle == null) continue;
            if (isPortal) {
                particle.setColor(0.0f, 1.0f - (float)tier * 0.2f, 0.0f);
                ((ParticleInvoker)particle).invokeSetAlpha(0.5f + rand.nextFloat() * 0.5f);
                continue;
            }
            particle.setColor(0.1f, 0.9f - (float)tier * 0.15f, 0.1f);
            ((ParticleInvoker)particle).invokeSetAlpha(0.7f + rand.nextFloat() * 0.3f);
            particle.setLifetime(40);
        }
    }

    public Direction getDirection(ItemStack stack) {
        byte rawDir = (Byte)stack.getOrDefault(DataComponentsInit.DIRECTION, (Object)0);
        return rawDir >= 1 && rawDir <= 6 ? Direction.values()[rawDir - 1] : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTileSide(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null) {
            return;
        }
        Item item = player.getMainHandItem().getItem();
        if (!(item instanceof IUpgradeItem)) {
            return;
        }
        IUpgradeItem upgradeItem = (IUpgradeItem)item;
        if (!upgradeItem.isSuitableFor(player.getMainHandItem(), this.set)) {
            return;
        }
        if (mc.level == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        BlockHitResult ray = TickHandler.getPlayerPOVHitResult((Level)mc.level, (Player)mc.player, ClipContext.Fluid.NONE);
        if (ray == null || ray.getType() != HitResult.Type.BLOCK) {
            return;
        }
        Direction facing = this.getDirection(player.getMainHandItem());
        BlockEntity tile = player.level().getBlockEntity(ray.getBlockPos());
        if (!(tile instanceof IUpgradableBlock)) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Matrix4f matrix = poseStack.last().pose();
        if (facing != null) {
            BlockPos pos = ray.getBlockPos().offset(facing.getNormal());
            boolean xRange = false;
            boolean yRange = false;
            boolean zRange = false;
            Vec3 camera = event.getCamera().getPosition();
            double x = camera.x;
            double y = camera.y;
            double z = camera.z;
            poseStack.pushPose();
            poseStack.translate(-x, -y, -z);
            x = pos.getX();
            y = pos.getY();
            z = pos.getZ();
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer p_109623_ = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(net.minecraft.client.renderer.RenderType.lines());
            RenderSystem.lineWidth((float)10.0f);
            Vec3 lookVec = player.getLookAngle();
            int xPos = (int)(x - (double)xRange);
            while ((double)xPos <= x + (double)xRange) {
                int yPos = (int)(y - (double)yRange);
                while ((double)yPos <= y + (double)yRange) {
                    int zPos = (int)(z - (double)zRange);
                    while ((double)zPos <= z + (double)zRange) {
                        BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                        Vec3 blockVec = new Vec3((double)currentPos.getX() + 0.5 - player.getX(), (double)currentPos.getY() + 0.5 - player.getY(), (double)currentPos.getZ() + 0.5 - player.getZ());
                        float p_109630_ = 1.0f;
                        float p_109635_ = 1.0f;
                        float p_109636_ = 1.0f;
                        float p_109633_ = 1.0f;
                        float p_109634_ = 1.0f;
                        float p_109631_ = 1.0f;
                        float p_109632_ = 1.0f;
                        Matrix4f matrix4f = poseStack.last().pose();
                        Matrix3f matrix3f = poseStack.last().normal();
                        int f = currentPos.getX();
                        int f1 = currentPos.getY();
                        int f2 = currentPos.getZ();
                        int f3 = currentPos.getX() + 1;
                        int f4 = currentPos.getY() + 1;
                        int f5 = currentPos.getZ() + 1;
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(p_109630_, p_109635_, p_109636_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(p_109630_, p_109635_, p_109636_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(p_109634_, p_109631_, p_109636_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(p_109634_, p_109631_, p_109636_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(p_109634_, p_109635_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(p_109634_, p_109635_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, -1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, -1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, -1.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, -1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        ++zPos;
                    }
                    ++yPos;
                }
                ++xPos;
            }
            RenderSystem.disableDepthTest();
            poseStack.popPose();
        } else {
            for (Direction facing1 : Direction.values()) {
                BlockPos pos = ray.getBlockPos().offset(facing1.getNormal());
                boolean xRange = false;
                boolean yRange = false;
                boolean zRange = false;
                Vec3 camera = event.getCamera().getPosition();
                double x = camera.x;
                double y = camera.y;
                double z = camera.z;
                poseStack.pushPose();
                poseStack.translate(-x, -y, -z);
                x = pos.getX();
                y = pos.getY();
                z = pos.getZ();
                RenderSystem.enableDepthTest();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                VertexConsumer p_109623_ = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(net.minecraft.client.renderer.RenderType.lines());
                RenderSystem.lineWidth((float)10.0f);
                Vec3 lookVec = player.getLookAngle();
                int xPos = (int)(x - (double)xRange);
                while ((double)xPos <= x + (double)xRange) {
                    int yPos = (int)(y - (double)yRange);
                    while ((double)yPos <= y + (double)yRange) {
                        int zPos = (int)(z - (double)zRange);
                        while ((double)zPos <= z + (double)zRange) {
                            BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                            Vec3 blockVec = new Vec3((double)currentPos.getX() + 0.5 - player.getX(), (double)currentPos.getY() + 0.5 - player.getY(), (double)currentPos.getZ() + 0.5 - player.getZ());
                            float p_109630_ = 1.0f;
                            float p_109635_ = 1.0f;
                            float p_109636_ = 1.0f;
                            float p_109633_ = 1.0f;
                            float p_109634_ = 1.0f;
                            float p_109631_ = 1.0f;
                            float p_109632_ = 1.0f;
                            Matrix4f matrix4f = poseStack.last().pose();
                            Matrix3f matrix3f = poseStack.last().normal();
                            int f = currentPos.getX();
                            int f1 = currentPos.getY();
                            int f2 = currentPos.getZ();
                            int f3 = currentPos.getX() + 1;
                            int f4 = currentPos.getY() + 1;
                            int f5 = currentPos.getZ() + 1;
                            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(p_109630_, p_109635_, p_109636_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(p_109630_, p_109635_, p_109636_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(p_109634_, p_109631_, p_109636_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(p_109634_, p_109631_, p_109636_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(p_109634_, p_109635_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(p_109634_, p_109635_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, -1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, -1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, -1.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, -1.0f);
                            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                            ++zPos;
                        }
                        ++yPos;
                    }
                    ++xPos;
                }
                RenderSystem.disableDepthTest();
                poseStack.popPose();
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorld(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null || minecraft.level == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (player != null && minecraft.hitResult instanceof BlockHitResult) {
            BlockHitResult ray = (BlockHitResult)minecraft.hitResult;
            if (!(player.getMainHandItem().getItem() instanceof ItemEnergyInstruments)) {
                return;
            }
            if (ray.getType() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos blockPos = ray.getBlockPos();
            PoseStack poseStack = event.getPoseStack();
            float size = 1.0f;
            ItemEnergyInstruments instruments = (ItemEnergyInstruments)player.getMainHandItem().getItem();
            ItemStack stack = player.getMainHandItem();
            List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
            int toolMode = instruments.readToolMode(stack);
            EnumOperations operations = instruments.getOperations().get(toolMode);
            int aoe = 0;
            int dig_depth = 0;
            switch (operations) {
                case BIGHOLES: {
                    aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                    ++aoe;
                    dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                    List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                    if (list == null || list.size() < 5) break;
                    dig_depth += list.get(4).intValue();
                    break;
                }
                case MEGAHOLES: {
                    aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                    aoe += 2;
                    dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                    List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                    if (list == null || list.size() < 5) break;
                    dig_depth += list.get(4).intValue();
                    break;
                }
                case ULTRAHOLES: {
                    aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0;
                    aoe += 3;
                    dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0;
                    List<Integer> list = UpgradeSystem.system.getUpgradeFromList(stack);
                    if (list == null || list.size() < 5) break;
                    dig_depth += list.get(4).intValue();
                    break;
                }
            }
            Minecraft mc = Minecraft.getInstance();
            BlockPos pos = ray.getBlockPos();
            int xRange = aoe;
            int yRange = aoe;
            int zRange = aoe;
            switch (ray.getDirection().ordinal()) {
                case 0: 
                case 1: {
                    yRange = dig_depth;
                    break;
                }
                case 2: 
                case 3: {
                    zRange = dig_depth;
                    break;
                }
                case 4: 
                case 5: {
                    xRange = dig_depth;
                }
            }
            int Yy = yRange > 0 ? yRange - 1 : 0;
            poseStack.pushPose();
            double camX = mc.gameRenderer.getMainCamera().getPosition().x();
            double camY = mc.gameRenderer.getMainCamera().getPosition().y();
            double camZ = mc.gameRenderer.getMainCamera().getPosition().z();
            poseStack.translate(-camX, -camY, -camZ);
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            Tesselator tessellator = Tesselator.getInstance();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer p_109623_ = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(net.minecraft.client.renderer.RenderType.lines());
            RenderSystem.lineWidth((float)10.0f);
            Vec3 lookVec = player.getLookAngle();
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        BlockPos currentPos = new BlockPos(xPos, yPos, zPos);
                        BlockState state = player.level().getBlockState(currentPos);
                        if (state.isAir()) continue;
                        float p_109630_ = 1.0f;
                        float p_109635_ = 1.0f;
                        float p_109636_ = 1.0f;
                        float p_109633_ = 1.0f;
                        float p_109634_ = 1.0f;
                        float p_109631_ = 1.0f;
                        float p_109632_ = 1.0f;
                        Matrix4f matrix4f = poseStack.last().pose();
                        Matrix3f matrix3f = poseStack.last().normal();
                        int f = currentPos.getX();
                        int f1 = currentPos.getY();
                        int f2 = currentPos.getZ();
                        int f3 = currentPos.getX() + 1;
                        int f4 = currentPos.getY() + 1;
                        int f5 = currentPos.getZ() + 1;
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(0.0f, p_109635_, 0.0f, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(0.0f, p_109635_, 0.0f, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(0.0f, p_109635_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(0.0f, p_109635_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), -1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, -1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, -1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, -1.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, -1.0f);
                        p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 1.0f, 0.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                        p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(0.0f, p_109631_, 0.0f, p_109633_).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
                    }
                }
            }
            RenderSystem.disableDepthTest();
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public void onRenderOres(RenderLevelStageEvent event) {
        HitResult ray;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (!(player.getMainHandItem().getItem() instanceof ItemEnergyInstruments)) {
            return;
        }
        if (!this.write) {
            this.writeData();
        }
        if (!((ray = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockRay = (BlockHitResult)ray;
        ItemStack stack = player.getMainHandItem();
        ItemEnergyInstruments instruments = (ItemEnergyInstruments)stack.getItem();
        int toolMode = instruments.readToolMode(stack);
        EnumOperations operations = instruments.getOperations().get(toolMode);
        if (operations != EnumOperations.ORE) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        BlockPos centerPos = blockRay.getBlockPos();
        double camX = mc.gameRenderer.getMainCamera().getPosition().x();
        double camY = mc.gameRenderer.getMainCamera().getPosition().y();
        double camZ = mc.gameRenderer.getMainCamera().getPosition().z();
        for (int x = centerPos.getX() - 5; x <= centerPos.getX() + 5; ++x) {
            for (int y = centerPos.getY() - 5; y <= centerPos.getY() + 5; ++y) {
                for (int z = centerPos.getZ() - 5; z <= centerPos.getZ() + 5; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = player.level().getBlockState(pos);
                    if (!this.isOre(state)) continue;
                    int color = this.getOreColor(state);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    poseStack.pushPose();
                    VertexConsumer bufferSource = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.LEASH);
                    poseStack.translate(-camX, -camY, -camZ);
                    RenderSystem.enableDepthTest();
                    this.drawCircle(poseStack, bufferSource, pos, r, g, b, 0.5f);
                    RenderSystem.disableDepthTest();
                    poseStack.popPose();
                }
            }
        }
    }

    private void drawCircle(PoseStack poseStack, VertexConsumer bufferSource, BlockPos pos, float r, float g, float b, float alpha) {
        float x = (float)pos.getX() + 0.5f;
        float y = (float)pos.getY() + 0.5f;
        float z = (float)pos.getZ() + 0.5f;
        float radius = 0.35f;
        Matrix4f matrix = poseStack.last().pose();
        Matrix3f matrix3f = poseStack.last().normal();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double x1 = this.x1[i][j];
                double y1 = this.y1[i][j];
                double z1 = this.z1[i][j];
                double x2 = this.x2[i][j];
                double y2 = this.y2[i][j];
                double z2 = this.z2[i][j];
                double x3 = this.x3[i][j];
                double y3 = this.y3[i][j];
                double z3 = this.z3[i][j];
                double x4 = this.x4[i][j];
                double y4 = this.y4[i][j];
                double z4 = this.z4[i][j];
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                bufferSource.addVertex(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).setColor(r, g, b, 1.0f);
                bufferSource.addVertex(matrix, (float)((double)x + x2 * (double)radius), (float)((double)y + y2 * (double)radius), (float)((double)z + z2 * (double)radius)).setColor(r, g, b, 1.0f);
                bufferSource.addVertex(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).setColor(r, g, b, 1.0f);
                bufferSource.addVertex(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).setColor(r, g, b, 1.0f);
                bufferSource.addVertex(matrix, (float)((double)x + x4 * (double)radius), (float)((double)y + y4 * (double)radius), (float)((double)z + z4 * (double)radius)).setColor(r, g, b, 1.0f);
                bufferSource.addVertex(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).setColor(r, g, b, 1.0f);
            }
        }
    }

    private void writeData() {
        int i;
        this.write = true;
        for (i = 0; i <= 4; ++i) {
            double lat = Math.PI * (-0.5 + (double)i / 4.0);
            this.sinLat[i] = Math.sin(lat);
            this.cosLat[i] = Math.cos(lat);
        }
        for (int j = 0; j <= 4; ++j) {
            double lng = Math.PI * 2 * (double)j / 4.0;
            this.sinLng[j] = Math.sin(lng);
            this.cosLng[j] = Math.cos(lng);
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.x1[i][j] = this.cosLng[j] * this.cosLat[i];
                this.y1[i][j] = this.sinLat[i];
                this.z1[i][j] = this.sinLng[j] * this.cosLat[i];
                this.x2[i][j] = this.cosLng[j] * this.cosLat[i + 1];
                this.y2[i][j] = this.sinLat[i + 1];
                this.z2[i][j] = this.sinLng[j] * this.cosLat[i + 1];
                this.x3[i][j] = this.cosLng[j + 1] * this.cosLat[i + 1];
                this.y3[i][j] = this.sinLat[i + 1];
                this.z3[i][j] = this.sinLng[j + 1] * this.cosLat[i + 1];
                this.x4[i][j] = this.cosLng[j + 1] * this.cosLat[i];
                this.y4[i][j] = this.sinLat[i];
                this.z4[i][j] = this.sinLng[j + 1] * this.cosLat[i];
            }
        }
    }

    private boolean isOre(BlockState state) {
        return state.getBlock() == Blocks.IRON_ORE || state.getBlock() instanceof BlocksRadiationOre || state.getBlock() instanceof BlockThoriumOre || state.getBlock() == Blocks.GOLD_ORE || state.getBlock() == Blocks.COAL_ORE || state.getBlock() == Blocks.REDSTONE_ORE || state.getBlock() == Blocks.NETHER_GOLD_ORE || state.getBlock() == Blocks.EMERALD_ORE || state.getBlock() == Blocks.NETHER_QUARTZ_ORE || state.getBlock() == Blocks.LAPIS_ORE || state.getBlock() instanceof BlockClassicOre || state.getBlock() instanceof BlockPreciousOre || state.getBlock() == Blocks.DIAMOND_ORE || state.getBlock() instanceof BlockHeavyOre || state.getBlock() instanceof BlockMineral || state.getBlock() instanceof BlockOre || state.getBlock() instanceof BlockOres2 || state.getBlock() instanceof BlockOres3 || state.getBlock() instanceof BlockApatite;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderTick(RenderGuiEvent.Post event) {
        ClientTickHandler.onTickRender1(event.getGuiGraphics());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerUpdate(PlayerTickEvent.Pre event) {
        ChunkPos chunkPos;
        LocalPlayer player;
        Level world;
        int tier;
        if (event.getEntity() instanceof LocalPlayer && (tier = this.getRadiationTier(world = (player = (LocalPlayer)event.getEntity()).level(), chunkPos = new ChunkPos(player.getOnPos()))) > 1) {
            this.showRadiationEffects(player, world, chunkPos, tier);
        }
    }
}

