/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.SteamImageInterface;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.PressureComponent;
import com.denfop.container.ContainerSteamSharpener;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.steam.TileSteamSharpener;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GuiSteamSharpener<T extends ContainerSteamSharpener>
extends GuiIU<ContainerSteamSharpener> {
    public final ContainerSteamSharpener container;

    public GuiSteamSharpener(ContainerSteamSharpener container1) {
        super(container1, EnumTypeStyle.STEAM);
        this.container = container1;
        this.addElement(new SteamImageInterface(this, 0, 0, this.imageWidth, this.imageHeight));
        this.addComponent(new GuiComponent(this, 10, 54, EnumTypeComponent.NULL, new Component<PressureComponent>(((TileSteamSharpener)this.container.base).pressure)));
        this.addComponent(new GuiComponent(this, 7, 64, EnumTypeComponent.STEAM_FLUID, new Component<ComponentSteamEnergy>(((TileSteamSharpener)this.container.base).steam)));
        this.addComponent(new GuiComponent(this, 85, 45, EnumTypeComponent.STEAM_PROCESS, new Component<1>(new ComponentProgress((TileEntityInventory)this.container.base, 1, 0){

            @Override
            public double getBar() {
                return ((TileSteamSharpener)GuiSteamSharpener.this.container.base).getProgress();
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("steam_machine.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 11; ++i) {
                compatibleUpgrades.add(Localization.translate("steam_machine.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        GuiSteamSharpener.bindTexture(this.getTexture());
        String name = Localization.translate(((TileSteamSharpener)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.imageWidth / 2 + 15, 5, name, 0x404040, false);
        GuiSteamSharpener.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }
}

