/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.api.windsystem.upgrade.RotorUpgradeSystem;
import com.denfop.container.ContainerWindGenerator;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.mechanism.wind.TileWindGenerator;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiWindGenerator<T extends ContainerWindGenerator>
extends GuiIU<ContainerWindGenerator> {
    private final ResourceLocation background;
    public boolean hoverChangeSide;
    public boolean hoverChangePower;

    public GuiWindGenerator(ContainerWindGenerator guiContainer) {
        super(guiContainer, ((TileWindGenerator)guiContainer.base).getStyle());
        this.imageHeight = 247;
        this.imageWidth = 207;
        this.background = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiwind_turbine.png");
        this.inventory.setY(159);
        this.inventory.setX(22);
    }

    public void init() {
        super.init();
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (((TileWindGenerator)((ContainerWindGenerator)this.container).base).getRotor() != null && this.hoverChangeSide) {
            new PacketUpdateServerTile((BlockEntity)((ContainerWindGenerator)this.container).base, 0.0);
        }
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d4, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        if (mouseX >= 35 && mouseX <= 171 && mouseY >= 118 && mouseY <= 124) {
            new PacketUpdateServerTile((BlockEntity)((ContainerWindGenerator)this.container).base, (double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).coefficient_power + d3);
            this.hoverChangePower = true;
        }
        return super.mouseScrolled(d, d2, d4, d3);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.wind_generator.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.wind_generator;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        poseStack.blit(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getDisplayName().getString();
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        pose.scale(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.imageWidth / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 3) / scale);
        poseStack.drawString(Minecraft.getInstance().font, name, textX, textY, 0x404040, false);
        pose.scale(1.0f / scale, 1.0f / scale, 1.0f);
        pose.popPose();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        GuiWindGenerator.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, (int)((double)(xoffset + 34) + (double)(((TileWindGenerator)((ContainerWindGenerator)this.container).base).coefficient_power - 100) / 50.0 * 130.0), yoffset + 116, 235, 0, 10, 12);
        if (this.hoverChangePower) {
            this.drawTexturedModalRect(poseStack, (int)((double)(xoffset + 34) + (double)(((TileWindGenerator)((ContainerWindGenerator)this.container).base).coefficient_power - 100) / 50.0 * 130.0), yoffset + 116, 246, 0, 10, 12);
        }
        this.hoverChangePower = false;
        if (!((TileWindGenerator)((ContainerWindGenerator)this.container).base).slot.isEmpty()) {
            List<ItemStack> list = RotorUpgradeSystem.instance.getListStack(((TileWindGenerator)((ContainerWindGenerator)this.container).base).slot.get(0));
            int i = 0;
            for (ItemStack stack : list) {
                if (stack.isEmpty()) {
                    ++i;
                    continue;
                }
                new ItemStackImage(this, 80 + i * 18, 134, () -> stack).drawBackground(poseStack, xoffset, yoffset);
                ++i;
            }
        }
        GuiWindGenerator.bindTexture(this.getTexture());
        ItemStack rotor = ((TileWindGenerator)((ContainerWindGenerator)this.container).base).slot.get(0);
        if ((double)rotor.getDamageValue() >= (double)rotor.getMaxDamage() * 0.25) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 46, this.guiTop + 137, 245, 34, 11, 11);
        }
        if (((TileWindGenerator)((ContainerWindGenerator)this.container).base).getRotor() != null) {
            double renderHeight;
            int windHeight = 74;
            double bar = renderHeight = (double)windHeight * ModUtils.limit(Math.min(24.4 + (double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).mind_speed, WindSystem.windSystem.getSpeedFromPower(((TileWindGenerator)((ContainerWindGenerator)this.container).base).getBlockPos(), (IWindMechanism)((Object)((ContainerWindGenerator)this.container).base), ((TileWindGenerator)((ContainerWindGenerator)this.container).base).generation / ((double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).coefficient_power / 100.0)) * ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getCoefficient()) / 24.4, 0.0, 1.0);
            this.drawTexturedModalRect(poseStack, this.guiLeft + 11, (int)((double)(this.guiTop + 15 + windHeight) - bar), 236, (int)(120.0 - bar), 9, (int)bar);
            windHeight = 74;
            bar = renderHeight = (double)windHeight * ((TileWindGenerator)((ContainerWindGenerator)this.container).base).energy.getFillRatio();
            this.drawTexturedModalRect(poseStack, this.guiLeft + 186, (int)((double)(this.guiTop + 15 + windHeight) - bar), 247, (int)(120.0 - bar), 9, (int)bar);
            if (this.hoverChangeSide) {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 157, this.guiTop + 133, 236, 13, 20, 20);
            }
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int mouseX, int mouseY) {
        Object fields;
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
        this.hoverChangeSide = false;
        if (mouseX >= 157 && mouseY >= 133 && mouseX <= 176 && mouseY <= 152) {
            this.hoverChangeSide = true;
        }
        if (((TileWindGenerator)((ContainerWindGenerator)this.container).base).getWorld().dimension() == Level.OVERWORLD) {
            fields = "";
            fields = ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getMinWind() != 0 ? (String)fields + Localization.translate("iu.wind_meter.info") + String.format("%.1f", Math.min(24.7 + (double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).mind_speed, WindSystem.windSystem.getSpeedFromPower(((TileWindGenerator)((ContainerWindGenerator)this.container).base).getBlockPos(), (IWindMechanism)((Object)((ContainerWindGenerator)this.container).base), ((TileWindGenerator)((ContainerWindGenerator)this.container).base).generation / ((double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).coefficient_power / 100.0)) / ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getCoefficient())) + " m/s" : (String)fields + Localization.translate("iu.wind_meter.info") + String.format("%.1f", ((TileWindGenerator)((ContainerWindGenerator)this.container).base).wind_speed + (double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).mind_speed) + " m/s";
            PoseStack pose = poseStack.pose();
            pose.pushPose();
            pose.translate((float)(175 - this.getStringWidth((String)fields)), 100.0f, 0.0f);
            pose.scale(0.85f, 0.85f, 1.0f);
            this.draw(poseStack, (String)fields, 0, 0, ModUtils.convertRGBcolorToInt(13, 229, 34));
            pose.popPose();
        }
        if (!((TileWindGenerator)((ContainerWindGenerator)this.container).base).slot.isEmpty()) {
            List<ItemStack> list = RotorUpgradeSystem.instance.getListStack(((TileWindGenerator)((ContainerWindGenerator)this.container).base).slot.get(0));
            int i = 0;
            for (ItemStack stack : list) {
                if (stack.isEmpty()) {
                    ++i;
                    continue;
                }
                ((Area)new AdvArea(this, 80 + i * 18, 134, 80 + i * 18 + 18, 152).withTooltip(stack.getDisplayName().getString())).drawForeground(poseStack, mouseX, mouseY);
                ++i;
            }
        }
        if (((TileWindGenerator)((ContainerWindGenerator)this.container).base).getRotor() != null) {
            fields = Localization.translate("iu.wind_side") + Localization.translate("iu.wind." + ((TileWindGenerator)((ContainerWindGenerator)this.container).base).wind_side.name().toLowerCase());
            if (((TileWindGenerator)((ContainerWindGenerator)this.container).base).getRotorSide() != null) {
                fields = (String)fields + "\n" + Localization.translate("iu.wind_mec_side") + Localization.translate("iu.wind." + ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getRotorSide().name().toLowerCase());
            }
            fields = (String)fields + "\n" + Localization.translate("iu.wind_gen") + ModUtils.getString(((TileWindGenerator)((ContainerWindGenerator)this.container).base).generation) + " EF/t";
            fields = (String)fields + "\n" + Localization.translate("iu.wind_coef") + String.format("%.2f", ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getCoefficient());
            fields = (String)fields + "\n" + Localization.translate("iu.wind_tier") + String.format("%d", ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getRotor().getLevel());
            if (((TileWindGenerator)((ContainerWindGenerator)this.container).base).enumTypeWind != null) {
                int meta = Math.min(((TileWindGenerator)((ContainerWindGenerator)this.container).base).enumTypeWind.ordinal() + ((TileWindGenerator)((ContainerWindGenerator)this.container).base).getMinWind(), 9);
                WindSystem.windSystem.getEnumTypeWind();
                EnumTypeWind enumTypeWinds = EnumTypeWind.values()[meta];
                fields = (String)fields + "\n" + Localization.translate("iu.wind_level_info") + String.format("%d", enumTypeWinds.ordinal() + 1);
                double hours = 0.0;
                double minutes = 0.0;
                double seconds = 0.0;
                List<Double> time = ModUtils.Time((double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).timers / 20.0);
                if (!time.isEmpty()) {
                    hours = time.get(0);
                    minutes = time.get(1);
                    seconds = time.get(2);
                }
                String time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
                String time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
                String time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
                fields = (String)fields + "\n" + Localization.translate("iu.wind_change_time") + time1 + time2 + time3;
                String tooltip3 = Localization.translate("iu.wind_meter.info") + String.format("%.1f", enumTypeWinds.getMin() + (double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).getMinWindSpeed()) + "-" + String.format("%.1f", enumTypeWinds.getMax() + (double)((TileWindGenerator)((ContainerWindGenerator)this.container).base).getMinWindSpeed()) + " m/s";
                ((Area)new AdvArea(this, 9, 12, 23, 91).withTooltip(tooltip3)).drawForeground(poseStack, mouseX, mouseY);
            }
            ((Area)new AdvArea(this, 35, 117, 172, 125).withTooltip(((TileWindGenerator)((ContainerWindGenerator)this.container).base).coefficient_power + "%")).drawForeground(poseStack, mouseX, mouseY);
            ((Area)new AdvArea(this, 183, 12, 197, 91).withTooltip(ModUtils.getString(Math.min(((TileWindGenerator)((ContainerWindGenerator)this.container).base).energy.getEnergy(), ((TileWindGenerator)((ContainerWindGenerator)this.container).base).energy.getCapacity())) + "/" + ModUtils.getString(((TileWindGenerator)((ContainerWindGenerator)this.container).base).energy.getCapacity()) + " EF\n" + Localization.translate("EUStorage.gui.info.output", ModUtils.getString(EnergyNetGlobal.instance.getPowerFromTier(((TileWindGenerator)((ContainerWindGenerator)this.container).base).energy.getSourceTier()))))).drawForeground(poseStack, mouseX, mouseY);
            ItemStack rotor = ((TileWindGenerator)((ContainerWindGenerator)this.container).base).slot.get(0);
            if ((double)rotor.getDamageValue() >= (double)rotor.getMaxDamage() * 0.25) {
                ((Area)new Area(this, 46, 137, 11, 11).withTooltip(Localization.translate("iu.wind.repair"))).drawForeground(poseStack, mouseX, mouseY);
            }
            float scale = 1.0f;
            List<String> lines = this.wrapTextWithNewlines((String)fields, 255);
            int y = 0;
            for (String line : lines) {
                PoseStack poseStack1 = poseStack.pose();
                poseStack1.pushPose();
                poseStack1.translate(32.0f, (float)(20 + y), 0.0f);
                poseStack1.scale(0.7f, 0.7f, 1.0f);
                this.draw(poseStack, line, 0, 0, ModUtils.convertRGBcolorToInt(13, 229, 34));
                poseStack1.popPose();
                y += 10;
            }
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.background;
    }
}

