/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.anvil;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class AnvilHandler {
    private static final List<AnvilHandler> recipes = new ArrayList<AnvilHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public AnvilHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.container = container;
    }

    public static List<AnvilHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AnvilHandler.initRecipes();
        }
        return recipes;
    }

    public static AnvilHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        AnvilHandler recipe = new AnvilHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("anvil")) {
            try {
                AnvilHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
            }
            catch (Exception e) {
                System.out.println(2);
            }
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

