/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gasgenerator;

import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.blocks.mechanism.BlockRefiner;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.gasgenerator.GasGeneratorHandler;
import com.denfop.tiles.mechanism.TileOilRefiner;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class GasGeneratorCategory
extends GuiIU
implements IRecipeCategory<GasGeneratorHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public GasGeneratorCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileOilRefiner)BlockRefiner.refiner.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)("textures/gui/NeutronGeneratorGUI".toLowerCase() + ".png")), 5, 5, 140, 75);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3.gas_generator).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(GasGeneratorHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.drawSplitString(stack, Localization.translate("iu.windgenerator1"), 10, 30, 130, 0x404040);
        this.drawSplitString(stack, ModUtils.getString(recipe.getEnergy()), 10, 37, 130, 0x404040);
    }

    public RecipeType<GasGeneratorHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GasGeneratorHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 95, 21).setFluidRenderer(10000L, true, 12, 47).addFluidStack(recipe.getOutput().getFluid(), (long)recipe.getOutput().getAmount());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/NeutronGeneratorGUI.png".toLowerCase());
    }
}

