/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gassensor;

import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.material.Fluid;

public class GasSensorHandler {
    private static final List<GasSensorHandler> recipes = new ArrayList<GasSensorHandler>();
    public final Fluid input;
    public final String output;

    public GasSensorHandler(Fluid input, String output) {
        this.input = input;
        this.output = output;
    }

    public static List<GasSensorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GasSensorHandler.initRecipes();
        }
        return recipes;
    }

    public static GasSensorHandler addRecipe(Fluid input, String output) {
        GasSensorHandler recipe = new GasSensorHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        GasSensorHandler.addRecipe((Fluid)FluidName.fluidgas.getInstance().get(), Localization.translate("iu.gas_find.info"));
        GasSensorHandler.addRecipe((Fluid)FluidName.fluidiodine.getInstance().get(), Localization.translate("iu.iodine_find.info"));
        GasSensorHandler.addRecipe((Fluid)FluidName.fluidfluor.getInstance().get(), Localization.translate("iu.iodine_find.info"));
        GasSensorHandler.addRecipe((Fluid)FluidName.fluidbromine.getInstance().get(), Localization.translate("iu.bromine_find.info"));
        GasSensorHandler.addRecipe((Fluid)FluidName.fluidchlorum.getInstance().get(), Localization.translate("iu.chlorine_find.info"));
    }
}

