/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gearing;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class GearingHandler {
    private static final List<GearingHandler> recipes = new ArrayList<GearingHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public GearingHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<GearingHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GearingHandler.initRecipes();
        }
        return recipes;
    }

    public static GearingHandler addRecipe(ItemStack input, ItemStack output) {
        GearingHandler recipe = new GearingHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static GearingHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (GearingHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("gearing")) {
            GearingHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return is.getItem() == this.input.getItem();
    }
}

