/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.impalloysmelter;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ImpAlloySmelterHandler {
    public static final List<ImpAlloySmelterHandler> recipes = new ArrayList<ImpAlloySmelterHandler>();
    public final ItemStack input;
    public final ItemStack input1;
    public final ItemStack input2;
    public final ItemStack input3;
    public final ItemStack output;
    public final short temperature;
    private final BaseMachineRecipe container;

    public ImpAlloySmelterHandler(ItemStack input, ItemStack input1, ItemStack input2, ItemStack input3, ItemStack output, short temperature, BaseMachineRecipe container) {
        this.input = input;
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.output = output;
        this.temperature = temperature;
        this.container = container;
    }

    public static List<ImpAlloySmelterHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ImpAlloySmelterHandler.initRecipes();
        }
        return recipes;
    }

    public static ImpAlloySmelterHandler addRecipe(ItemStack input, ItemStack input1, ItemStack input2, ItemStack input3, ItemStack output, short temperature, BaseMachineRecipe container) {
        ImpAlloySmelterHandler recipe = new ImpAlloySmelterHandler(input, input1, input2, input3, output, temperature, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ImpAlloySmelterHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (ImpAlloySmelterHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("impalloysmelter")) {
            ImpAlloySmelterHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.input.getInputs().get(2).getInputs().get(0), container.input.getInputs().get(3).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.getShort("temperature"), container);
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public List<ItemStack> getInputs() {
        return Arrays.asList(this.input, this.input1, this.input3);
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getInput2() {
        return this.input2;
    }

    public ItemStack getInput3() {
        return this.input3;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

