/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.plasticcratorplate;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class PlasticCreatorPlateHandler {
    private static final List<PlasticCreatorPlateHandler> recipes = new ArrayList<PlasticCreatorPlateHandler>();
    private final FluidStack input2;
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public PlasticCreatorPlateHandler(ItemStack input, FluidStack input2, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.input2 = input2;
        this.output = output;
        this.container = container;
    }

    public static List<PlasticCreatorPlateHandler> getRecipes() {
        if (recipes.isEmpty()) {
            PlasticCreatorPlateHandler.initRecipes();
        }
        return recipes;
    }

    public static PlasticCreatorPlateHandler addRecipe(ItemStack input, FluidStack input2, ItemStack output, BaseMachineRecipe container) {
        PlasticCreatorPlateHandler recipe = new PlasticCreatorPlateHandler(input, input2, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static PlasticCreatorPlateHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (PlasticCreatorPlateHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("plasticplate")) {
            PlasticCreatorPlateHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getFluid(), container.getOutput().items.get(0), container);
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getInput2() {
        return this.input2;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

