/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.recycler;

import com.denfop.IUItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RecyclerHandler {
    private static final List<RecyclerHandler> recipes = new ArrayList<RecyclerHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public RecyclerHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<RecyclerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RecyclerHandler.initRecipes();
        }
        return recipes;
    }

    public static RecyclerHandler addRecipe(ItemStack input, ItemStack output) {
        if (input.isEmpty() || input == ItemStack.EMPTY) {
            return null;
        }
        RecyclerHandler recipe = new RecyclerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static RecyclerHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (RecyclerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (Item container : BuiltInRegistries.ITEM) {
            RecyclerHandler.addRecipe(new ItemStack((ItemLike)container), IUItem.scrap);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return is.getItem() == this.input.getItem();
    }
}

