/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.spacebody;

import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.spacebody.SpaceBodyHandler;
import com.denfop.tiles.mechanism.TileEntitySolidMixer;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SpaceBodyCategory
extends GuiIU
implements IRecipeCategory<SpaceBodyHandler> {
    private final IDrawableStatic bg;
    JeiInform jeiInform;

    public SpaceBodyCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntitySolidMixer)BlockBaseMachine3.solid_mixer.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/common3.png"), 3, 3, 140, 170);
    }

    public RecipeType<SpaceBodyHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate("spacebody_jei");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(SpaceBodyHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.drawSplitString(stack, Localization.translate("iu.space_recipe.jei") + Localization.translate("iu.body." + recipe.body.getName().toLowerCase()), 5, 3, 145, 0x404040);
        this.drawSplitString(stack, Localization.translate("iu.space_recipe.jei1"), 5, 20, 145, 0x404040);
        this.drawSplitString(stack, Localization.translate("iu.start_space.info"), 5, 110, 145, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpaceBodyHandler recipe, IFocusGroup focuses) {
        int amount = recipe.getInput().size() + recipe.getOutput().size();
        for (int i = 0; i < amount; ++i) {
            int x = 5 + i % 6 * 20;
            int y = 65 + i / 6 * 19;
            if (i < recipe.getInput().size()) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(recipe.getInput().get(i));
                continue;
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setFluidRenderer((long)recipe.getOutput().get(i - recipe.getInput().size()).getAmount(), true, 16, 16).addFluidStack(recipe.getOutput().get(i - recipe.getInput().size()).getFluid(), (long)recipe.getOutput().get(i - recipe.getInput().size()).getAmount());
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guivein.png");
    }
}

