/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.upgradeblock;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class UpgradeBlockHandler {
    private static final List<UpgradeBlockHandler> recipes = new ArrayList<UpgradeBlockHandler>();
    public final CompoundTag metadata;
    private final ItemStack input;
    private final ItemStack input1;
    private final ItemStack output;

    public UpgradeBlockHandler(ItemStack input, ItemStack input1, ItemStack output, CompoundTag metadata) {
        this.input = input;
        this.input1 = input1;
        this.output = output;
        this.metadata = metadata;
    }

    public static List<UpgradeBlockHandler> getRecipes() {
        if (recipes.isEmpty()) {
            UpgradeBlockHandler.initRecipes();
        }
        return recipes;
    }

    public static UpgradeBlockHandler addRecipe(ItemStack input, ItemStack input1, ItemStack output, CompoundTag metadata) {
        UpgradeBlockHandler recipe = new UpgradeBlockHandler(input, input1, output, metadata);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static UpgradeBlockHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (UpgradeBlockHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("upgradeblock")) {
            UpgradeBlockHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.getOutput().items.get(0), container.output.metadata);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

