/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.mechanism.BlockCable;
import com.denfop.invslot.CableItem;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.mechanism.energy.TileEnergySubstitute;
import com.denfop.tiles.transport.tiles.TileEntityCable;
import com.denfop.tiles.transport.types.CableType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class InvSlotSubstitute
extends InvSlot {
    private final TileEnergySubstitute tile;

    public InvSlotSubstitute(TileEnergySubstitute tileEntityEnergySubstitute) {
        super(tileEntityEnergySubstitute, InvSlot.TypeItemSlot.INPUT, 16);
        this.tile = tileEntityEnergySubstitute;
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    @Override
    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    @Override
    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    @Override
    public boolean add(List<ItemStack> stacks, boolean simulate) {
        return super.add(stacks, simulate);
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        if (!(stack.getItem() instanceof ItemBlockTileEntity)) {
            return false;
        }
        return IUItem.cable.contains(stack);
    }

    @Override
    public void onChanged() {
        super.onChanged();
        try {
            if (!this.tile.getWorld().isClientSide) {
                this.tile.getCableItemList().clear();
                this.tile.max_value = 0;
                ArrayList<CableItem> cableItemList = new ArrayList<CableItem>();
                for (ItemStack stack : this) {
                    if (stack.isEmpty()) continue;
                    ItemBlockTileEntity<BlockCable> cable1 = IUItem.cable.getItem(stack);
                    boolean need = false;
                    for (CableItem cableItem2 : cableItemList) {
                        if (!cableItem2.equals(new CableItem(((CableType)((TileEntityCable)((BlockCable)cable1.getElement()).getDummyTe()).cableItem).capacity, stack.getCount(), stack))) continue;
                        cableItem2.addCount(stack.getCount());
                        need = true;
                        break;
                    }
                    if (need) continue;
                    cableItemList.add(new CableItem(((CableType)((TileEntityCable)((BlockCable)cable1.getElement()).getDummyTe()).cableItem).capacity, stack.getCount(), stack));
                }
                this.tile.setCableItemList(cableItemList);
                cableItemList.forEach(cableItem -> this.tile.setMaxValue(this.tile.max_value, cableItem.getProvider(), (CableItem)cableItem));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

