/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.ItemFluidContainer;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class ItemSprayer
extends ItemFluidContainer
implements IItemTab {
    public ItemSprayer() {
        super(8000, 1);
    }

    private static boolean canPlaceFoam(Level world, BlockPos pos, Target target) {
        if (target == Target.Any) {
            return world.getBlockState(pos).canBeReplaced();
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, level, list, tooltipFlag);
        list.add((Component)Component.literal((String)Localization.translate("iu.sprayer.info")));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide && IUCore.keyboard.isChangeKeyDown(player)) {
            ItemStack stack = player.getItemInHand(hand);
            int mode = (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0);
            mode = mode == 0 ? 1 : 0;
            stack.set(DataComponentsInit.MODE, (Object)mode);
            String sMode = mode == 0 ? "iu.tooltip.mode.normal" : "iu.tooltip.mode.single";
            player.displayClientMessage((Component)Component.translatable((String)"iu.tooltip.mode", (Object[])new Object[]{sMode}), true);
        }
        return super.use(world, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Target target;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int maxFoamBlocks = 0;
        IFluidHandlerItem fs = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM, null);
        FluidStack fluid = fs.getFluidInTank(0);
        if (!fluid.isEmpty() && fluid.getAmount() > 0) {
            maxFoamBlocks += fluid.getAmount() / this.getFluidPerFoam();
        }
        if (maxFoamBlocks == 0) {
            return InteractionResult.FAIL;
        }
        maxFoamBlocks = Math.min(maxFoamBlocks, this.getMaxFoamBlocks(stack));
        Target target2 = target = ItemSprayer.canPlaceFoam(world, pos, Target.Scaffold) ? Target.Scaffold : Target.Any;
        if (target == Target.Any) {
            pos = pos.relative(side);
        }
        Vec3 viewVec = player.getLookAngle();
        Direction playerViewFacing = Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z);
        int amount = this.sprayFoam(world, pos, playerViewFacing.getOpposite(), target, maxFoamBlocks);
        if ((amount *= this.getFluidPerFoam()) > 0) {
            fs.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            player.getInventory().setItem(player.getInventory().selected, fs.getContainer());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int sprayFoam(Level world, BlockPos pos, Direction excludedDir, Target target, int maxFoamBlocks) {
        BlockPos cPos;
        if (!ItemSprayer.canPlaceFoam(world, pos, target)) {
            return 0;
        }
        ArrayDeque<BlockPos> toCheck = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        toCheck.add(pos);
        while ((cPos = (BlockPos)toCheck.poll()) != null && positions.size() < maxFoamBlocks) {
            if (!ItemSprayer.canPlaceFoam(world, cPos, target) || !positions.add(cPos)) continue;
            for (Direction dir : Direction.values()) {
                if (dir == excludedDir) continue;
                toCheck.add(cPos.relative(dir));
            }
        }
        int failedPlacements = 0;
        for (BlockPos targetPos : positions) {
            if (world.setBlock(targetPos, IUItem.foam.getDefaultState(), 3)) continue;
            ++failedPlacements;
        }
        return positions.size() - failedPlacements;
    }

    protected int getMaxFoamBlocks(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0) == 0 ? 10 : 1;
    }

    protected int getFluidPerFoam() {
        return 100;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return fluid == FluidName.fluidconstruction_foam.getInstance().get();
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this));
            p_41392_.add((Object)this.getItemStack((Fluid)FluidName.fluidconstruction_foam.getInstance().get()));
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    private static enum Target {
        Any,
        Scaffold;

    }
}

