/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.api.tile.IWrenchable;
import com.denfop.audio.EnumSound;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class ItemToolWrench
extends Item
implements IItemTab {
    String nameItem;

    public ItemToolWrench() {
        super(new Item.Properties().durability(120).setNoRepair());
    }

    public static WrenchResult wrenchBlock(Level level, BlockPos pos, Direction side, Player player, boolean remove) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!block.defaultBlockState().isAir() && block instanceof IWrenchable) {
            Direction currentFacing;
            IWrenchable wrenchable = (IWrenchable)block;
            Direction newFacing = currentFacing = wrenchable.getFacing(level, pos);
            if (!IUCore.keyboard.isChangeKeyDown(player)) {
                newFacing = player.isShiftKeyDown() ? side.getOpposite() : side;
            } else {
                Direction.Axis axis = side.getAxis();
                if (side.getAxisDirection() == Direction.AxisDirection.POSITIVE && !player.isShiftKeyDown() || side.getAxisDirection() == Direction.AxisDirection.NEGATIVE && player.isShiftKeyDown()) {
                    newFacing = currentFacing.getClockWise(axis);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        newFacing = newFacing.getClockWise(axis);
                    }
                }
            }
            if (newFacing != currentFacing && wrenchable.setFacing(level, pos, newFacing, player)) {
                return WrenchResult.Rotated;
            }
            if (remove && wrenchable.wrenchCanRemove(level, pos, player)) {
                if (!level.isClientSide) {
                    BlockEntity te = level.getBlockEntity(pos);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        BlockEvent.BreakEvent experience = CommonHooks.fireBlockBreak((Level)level, (GameType)serverPlayer.gameMode.getGameModeForPlayer(), (ServerPlayer)serverPlayer, (BlockPos)pos, (BlockState)state);
                        if (experience.isCanceled()) {
                            return WrenchResult.Nothing;
                        }
                    }
                    block.playerWillDestroy(level, pos, state, player);
                    if (!block.onDestroyedByPlayer(state, level, pos, player, true, level.getFluidState(pos))) {
                        return WrenchResult.Nothing;
                    }
                    block.destroy((LevelAccessor)level, pos, state);
                    List<ItemStack> drops = wrenchable.getWrenchDrops(level, pos, state, te, player, RandomSource.create().nextInt(100));
                    if (drops != null && !drops.isEmpty()) {
                        for (ItemStack drop : drops) {
                            ModUtils.dropAsEntity(level, pos, drop);
                        }
                    }
                    wrenchable.wrenchBreak(level, pos);
                }
                return WrenchResult.Removed;
            }
        }
        return WrenchResult.Nothing;
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        InteractionHand hand = context.getHand();
        if (!this.canTakeDamage(stack, 1)) {
            return InteractionResult.FAIL;
        }
        WrenchResult result = ItemToolWrench.wrenchBlock(level, pos, side, player, this.canTakeDamage(stack, 10));
        if (result != WrenchResult.Nothing) {
            if (!level.isClientSide) {
                this.damage(stack, result == WrenchResult.Rotated ? 1 : 10, player);
            } else {
                player.playSound(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
            }
            return level.isClientSide ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        InteractionHand hand = context.getHand();
        ItemStack stack = ModUtils.get(player, hand);
        if (!this.canTakeDamage(stack, 1)) {
            return InteractionResult.FAIL;
        }
        WrenchResult result = ItemToolWrench.wrenchBlock(level, pos, side, player, this.canTakeDamage(stack, 10));
        if (result != WrenchResult.Nothing) {
            if (!level.isClientSide) {
                this.damage(stack, result == WrenchResult.Rotated ? 1 : 10, player);
            } else {
                player.playSound(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
            }
            return level.isClientSide ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean canTakeDamage(ItemStack stack, int amount) {
        return true;
    }

    public void damage(ItemStack stack, int amount, Player player) {
        stack.hurtAndBreak(amount, (LivingEntity)player, EquipmentSlot.MAINHAND);
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    private static enum WrenchResult {
        Rotated,
        Removed,
        Nothing;

    }
}

