/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.upgradekit;

import com.denfop.IUCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.UpgradeKit;
import com.denfop.items.ItemMain;
import com.denfop.tiles.base.TileEntityBlock;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;

public class ItemUpgradeMachinesKit<T extends Enum<T>>
extends ItemMain<T> {
    public static int tick = 0;
    public static int[] inform = new int[5];

    public ItemUpgradeMachinesKit(T element) {
        super(new Item.Properties(), element);
    }

    public void inventoryTick(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.UpgradeTab;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        if (world.isClientSide || player == null) {
            return InteractionResult.PASS;
        }
        if (stack.has(DataComponentsInit.UPGRADE_KIT)) {
            TileEntityBlock tileEntityBlock;
            ItemStack input = ((UpgradeKit)stack.get(DataComponentsInit.UPGRADE_KIT)).input();
            ItemStack output = ((UpgradeKit)stack.get(DataComponentsInit.UPGRADE_KIT)).output();
            BlockEntity tileEntity = world.getBlockEntity(pos);
            if (tileEntity instanceof TileEntityBlock && (tileEntityBlock = (TileEntityBlock)tileEntity).getPickBlock(player, null).is(input.getItem())) {
                Block outputBlock = ((ItemBlockTileEntity)output.getItem()).getBlock();
                BlockState state = world.getBlockState(pos);
                Block block = state.getBlock();
                block.playerWillDestroy(world, pos, state, player);
                world.removeBlock(pos, false);
                block.destroy((LevelAccessor)world, pos, state);
                List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(Vec3.atCenterOf((Vec3i)pos.offset(-1, -1, -1)), Vec3.atCenterOf((Vec3i)pos.offset(1, 1, 1))));
                for (ItemEntity item : items) {
                    item.discard();
                }
                BlockState newState = outputBlock.defaultBlockState();
                world.setBlock(pos, newState, 3);
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        boolean hooks = CommonHooks.onRightClickBlock((Player)player, (InteractionHand)hand, (BlockPos)pos, (BlockHitResult)new BlockHitResult(new Vec3(context.getClickLocation().x, context.getClickLocation().y, context.getClickLocation().z), context.getClickedFace(), pos, false)).isCanceled();
        if (hooks) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"waring_kit"));
        if (stack.has(DataComponentsInit.UPGRADE_KIT)) {
            ItemStack inputStack = ((UpgradeKit)stack.get(DataComponentsInit.UPGRADE_KIT)).input();
            tooltip.add((Component)Component.translatable((String)"using_kit").append(inputStack.getHoverName()));
        }
        super.appendHoverText(stack, world, tooltip, flag);
    }

    public static enum Types implements ISubEnum
    {
        upgradepanelkitmachine(0),
        upgradepanelkitmachine1(1),
        upgradepanelkitmachine2(2),
        upgradepanelkitmachine3(3),
        upgradekitmachine4(3);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "upgradekitmachine";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

