/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.items.relocator.Point;
import com.denfop.items.relocator.RelocatorNetwork;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PacketRelocatorTeleportPlayer
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketRelocatorTeleportPlayer() {
    }

    public PacketRelocatorTeleportPlayer(Player player, Point point) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(64, player.registryAccess());
        buffer.writeByte(this.getId());
        buffer.writeUUID(player.getUUID());
        point.writeToBuffer(buffer);
        this.buffer = buffer;
        IUCore.network.getClient().sendPacket((IPacket)this, buffer);
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 52;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        UUID uuid = customPacketBuffer.readUUID();
        if (entityPlayer.getUUID().equals(uuid)) {
            Point point = new Point(customPacketBuffer);
            ItemStack stack = entityPlayer.getMainHandItem();
            if (ElectricItem.manager.canUse(stack, 1000000.0)) {
                ElectricItem.manager.discharge(stack, 1000000.0, 14, true, false, false);
                entityPlayer.closeContainer();
                RelocatorNetwork.instance.teleportPlayer(entityPlayer, point);
            }
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

