/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.pressure;

import com.denfop.api.pressure.event.PressureTileLoadEvent;
import com.denfop.api.pressure.event.PressureTileUnloadEvent;
import com.denfop.pressure.PressureNetGlobal;
import com.denfop.pressure.PressureNetLocal;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class EventHandler {
    public EventHandler() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(PressureTileLoadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        PressureNetLocal local = PressureNetGlobal.getForWorld((Level)event.getLevel());
        if (local != null) {
            local.addTileEntity(event.tile.getPos(), event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileUnload(PressureTileUnloadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        PressureNetLocal local = PressureNetGlobal.getForWorld((Level)event.getLevel());
        if (local != null) {
            local.removeTile(event.tile);
        }
    }

    @SubscribeEvent
    public void tick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        PressureNetGlobal.onTickEnd(event.getLevel());
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        PressureNetGlobal.onWorldUnload((Level)event.getLevel());
    }
}

