/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.datagen.itemtag.ItemTagProvider;
import com.denfop.recipe.IInputItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InputOreDict
implements IInputItemStack {
    public final Integer meta;
    private final TagKey<Item> tag;
    private final List<ItemStack> ores;
    public int amount;

    public InputOreDict(String input) {
        this(input.toLowerCase(), 1);
    }

    public InputOreDict(String input, int amount) {
        this(input.toLowerCase(), amount, 0);
    }

    public InputOreDict(String input, int amount, Integer meta) {
        ResourceLocation input1 = ResourceLocation.parse((String)input.toLowerCase());
        this.amount = amount;
        this.meta = meta;
        this.tag = ItemTags.create((ResourceLocation)input1);
        this.ores = new ArrayList<ItemStack>();
        Iterable holder = BuiltInRegistries.ITEM.getTagOrEmpty(this.tag);
        holder.forEach(itemHolder -> this.ores.add(new ItemStack(itemHolder)));
        if (this.ores.isEmpty() && ItemTagProvider.mapItems.containsKey(this.tag.location())) {
            ItemTagProvider.mapItems.get(this.tag.location()).forEach(items -> this.ores.add(items.copy()));
        }
        for (ItemStack stack : this.ores) {
            stack.setCount(this.getAmount());
        }
    }

    public InputOreDict(TagKey<Item> tag, int amount) {
        this.amount = amount;
        this.meta = 0;
        this.tag = tag;
        this.ores = new ArrayList<ItemStack>();
        BuiltInRegistries.ITEM.getTagOrEmpty(this.tag).forEach(itemHolder -> this.ores.add(new ItemStack(itemHolder)));
        if (this.ores.isEmpty() && ItemTagProvider.mapItems.containsKey(tag.location())) {
            ItemTagProvider.mapItems.get(tag.location()).forEach(items -> this.ores.add(items.copy()));
        }
        for (ItemStack stack : this.ores) {
            stack.setCount(this.getAmount());
        }
    }

    public InputOreDict(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.amount = tagCompound.getInt("Amount");
        this.meta = tagCompound.contains("Meta") ? tagCompound.getInt("Meta") : 0;
        this.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tagCompound.getString("ItemTag")));
        this.ores = new ArrayList<ItemStack>();
        ListTag list = tagCompound.getList("Ores", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.ores.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)list.getCompound(i)));
        }
    }

    public InputOreDict(int amount, TagKey<Item> tag) {
        this.amount = amount;
        this.meta = 0;
        this.tag = tag;
        this.ores = new ArrayList<ItemStack>();
        BuiltInRegistries.ITEM.getTagOrEmpty(this.tag).forEach(itemHolder -> this.ores.add(new ItemStack(itemHolder)));
        if (this.ores.isEmpty() && ItemTagProvider.mapItems.containsKey(tag.location())) {
            ItemTagProvider.mapItems.get(tag.location()).forEach(items -> this.ores.add(items.copy()));
        }
        for (ItemStack stack : this.ores) {
            stack.setCount(this.getAmount());
        }
    }

    public InputOreDict(FriendlyByteBuf buffer) {
        this(buffer.readInt(), (TagKey<Item>)new TagKey(Registries.ITEM, buffer.readResourceLocation()));
    }

    public static ItemStack setSize(ItemStack stack, int col) {
        stack = stack.copy();
        stack.setCount(col);
        return stack;
    }

    @Override
    public void growAmount(int col) {
        this.amount += col;
        for (ItemStack stack : this.getOres()) {
            stack.setCount(this.getAmount());
        }
    }

    @Override
    public CompoundTag writeNBT(HolderLookup.Provider provider) {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putByte("id", (byte)1);
        tagCompound.putInt("Amount", this.amount);
        if (this.meta != null) {
            tagCompound.putInt("Meta", this.meta.intValue());
        }
        if (this.tag != null) {
            tagCompound.putString("ItemTag", this.tag.location().toString());
        }
        ListTag list = new ListTag();
        for (ItemStack stack : this.ores) {
            list.add((Object)stack.save(provider, (Tag)new CompoundTag()));
        }
        tagCompound.put("Ores", (Tag)list);
        return tagCompound;
    }

    @Override
    public boolean matches(ItemStack subject) {
        List<ItemStack> inputs = this.getOres();
        boolean useOreStackMeta = this.meta == null;
        Item subjectItem = subject.getItem();
        int subjectMeta = 0;
        return inputs.stream().anyMatch(oreStack -> {
            Item oreItem = oreStack.getItem();
            int metaRequired = useOreStackMeta ? 0 : this.meta;
            return subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE);
        });
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<ItemStack> getInputs() {
        List<ItemStack> ores = this.getOres();
        boolean allSuitableEntries = ores.stream().allMatch(stack -> stack.getCount() == this.getAmount());
        if (allSuitableEntries) {
            return ores;
        }
        return ores.stream().filter(stack -> stack.getItem() != ItemStack.EMPTY.getItem()).map(stack -> stack.getCount() == this.getAmount() ? stack : InputOreDict.setSize(stack, this.getAmount())).toList();
    }

    @Override
    public boolean hasTag() {
        return true;
    }

    @Override
    public TagKey<Item> getTag() {
        return this.tag;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            InputOreDict other = (InputOreDict)obj;
            if (this.tag.equals(other.tag) && other.amount == this.amount) {
                return Objects.equals(this.meta, other.meta);
            }
        }
        return false;
    }

    private List<ItemStack> getOres() {
        return this.ores;
    }
}

