/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class RenderFluidBlock {
    private static final Map<Integer, Map<BlockPos, TickLerp>> lerpMap = new WeakHashMap<Integer, Map<BlockPos, TickLerp>>();

    private static float getCurrentLerpHeight(TickLerp lerp, long currentTick) {
        float progress = (float)(currentTick - lerp.startTick) / 20.0f;
        if (progress >= 1.0f) {
            return lerp.targetAmount;
        }
        return lerp.startAmount + (lerp.targetAmount - lerp.startAmount) * progress;
    }

    public static void renderFluid(FluidStack fluidStack, MultiBufferSource bufferSource, Level level, BlockPos pos, PoseStack poseStack, float scale, float scale1) {
        RenderFluidBlock.renderFluid(fluidStack, bufferSource, level, pos, poseStack, scale, scale1, 0);
    }

    public static void renderFluid(FluidStack fluidStack, MultiBufferSource bufferSource, Level level, BlockPos pos, PoseStack poseStack, float scale, float scale1, int tank) {
        if (fluidStack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getFlowingTexture(fluidStack);
        if (stillTexture == null) {
            return;
        }
        FluidState state = fluidStack.getFluid().defaultFluidState();
        long gameTime = level.getGameTime();
        float rawHeight = scale;
        TickLerp lerp = (TickLerp)lerpMap.computeIfAbsent(tank, k -> new HashMap()).get(pos);
        if (lerp == null) {
            lerp = new TickLerp();
            lerp.startTick = gameTime;
            lerp.startAmount = rawHeight;
            lerp.targetAmount = rawHeight;
            lerpMap.get(tank).put(pos, lerp);
        } else if (lerp.targetAmount != rawHeight) {
            lerp.startAmount = RenderFluidBlock.getCurrentLerpHeight(lerp, gameTime);
            lerp.targetAmount = rawHeight;
            lerp.startTick = gameTime;
        }
        float height = 1.0f;
        scale = (float)((double)RenderFluidBlock.getCurrentLerpHeight(lerp, gameTime) * 0.99 * (double)scale);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        poseStack.translate(-0.5, 0.0, -0.5);
        poseStack.scale(2.0f * scale1, scale, 2.0f * scale1);
        MultiBufferSource pBuffer = bufferSource;
        VertexConsumer builder = pBuffer.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)state));
        int i = level != null ? LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos) : 0xF000F0;
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(-1.0f, 0.0f, -1.5f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.75f, 0.75f, height, 0.75f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-1.0f, 0.0f, 0.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
        poseStack.translate(0.0f, 0.0f, -1.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0, 1.01, 1.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
    }

    public static void renderFluid(FluidStack fluidStack, MultiBufferSource bufferSource, Level level, BlockPos pos, PoseStack poseStack, float scale, float scale1, float scale2) {
        if (fluidStack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getFlowingTexture(fluidStack);
        if (stillTexture == null) {
            return;
        }
        FluidState state = fluidStack.getFluid().defaultFluidState();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        poseStack.translate(-0.5, 0.0, -0.5);
        poseStack.scale(2.0f * scale1, scale, 2.0f * scale2);
        float height = 1.0f;
        MultiBufferSource pBuffer = bufferSource;
        VertexConsumer builder = pBuffer.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)state));
        int i = level != null ? LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos) : 0xF000F0;
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        scale = (float)((double)scale * 0.99);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.translate(-1.0f, 0.0f, -1.5f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.75f, 0.75f, height, 0.75f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(-1.0f, 0.0f, 0.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
        poseStack.translate(0.0f, 0.0f, -1.0f);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0, 1.01, 1.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        RenderFluidBlock.drawQuad(builder, poseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), i, tintColor);
        poseStack.popPose();
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int color) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setColor(color).setUv(u, v).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static void drawQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int packedLight, int color) {
        RenderFluidBlock.drawVertex(builder, poseStack, x0, y0, z0, u0, v0, packedLight, color);
        RenderFluidBlock.drawVertex(builder, poseStack, x0, y1, z1, u0, v1, packedLight, color);
        RenderFluidBlock.drawVertex(builder, poseStack, x1, y1, z1, u1, v1, packedLight, color);
        RenderFluidBlock.drawVertex(builder, poseStack, x1, y0, z0, u1, v0, packedLight, color);
    }

    private static class TickLerp {
        long startTick;
        float startAmount;
        float targetAmount;

        private TickLerp() {
        }
    }
}

