/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.streak;

import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.streak.RGB;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;

public class PlayerStreakInfo {
    private RGB rgb;
    private boolean rainbow;

    public PlayerStreakInfo(RGB rgb, boolean rainbow) {
        this.rgb = rgb;
        this.rainbow = rainbow;
    }

    public PlayerStreakInfo(CompoundTag nbtTagCompound) {
        this.rgb = new RGB(nbtTagCompound.getShort("red"), nbtTagCompound.getShort("green"), nbtTagCompound.getShort("blue"));
        this.rainbow = nbtTagCompound.getBoolean("rainbow");
    }

    public PlayerStreakInfo(CustomPacketBuffer customPacketBuffer) {
        this.rgb = new RGB(customPacketBuffer.readShort(), customPacketBuffer.readShort(), customPacketBuffer.readShort());
        this.rainbow = customPacketBuffer.readBoolean();
    }

    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putShort("red", this.rgb.getRed());
        nbt.putShort("blue", this.rgb.getBlue());
        nbt.putShort("green", this.rgb.getGreen());
        nbt.putBoolean("rainbow", this.rainbow);
        return nbt;
    }

    public CustomPacketBuffer writePacket(RegistryAccess registryAccess) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer(registryAccess);
        packetBuffer.writeShort(this.rgb.getRed());
        packetBuffer.writeShort(this.rgb.getBlue());
        packetBuffer.writeShort(this.rgb.getGreen());
        packetBuffer.writeBoolean(this.rainbow);
        return packetBuffer;
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    public RGB getRgb() {
        return this.rgb;
    }

    public void setRgb(RGB rgb) {
        this.rgb = rgb;
    }
}

