/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileAnalyzer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DataOre {
    private String name;
    private List<BlockPos> listPos;
    private List<Vein> veinsList;
    private ItemStack stack;
    private List<ItemStack> recipe_stack;
    private BlockState iBlockState;
    private int number;
    private int y;

    public DataOre(String name, int number, int y, BlockPos pos, ItemStack stack, BlockState state) {
        this.name = name;
        this.number = number;
        this.y = y;
        this.listPos = pos != null ? new ArrayList<BlockPos>(Collections.singleton(pos)) : new ArrayList<BlockPos>();
        this.stack = stack;
        this.veinsList = new ArrayList<Vein>();
        this.iBlockState = state;
    }

    public DataOre(HolderLookup.Provider provider, CompoundTag tagCompound) {
        this.name = tagCompound.getString("name");
        this.number = tagCompound.getInt("number");
        this.y = tagCompound.getInt("y");
        int size = tagCompound.getInt("size");
        this.listPos = new ArrayList<BlockPos>();
        for (int i = 0; i < size; ++i) {
            CompoundTag posTag = tagCompound.getCompound("blockpos_" + i);
            this.listPos.add(new BlockPos(posTag.getInt("x"), posTag.getInt("y"), posTag.getInt("z")));
        }
        CompoundTag stackTag = tagCompound.getCompound("stackTag");
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)stackTag);
        this.iBlockState = ((BlockItem)this.stack.getItem()).getBlock().defaultBlockState();
        this.veinsList = new ArrayList<Vein>();
        int size1 = tagCompound.getInt("size1");
        for (int i = 0; i < size1; ++i) {
            CompoundTag veinTag = tagCompound.getCompound("vein_" + i);
            ChunkPos chunkPos = new ChunkPos(veinTag.getInt("x"), veinTag.getInt("z"));
            Vein vein = VeinSystem.system.getVein(chunkPos);
            if (vein == VeinSystem.EMPTY) continue;
            this.veinsList.add(vein);
        }
    }

    public DataOre(CustomPacketBuffer customPacketBuffer) {
        this.name = customPacketBuffer.readString();
        this.number = customPacketBuffer.readInt();
        this.y = customPacketBuffer.readInt();
        try {
            this.listPos = (List)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.iBlockState = ((Block)DecoderHandler.decode(customPacketBuffer)).defaultBlockState();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.veinsList = (List)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ItemStack> getRecipe_stack(TileAnalyzer tileAnalyzer, BlockPos pos) {
        List<BaseMachineRecipe> recipes;
        if (this.recipe_stack != null) {
            return this.recipe_stack;
        }
        this.iBlockState.getBlock();
        List drops = Block.getDrops((BlockState)this.iBlockState, (ServerLevel)((ServerLevel)tileAnalyzer.getWorld()), (BlockPos)pos, null);
        ArrayList<Object> list = new ArrayList<Object>();
        if (tileAnalyzer.macerator || tileAnalyzer.comb_macerator) {
            if (tileAnalyzer.macerator) {
                for (Object stack1 : drops) {
                    rec = Recipes.recipes.getRecipeOutput("macerator", false, new ItemStack[]{stack1});
                    if (rec != null) {
                        output = rec.output.items.get(0).copy();
                        output.setCount(stack1.getCount() * output.getCount());
                        list.add(output);
                        continue;
                    }
                    list.add(stack1);
                }
            } else {
                for (Object stack1 : drops) {
                    rec = Recipes.recipes.getRecipeOutput("comb_macerator", false, new ItemStack[]{stack1});
                    if (rec != null) {
                        output = rec.output.items.get(0).copy();
                        output.setCount(stack1.getCount() * output.getCount());
                        list.add(output);
                        continue;
                    }
                    list.add(stack1);
                }
            }
        }
        if (!list.isEmpty()) {
            drops.clear();
            drops.addAll(list);
            list.clear();
        }
        if (tileAnalyzer.polisher) {
            recipes = Recipes.recipes.getRecipeList("laser");
            for (ItemStack stack : drops) {
                BaseMachineRecipe recipe = Recipes.recipes.getRecipeOutput("laser", false, stack);
                if (recipe != null) {
                    list.add(recipe.getOutput().items.get(0).copy());
                    continue;
                }
                boolean can = true;
                for (BaseMachineRecipe recipe1 : recipes) {
                    if (!recipe1.getOutput().items.get(0).is(stack.getItem())) continue;
                    ItemStack stack1 = stack.copy();
                    stack1.setCount(recipe1.getOutput().items.get(0).getCount());
                    list.add(stack1);
                    can = false;
                    break;
                }
                if (can) continue;
                list.add(stack);
            }
        }
        if (tileAnalyzer.furnace) {
            recipes = Recipes.recipes.getRecipeList("furnace");
            BaseMachineRecipe recipe = Recipes.recipes.getRecipeOutput("furnace", false, this.stack);
            if (recipe != null) {
                list.add(recipe.getOutput().items.get(0).copy());
            } else {
                boolean can = true;
                for (BaseMachineRecipe recipe1 : recipes) {
                    if (!recipe1.getOutput().items.get(0).is(this.stack.getItem())) continue;
                    ItemStack stack1 = this.stack.copy();
                    stack1.setCount(recipe1.getOutput().items.get(0).getCount());
                    list.add(stack1);
                    can = false;
                    break;
                }
                if (!can) {
                    list.add(this.stack);
                }
            }
        }
        if (!list.isEmpty()) {
            drops.clear();
            drops.addAll(list);
            list.clear();
        }
        this.recipe_stack = drops;
        return this.recipe_stack;
    }

    public CompoundTag getTagCompound(HolderLookup.Provider provider) {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putString("name", this.name);
        tagCompound.putInt("number", this.number);
        tagCompound.putInt("y", this.y);
        tagCompound.putInt("size", this.listPos.size());
        for (int i = 0; i < this.listPos.size(); ++i) {
            CompoundTag posTag = new CompoundTag();
            BlockPos pos = this.listPos.get(i);
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            tagCompound.put("blockpos_" + i, (Tag)posTag);
        }
        CompoundTag stackTag = new CompoundTag();
        this.stack.save(provider, (Tag)stackTag);
        tagCompound.put("stackTag", (Tag)stackTag);
        tagCompound.putInt("size1", this.veinsList.size());
        for (int i = 0; i < this.veinsList.size(); ++i) {
            CompoundTag VeinTag = new CompoundTag();
            Vein vein = this.veinsList.get(i);
            VeinTag.putInt("x", vein.getChunk().x);
            VeinTag.putInt("z", vein.getChunk().z);
            tagCompound.put("vein_" + i, (Tag)VeinTag);
        }
        return tagCompound;
    }

    public CustomPacketBuffer getCustomPacket(RegistryAccess registryAccess) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(registryAccess);
        customPacketBuffer.writeString(this.name);
        customPacketBuffer.writeInt(this.number);
        customPacketBuffer.writeInt(this.y);
        try {
            EncoderHandler.encode(customPacketBuffer, this.listPos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.iBlockState.getBlock());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.veinsList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    public BlockState getiBlockState() {
        return this.iBlockState;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public List<BlockPos> getListPos() {
        return this.listPos;
    }

    public void addPos(BlockPos pos) {
        this.listPos.add(pos);
    }

    public void addVein(Vein vein) {
        this.veinsList.add(vein);
    }

    public void addY(int y) {
        this.y += y;
    }

    public List<Vein> getVeinsList() {
        return this.veinsList;
    }

    public void addNumber(int number) {
        this.number += number;
    }

    public int getAverage() {
        return this.y / this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataOre dataOre = (DataOre)o;
        return Objects.equals(this.name, dataOre.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public int getY() {
        return this.y;
    }

    public boolean contains(BlockPos pos1) {
        return this.listPos.contains(pos1);
    }
}

