/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.inv.ITileInventory;
import com.denfop.api.inv.VirtualSlot;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentPrivate;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.Register;
import com.denfop.tiles.base.InfoInvSlots;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityInventory
extends TileEntityBlock
implements IAdvInventory<TileEntityInventory>,
WorldlyContainer,
ITileInventory {
    protected final List<InvSlot> invSlots = new ArrayList<InvSlot>();
    protected final List<InfoInvSlots> infoInvSlotsList = new ArrayList<InfoInvSlots>();
    protected final List<InvSlot> inputSlots = new LinkedList<InvSlot>();
    protected final List<InvSlot> outputSlots = new LinkedList<InvSlot>();
    protected final IItemHandler[] itemHandler = new IItemHandler[Direction.values().length + 1];
    private final ComponentPrivate componentPrivate = this.addComponent(new ComponentPrivate(this));
    protected boolean isLoaded = false;
    protected int size_inventory;
    protected ComponentClientEffectRender componentClientEffectRender;
    protected SoilPollutionComponent pollutionSoil;
    protected AirPollutionComponent pollutionAir;
    private int[] slotsFace;
    private int windowId;

    public TileEntityInventory(IMultiTileBlock tileBlock, BlockPos pos, BlockState state) {
        super(tileBlock, pos, state);
    }

    public static int getIndex(int loc) {
        return loc >>> 16;
    }

    public void onNetworkEvent(int var1) {
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            CompoundTag invSlotsTag = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
            for (int i = 0; i < this.invSlots.size(); ++i) {
                InvSlot invSlot = this.invSlots.get(i);
                invSlot.readFromNbt(invSlotsTag.getCompound(String.valueOf(i)), (HolderLookup.Provider)customPacketBuffer.registryAccess());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        CompoundTag invSlotsTag = new CompoundTag();
        for (int i = 0; i < this.invSlots.size(); ++i) {
            CompoundTag invSlotTag = new CompoundTag();
            InvSlot invSlot = this.invSlots.get(i);
            invSlot.writeToNbt(invSlotTag, (HolderLookup.Provider)customPacketBuffer.registryAccess());
            invSlotsTag.put(String.valueOf(i), (Tag)invSlotTag);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, invSlotsTag);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        IUpgradableBlock upgradableBlock;
        IUpgradeItem iUpgradeItem;
        if (this.level.isClientSide) {
            return true;
        }
        for (AbstractComponent component : this.componentList) {
            if (!component.onBlockActivated(player, hand)) continue;
            return true;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && stack.getItem() instanceof IUpgradeItem && this instanceof IUpgradableBlock && (iUpgradeItem = (IUpgradeItem)stack.getItem()).isSuitableFor(stack, (upgradableBlock = (IUpgradableBlock)((Object)this)).getUpgradableProperties())) {
            for (InvSlot invslot : this.invSlots) {
                if (!(invslot instanceof InvSlotUpgrade)) continue;
                InvSlotUpgrade upgrade = (InvSlotUpgrade)invslot;
                if (!upgrade.add(stack)) break;
                stack.setCount(0);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.containerMenu.broadcastChanges();
                }
                this.setChanged();
                return true;
            }
        }
        this.openContainer(player);
        return true;
    }

    private void openContainer(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        if (this.getGuiContainer(player) != null) {
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer(player.registryAccess());
            try {
                EncoderHandler.encode(growingBuffer, this);
            }
            catch (IOException var5) {
                throw new RuntimeException(var5);
            }
            growingBuffer.flip();
            player.closeContainer();
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)this, buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
    }

    public InfoInvSlots locateInfoInvSlot(int extIndex) {
        try {
            return this.infoInvSlotsList.get(extIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void putStackAt(InfoInvSlots loc, ItemStack stack) {
        loc.getSlot().set(loc.getIndex(), stack);
        super.setChanged();
    }

    protected InvSlot getInventorySlot(int extIndex) {
        InfoInvSlots loc = this.locateInfoInvSlot(extIndex);
        return loc == null ? null : loc.getSlot();
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public <T> T getCapability(@NotNull BlockCapability<T, Direction> cap, @Nullable Direction side) {
        if (cap == Capabilities.ItemHandler.BLOCK) {
            if (side == null) {
                if (this.itemHandler[this.itemHandler.length - 1] == null) {
                    this.itemHandler[this.itemHandler.length - 1] = new InvWrapper((Container)this);
                }
                return (T)this.itemHandler[this.itemHandler.length - 1];
            }
            if (this.itemHandler[side.ordinal()] == null) {
                this.itemHandler[side.ordinal()] = new SidedInvWrapper((WorldlyContainer)this, side);
            }
            return (T)this.itemHandler[side.ordinal()];
        }
        if (this.capabilityComponents == null) {
            return super.getCapability(cap, side);
        }
        AbstractComponent comp = (AbstractComponent)this.capabilityComponents.get(cap);
        return comp == null ? super.getCapability(cap, side) : comp.getCapability(cap, side);
    }

    @Override
    public TileEntityInventory getParent() {
        return this;
    }

    @Override
    public void addInventorySlot(InvSlot inventorySlot) {
        assert (this.invSlots.stream().noneMatch(slot -> slot.equals(inventorySlot)));
        this.invSlots.add(inventorySlot);
    }

    @Override
    public int getBaseIndex(InvSlot var1) {
        int ret = 0;
        for (InvSlot slot : this.invSlots) {
            if (slot == var1) {
                return ret;
            }
            ret += slot.size();
        }
        return -1;
    }

    @Override
    public MenuType<?> getMenuType() {
        return (MenuType)Register.containerBase.get();
    }

    @Override
    public int getContainerId() {
        return this.windowId;
    }

    @Override
    public ContainerBase<?> getGuiContainer(Player var1) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return null;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }

    public int[] getSlotsForFace(Direction p_19238_) {
        if (this.slotsFace == null) {
            this.slotsFace = new int[this.getContainerSize()];
            for (int i = 0; i < this.getContainerSize(); ++i) {
                this.slotsFace[i] = i;
            }
        }
        return this.slotsFace;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction p_19237_) {
        if (ModUtils.isEmpty(stack)) {
            return false;
        }
        InvSlot targetSlot = this.getInventorySlot(index);
        if (targetSlot == null) {
            return false;
        }
        return targetSlot.canInput() && targetSlot.accepts(stack, this.locateInfoInvSlot(index).getIndex());
    }

    public void removeInventorySlot(InvSlot inventorySlot) {
        this.invSlots.remove(inventorySlot);
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        return super.getSelfDrops(fortune, wrench);
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(super.getAuxDrops(fortune));
        for (InvSlot slot : this.invSlots) {
            if (slot instanceof VirtualSlot) continue;
            for (ItemStack stack : slot) {
                if (ModUtils.isEmpty(stack)) continue;
                ret.add(stack);
            }
        }
        for (AbstractComponent component : this.getComponentList()) {
            if (component.getDrops().isEmpty()) continue;
            ret.addAll(component.getDrops());
        }
        return ret;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.componentPrivate.onNetworkUpdate((CustomPacketBuffer)((Object)DecoderHandler.decode(customPacketBuffer)));
            for (AbstractComponent component : this.componentList) {
                component.onNetworkUpdate(customPacketBuffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = super.writePacket();
        try {
            EncoderHandler.encode(packetBuffer, this.componentPrivate);
            for (AbstractComponent component : this.componentList) {
                packetBuffer.writeBytes((ByteBuf)component.updateComponent());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packetBuffer;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        CompoundTag invSlotsTag = nbtTagCompound.getCompound("InvSlots");
        for (int i = 0; i < this.invSlots.size(); ++i) {
            InvSlot invSlot = this.invSlots.get(i);
            invSlot.readFromNbt(invSlotsTag.getCompound(String.valueOf(i)), this.provider);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        CompoundTag invSlotsTag = new CompoundTag();
        for (int i = 0; i < this.invSlots.size(); ++i) {
            InvSlot invSlot = this.invSlots.get(i);
            CompoundTag invSlotTag = new CompoundTag();
            invSlot.writeToNbt(invSlotTag, this.provider);
            invSlotsTag.put(String.valueOf(i), (Tag)invSlotTag);
        }
        nbt.put("InvSlots", (Tag)invSlotsTag);
        return nbt;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack p_19240_, Direction p_19241_) {
        InvSlot targetSlot = this.getInventorySlot(index);
        return targetSlot != null && targetSlot.canOutput();
    }

    public int getContainerSize() {
        if (this.size_inventory == 0 && !this.invSlots.isEmpty()) {
            for (InvSlot invSlot : this.invSlots) {
                this.size_inventory += invSlot.size();
            }
        }
        return this.size_inventory;
    }

    public boolean isEmpty() {
        return this.invSlots.isEmpty();
    }

    public List<InvSlot> getInputSlots() {
        return this.inputSlots;
    }

    public List<InvSlot> getOutputSlots() {
        return this.outputSlots;
    }

    public ItemStack getItem(int index) {
        InfoInvSlots loc = this.locateInfoInvSlot(index);
        return loc == null ? ModUtils.emptyStack : loc.getSlot().get(loc.getIndex());
    }

    public int getMaxStackSize() {
        return this.getInventoryStackLimit();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public ItemStack removeItem(int index, int amount) {
        InfoInvSlots loc = this.locateInfoInvSlot(index);
        if (loc == null) {
            return ModUtils.emptyStack;
        }
        ItemStack stack = loc.getSlot().get(loc.getIndex());
        if (ModUtils.isEmpty(stack)) {
            return ModUtils.emptyStack;
        }
        if (amount >= ModUtils.getSize(stack)) {
            this.putStackAt(loc, ModUtils.emptyStack);
            return stack;
        }
        if (amount != 0) {
            if (amount < 0) {
                int space = Math.min(loc.getSlot().getStackSizeLimit(), stack.getMaxStackSize()) - ModUtils.getSize(stack);
                amount = Math.max(amount, -space);
            }
            this.putStackAt(loc, ModUtils.decSize(stack, amount));
        }
        ItemStack ret = stack.copy();
        ret = ModUtils.setSize(ret, amount);
        return ret;
    }

    public ComponentPrivate getComponentPrivate() {
        return this.componentPrivate;
    }

    public List<InvSlot> getInvSlots() {
        return this.invSlots;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.infoInvSlotsList.clear();
        this.inputSlots.clear();
        this.outputSlots.clear();
        for (InvSlot slot : this.invSlots) {
            for (int k = 0; k < slot.size(); ++k) {
                this.infoInvSlotsList.add(new InfoInvSlots(slot, k));
            }
            if (slot.getTypeItemSlot() == null) continue;
            if (slot.getTypeItemSlot().isInput()) {
                this.inputSlots.add(slot);
            }
            if (!slot.getTypeItemSlot().isOutput()) continue;
            this.outputSlots.add(slot);
        }
        this.size_inventory = 0;
        for (InvSlot invSlot : this.invSlots) {
            this.size_inventory += invSlot.size();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.componentClientEffectRender != null) {
            this.componentClientEffectRender.render();
        }
    }

    public ItemStack removeItemNoUpdate(int index) {
        InfoInvSlots loc = this.locateInfoInvSlot(index);
        if (loc == null) {
            return ModUtils.emptyStack;
        }
        ItemStack ret = loc.getSlot().get(loc.getIndex());
        if (!ModUtils.isEmpty(ret)) {
            this.putStackAt(loc, ModUtils.emptyStack);
        }
        return ret;
    }

    @Override
    public void setChanged() {
        super.setChanged();
        for (InvSlot invSlot : this.invSlots) {
            invSlot.onChanged();
        }
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        InvSlot invSlot = this.getInventorySlot(index);
        return invSlot != null && invSlot.canInput() && invSlot.accepts(stack, this.locateInfoInvSlot(index).getIndex());
    }

    public void setItem(int p_18944_, ItemStack stack) {
        InfoInvSlots loc = this.locateInfoInvSlot(p_18944_);
        if (loc == null) {
            assert (false);
        } else {
            if (ModUtils.isEmpty(stack)) {
                stack = ModUtils.emptyStack;
            }
            this.putStackAt(loc, stack);
        }
    }

    public boolean stillValid(Player p_18946_) {
        return !this.isRemoved();
    }

    public void clearContent() {
    }

    @Nonnull
    public String getName() {
        return this.getBlock().item.getDescriptionId();
    }

    public Component getDisplayName() {
        return Component.literal((String)Localization.translate(this.getName()));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        this.windowId = p_39954_;
        return this.getGuiContainer(p_39956_);
    }
}

