/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockResource;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.ProcessMultiComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerMultiMachine;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiMultiMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.items.modules.ItemModuleTypePanel;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.EnumTypeMachines;
import com.denfop.tiles.mechanism.multimechanism.IMultiMachine;
import com.denfop.tiles.panels.entity.EnumSolarPanels;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public abstract class TileMultiMachine
extends TileEntityInventory
implements IAudioFixer,
IUpgradableBlock,
IUpdatableTileEvent,
IHasRecipe,
IMultiMachine {
    public final Energy energy;
    public final InvSlotDischarge dischargeSlot;
    public final ProcessMultiComponent multi_process;
    public final int sizeWorkingSlot;
    public final InvSlot input_slot;
    private final ComponentUpgradeSlots componentUpgrades;
    public CoolComponent cold;
    public HeatComponent heat = null;
    public FluidTank tank = null;
    public ComponentBaseEnergy exp;
    public EnumSolarPanels solartype;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound;
    private Fluids fluid = null;
    private int tick;
    private TileSolarPanel panel;

    public TileMultiMachine(EnumMultiMachine enumMultiMachine, IMultiTileBlock block, BlockPos pos, BlockState state) {
        this(1, enumMultiMachine.usagePerTick, enumMultiMachine.lenghtOperation, block, pos, state);
    }

    public TileMultiMachine(int energyconsume, int OperationsPerTick, IMultiTileBlock block, BlockPos pos, BlockState state) {
        this(1, energyconsume, OperationsPerTick, block, pos, state);
    }

    public TileMultiMachine(int aDefaultTier, int energyconsume, int OperationsPerTick, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.sizeWorkingSlot = this.getMachine().sizeWorkingSlot;
        this.dischargeSlot = new InvSlotDischarge(this, InvSlot.TypeItemSlot.INPUT, aDefaultTier, false);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, (double)energyconsume * (double)OperationsPerTick, (int)Math.min(14.0, Math.pow(2.0, this.sizeWorkingSlot - 1))).addManagedSlot(this.dischargeSlot));
        if (this.getMachine().type == EnumTypeMachines.OreWashing) {
            this.fluid = this.addComponent(new Fluids(this));
            this.tank = this.fluid.addTank("tank", 64000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.WATER}));
        }
        this.solartype = null;
        this.cold = this.addComponent(CoolComponent.asBasicSink(this, 100.0));
        this.sound = true;
        this.exp = null;
        if (this.getMachine().type == EnumTypeMachines.ELECTRICFURNACE) {
            this.exp = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.EXPERIENCE, this, 5000.0, 14));
        }
        if (this.getMachine().type == EnumTypeMachines.Centrifuge) {
            this.heat = this.addComponent(HeatComponent.asBasicSink(this, 5000.0));
        }
        this.multi_process = this.addComponent(new ProcessMultiComponent(this, this.getMachine()));
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.HEAT);
        this.componentUpgrades = this.addComponent(new ComponentUpgradeSlots(this, this, this.multi_process.getUpgradeSlot()){

            @Override
            public void setOverclockRates(InvSlotUpgrade invSlotUpgrade) {
                super.setOverclockRates(invSlotUpgrade);
                invSlotUpgrade.isUpdate = true;
                ((TileMultiMachine)this.getParent()).multi_process.setOverclockRates();
                invSlotUpgrade.isUpdate = false;
            }
        });
        this.input_slot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).isEmpty()) {
                    ((TileMultiMachine)this.base).multi_process.inputSlots.changeAccepts(ItemStack.EMPTY);
                } else {
                    ((TileMultiMachine)this.base).multi_process.inputSlots.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() == IUItem.recipe_schedule.getItem();
            }
        };
    }

    public int getFertilizer() {
        return 0;
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public HeatComponent getHeat() {
        return this.heat;
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            Object o = DecoderHandler.decode(customPacketBuffer);
            if (o != null) {
                this.solartype = EnumSolarPanels.values()[(Integer)o];
            }
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, (Object)this.solartype);
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void init() {
    }

    @Override
    public SoundEvent getSound() {
        return this.getMachine().type.getSound();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        CompoundTag nbt;
        double energy1;
        if (this.getMachine().type == EnumTypeMachines.FARMER) {
            tooltip.add(Localization.translate("iu.farmer.info"));
        }
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            if (!this.cold.upgrade) {
                tooltip.add(Localization.translate("iu.multimachine.info"));
            }
            if (this.heat != null) {
                tooltip.add(Localization.translate("iu.heatmachine.info"));
            }
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.multi_process.energyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.multi_process.operationLength);
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
        if ((energy1 = (nbt = ModUtils.nbt(stack)).getDouble("energy")) != 0.0) {
            tooltip.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(energy1) + "/" + ModUtils.getString(this.energy.getCapacity()) + " EF");
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.getSound() == null) {
            return;
        }
        if (this.getEnable()) {
            if (soundEvent == 0) {
                this.getWorld().playSound(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (soundEvent == 1) {
                new PacketStopSound(this.getWorld(), this.pos);
                this.getWorld().playSound(null, this.pos, EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                new PacketStopSound(this.getWorld(), this.pos);
            }
        }
    }

    public void onUpdate() {
    }

    public CoolComponent getComponent() {
        return this.cold;
    }

    public List<ItemStack> getDrop() {
        return this.getAuxDrops(0);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        CompoundTag nbt = ModUtils.nbt(stack);
        double energy1 = nbt.getDouble("energy");
        if (energy1 != 0.0) {
            this.energy.addEnergy(energy1);
        }
        double energy4 = nbt.getDouble("energy2");
        if (energy1 != 0.0 && this.cold != null) {
            this.cold.addEnergy(energy4);
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        CoolComponent component3;
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    CoolComponent component32;
                    Energy component = this.energy;
                    if (component != null && component.getEnergy() != 0.0) {
                        CompoundTag nbt = ModUtils.nbt(drop);
                        nbt.putDouble("energy", component.getEnergy());
                    }
                    if ((component32 = this.cold) != null && component32.getEnergy() != 0.0) {
                        CompoundTag nbt = ModUtils.nbt(drop);
                        nbt.putDouble("energy2", component32.getEnergy());
                    }
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack(IUItem.basemachine2.getItem(78), 1);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        Energy component = this.getComp(Energy.class);
        if (component != null && component.getEnergy() != 0.0) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.putDouble("energy", component.getEnergy());
        }
        if ((component3 = this.cold) != null && component3.getEnergy() != 0.0) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.putDouble("energy2", component3.getEnergy());
        }
        return drop;
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        ItemStack stack_quickly = ItemStack.EMPTY;
        ItemStack stack_modulesize = ItemStack.EMPTY;
        ItemStack stack_modulestorage = ItemStack.EMPTY;
        ItemStack panel = ItemStack.EMPTY;
        ItemStack colling = ItemStack.EMPTY;
        ItemStack module_separate = ItemStack.EMPTY;
        ItemStack module_infinity_water = ItemStack.EMPTY;
        if (this.multi_process.quickly) {
            stack_quickly = new ItemStack((ItemLike)IUItem.module_quickly.getItem());
        }
        if (this.multi_process.modulesize) {
            stack_modulesize = new ItemStack((ItemLike)IUItem.module_stack.getItem());
        }
        if (this.multi_process.modulestorage) {
            stack_modulestorage = new ItemStack((ItemLike)IUItem.module_storage.getItem());
        }
        if (this.multi_process.module_separate) {
            module_separate = new ItemStack((ItemLike)IUItem.module_separate.getItem());
        }
        if (this.multi_process.module_infinity_water) {
            module_infinity_water = new ItemStack((ItemLike)IUItem.module_infinity_water.getItem());
        }
        if (this.solartype != null) {
            panel = new ItemStack((ItemLike)IUItem.module6.getStack(this.solartype.meta), 1);
        }
        if (this.cold.upgrade && this.getMachine().type != EnumTypeMachines.Centrifuge) {
            colling = new ItemStack((ItemLike)IUItem.coolupgrade.getStack(this.cold.meta), 1);
        }
        if (!(stack_modulestorage.isEmpty() && stack_quickly.isEmpty() && module_separate.isEmpty() && module_infinity_water.isEmpty() && stack_modulesize.isEmpty() && panel.isEmpty() && colling.isEmpty())) {
            if (!stack_modulestorage.isEmpty()) {
                ret.add(stack_modulestorage);
                this.multi_process.shrinkModule(1);
                this.multi_process.setModulesize(false);
            }
            if (!stack_quickly.isEmpty()) {
                ret.add(stack_quickly);
                this.multi_process.shrinkModule(1);
                this.multi_process.setQuickly(false);
            }
            if (!module_separate.isEmpty()) {
                ret.add(module_separate);
                this.multi_process.shrinkModule(1);
                this.multi_process.module_separate = false;
            }
            if (!module_infinity_water.isEmpty()) {
                ret.add(module_infinity_water);
                this.multi_process.shrinkModule(1);
                this.multi_process.module_infinity_water = false;
            }
            if (!stack_modulesize.isEmpty()) {
                ret.add(stack_modulesize);
                this.multi_process.shrinkModule(1);
                this.multi_process.setModulesize(false);
            }
            if (this.solartype != null) {
                ret.add(panel);
                this.solartype = null;
            }
            if (!colling.isEmpty()) {
                ret.add(colling);
                this.cold.upgrade = false;
                this.cold.meta = 0;
            }
        }
        return ret;
    }

    @Override
    public boolean onActivated(Player entityPlayer, InteractionHand hand, Direction side, Vec3 hitX) {
        if (!entityPlayer.getItemInHand(hand).isEmpty()) {
            if (entityPlayer.getItemInHand(hand).getItem() instanceof ItemModuleTypePanel) {
                if (this.solartype != null) {
                    EnumSolarPanels type = this.solartype;
                    int meta = type.meta;
                    ItemStack stack = new ItemStack((ItemLike)IUItem.module6.getStack(meta));
                    if (!entityPlayer.getInventory().add(stack)) {
                        ItemEntity item = new ItemEntity(entityPlayer.level(), (double)((int)entityPlayer.getX()), (double)((int)entityPlayer.getY() - 1), (double)((int)entityPlayer.getZ()), stack);
                        item.setDefaultPickUpDelay();
                        this.level.addFreshEntity((Entity)item);
                    }
                }
                this.solartype = ItemModuleTypePanel.getSolarType(IUItem.module6.getMeta((ItemModuleTypePanel)entityPlayer.getItemInHand(hand).getItem()));
                entityPlayer.getItemInHand(hand).shrink(1);
                return true;
            }
            if (this.multi_process.onActivated(entityPlayer.getItemInHand(hand))) {
                return true;
            }
            if (!this.getWorld().isClientSide && FluidHandlerFix.getFluidHandler(entityPlayer.getItemInHand(hand)) != null && this.fluid != null) {
                return ModUtils.interactWithFluidHandler(entityPlayer, hand, (IFluidHandler)this.fluid.getCapability(Capabilities.FluidHandler.BLOCK, side));
            }
        }
        return super.onActivated(entityPlayer, hand, side, hitX);
    }

    public abstract EnumMultiMachine getMachine();

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        int id = nbttagcompound.getInt("panelid");
        if (id != -1) {
            this.solartype = IUItem.map1.get(id);
        }
        this.sound = nbttagcompound.getBoolean("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.solartype != null) {
            nbttagcompound.putInt("panelid", this.solartype.meta);
        } else {
            nbttagcompound.putInt("panelid", -1);
        }
        nbttagcompound.putBoolean("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (event == 0.0) {
            this.multi_process.cycleMode();
        } else {
            this.sound = !this.sound;
            new PacketUpdateFieldTile(this, "sound", this.sound);
            if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
                this.setType(EnumTypeAudio.OFF);
                new PacketStopSound(this.getWorld(), this.pos);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            new PacketUpdateFieldTile(this, "sound", this.sound);
            if (this.input_slot.isEmpty()) {
                this.multi_process.inputSlots.changeAccepts(ItemStack.EMPTY);
            } else {
                this.multi_process.inputSlots.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public EnumTypeMachines getTypeMachine() {
        return this.getMachine().type;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.level.getGameTime() % 5L == 0L) {
            switch (this.getMachine().type) {
                case FARMER: {
                    ParticleUtils.spawnFarmParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case CUTTING: {
                    ParticleUtils.spawnCutterParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case ROLLING: {
                    ParticleUtils.spawnRollingMillParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case RECYCLER: {
                    ParticleUtils.spawnRecyclerParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case EXTRACTOR: {
                    ParticleUtils.spawnExtractorParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case Centrifuge: {
                    ParticleUtils.spawnCentrifugeParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case Gearing: {
                    ParticleUtils.spawnGearParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case EXTRUDING: {
                    ParticleUtils.spawnExtruderParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case MACERATOR: {
                    ParticleUtils.spawnMaceratorParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case COMPRESSOR: {
                    ParticleUtils.spawnCompressorParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case OreWashing: {
                    ParticleUtils.spawnOreWashingParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case COMBRECYCLER: {
                    ParticleUtils.spawnRecyclerParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case COMBMACERATOR: {
                    ParticleUtils.spawnMaceratorParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case ASSAMPLERSCRAP: {
                    ParticleUtils.spawnScrapCollectorParticles(this.level, this.pos, this.level.random);
                    break;
                }
                case ELECTRICFURNACE: {
                    ParticleUtils.showFlames((ServerLevel)this.getWorld(), this.getBlockPos(), this.getFacing());
                }
            }
        }
        if (this.solartype != null) {
            if (this.energy.getEnergy() < this.energy.getCapacity()) {
                if (this.panel == null) {
                    this.panel = new TileSolarPanel(this.solartype, (IMultiTileBlock)this.solartype.block.getBlock(this.solartype.meta).getValue(), this.pos, this.solartype.block.getBlock(this.solartype.meta).defaultBlockState());
                    this.panel.setLevel(this.getWorld());
                    IAdvEnergyNet advEnergyNet = EnergyNetGlobal.instance;
                    if (this.panel.biome == null) {
                        this.panel.biome = this.getLevel().getBiome(this.pos);
                    }
                    this.panel.sunCoef = advEnergyNet.getSunCoefficient(this.level);
                    this.panel.canRain = ((Biome)this.panel.biome.value()).getPrecipitationAt(this.pos) == Biome.Precipitation.RAIN || ((Biome)this.panel.biome.value()).getModifiedClimateSettings().downfall() > 0.0f;
                    this.panel.hasSky = this.getLevel().dimension() != Level.NETHER;
                    this.panel.wetBiome = ((Biome)this.panel.biome.value()).getModifiedClimateSettings().downfall() > 0.0f;
                    this.panel.noSunWorld = this.getLevel().dimension() == Level.NETHER;
                    this.panel.rain = this.panel.wetBiome && (this.getLevel().isRaining() || this.getLevel().isThundering());
                    this.panel.sunIsUp = this.getLevel().isDay();
                    boolean bl = this.panel.skyIsVisible = this.getLevel().canSeeSky(this.worldPosition) && this.getLevel().getBlockState(this.worldPosition.above()).getMapColor((BlockGetter)this.getLevel(), this.worldPosition.above()) == MapColor.NONE && !this.panel.noSunWorld;
                }
                if (this.panel.activeState == null || this.getWorld().getGameTime() % 40L == 0L) {
                    this.panel.updateVisibility();
                }
                this.panel.gainFuel();
                if (this.energy.getEnergy() < this.energy.getCapacity()) {
                    this.energy.addEnergy(Math.min(this.panel.generating, this.energy.getFreeEnergy()));
                }
            }
        } else if (this.panel != null) {
            this.panel = null;
        }
        ++this.tick;
        if (!this.getActive()) {
            if (this.tick - 120 >= 0) {
                this.cold.useEnergy(0.35);
                this.tick = 0;
            }
        } else if (this.tick - 240 >= 0) {
            this.cold.useEnergy(0.35);
            this.tick = 0;
        }
    }

    public ContainerMultiMachine getGuiContainer(Player player) {
        return new ContainerMultiMachine(player, this, this.sizeWorkingSlot);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player player, ContainerBase<? extends IAdvInventory> isAdmin) {
        return new GuiMultiMachine((ContainerMultiMachine)isAdmin);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    public int getMode() {
        return 0;
    }

    @Override
    public boolean canoperate(int size) {
        return true;
    }

    @Override
    public int getSize(int size) {
        return size;
    }

    @Override
    public void consume(int size) {
    }
}

