/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.bee;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.bee.BeeAI;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.bee.IBee;
import com.denfop.api.bee.Product;
import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.GeneticsManager;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.item.IDamageItem;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockApiary;
import com.denfop.container.ContainerApiary;
import com.denfop.container.ContainerBase;
import com.denfop.damagesource.IUDamageSource;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.entity.SmallBee;
import com.denfop.gui.GuiApiary;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemFluidCell;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.items.energy.ItemNet;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.bee.Bee;
import com.denfop.tiles.bee.EnumProblem;
import com.denfop.tiles.bee.EnumStatus;
import com.denfop.tiles.bee.EnumTypeBee;
import com.denfop.tiles.bee.EnumTypeLife;
import com.denfop.tiles.bee.FrameAttributeLevel;
import com.denfop.tiles.bee.IApiaryTile;
import com.denfop.tiles.bee.IFrameItem;
import com.denfop.tiles.crop.TileEntityCrop;
import com.denfop.tiles.mechanism.TileEntityApothecaryBee;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleUtils;
import com.denfop.world.WorldBaseGen;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityApiary
extends TileEntityInventory
implements IApiaryTile {
    static final int percentAttackBee = 20;
    static final int percentDoctorBee = 20;
    static final int percentWorkersBee = 45;
    static final int percentBuildersBee = 15;
    public static BeeAI beeAI = BeeAI.beeAI;
    public final InvSlotOutput invSlotProduct;
    public final InvSlot frameSlot;
    public final InvSlotOutput invSlotFood;
    public final InvSlotOutput invSlotJelly;
    public final InvSlot foodCellSlot;
    public final InvSlot jellyCellSlot;
    public List<Bee> birthBeeList = new LinkedList<Bee>();
    public double royalJelly = 0.0;
    public double food = 0.0;
    public long id;
    public int harvest = 0;
    public ChunkPos chunkPos;
    public ChunkLevel chunkLevel;
    public Biome biome;
    public LevelChunk chunk;
    public Radiation radLevel;
    public boolean rain;
    public boolean thundering;
    public int task;
    public int workers;
    public int builders;
    public int attacks;
    public int bees;
    public int doctors;
    public int death;
    public byte deathTask;
    public byte illTask;
    public int birth;
    public int ill;
    public List<EnumProblem> problemList = new ArrayList<EnumProblem>();
    public boolean work;
    public short maxFood = (short)1000;
    public short maxJelly = (short)200;
    public short maxDefaultFood = (short)1000;
    public short maxDefaultJelly = (short)200;
    double[] massiveNeeds = new double[5];
    List<Bee> apairyBeeList = new LinkedList<Bee>();
    IBee queen;
    List<Bee> attackBeeList = new LinkedList<Bee>();
    List<Bee> doctorBeeList = new LinkedList<Bee>();
    List<Bee> workersBeeList = new LinkedList<Bee>();
    List<Bee> buildersBeeList = new LinkedList<Bee>();
    List<Bee> illBeeList = new LinkedList<Bee>();
    Map<Player, Double> enemy;
    Map<Long, EnumStatus> statusMap = new HashMap<Long, EnumStatus>();
    Map<Player, Double> entityWeightMap = new HashMap<Player, Double>();
    Set<ChunkPos> chunkPositions = new HashSet<ChunkPos>();
    Map<ChunkPos, List<TileEntityCrop>> chunkPosListMap = new HashMap<ChunkPos, List<TileEntityCrop>>();
    Map<ChunkPos, List<TileEntityApiary>> chunkPosListMap1 = new HashMap<ChunkPos, List<TileEntityApiary>>();
    List<TileEntityCrop> crops = new ArrayList<TileEntityCrop>();
    List<TileEntityCrop> passedCrops = new ArrayList<TileEntityCrop>();
    List<TileEntityApiary> apiaries = new ArrayList<TileEntityApiary>();
    List<TileEntityApiary> passedApiaries = new ArrayList<TileEntityApiary>();
    double slowAging = 1.0;
    double producing = 1.0;
    double speedCrop = 1.0;
    double speedBirthRate = 1.0;
    int chanceCrossing = 0;
    double chanceHealing = 1.0;
    int generation = 0;
    Genome genome;
    List<LevelChunk> chunks = new ArrayList<LevelChunk>();
    private AABB axisAlignedBB;
    private Vec3 center;
    private double maxDistance;
    private byte tickDrainFood = 0;
    private byte tickDrainJelly = 0;
    private Map<TileEntityApiary, Double> bees_nearby;
    private double coef;
    private ItemStack stack;
    private int weatherGenome = 0;
    private double pestGenome = 1.0;
    private double birthRateGenome = 1.0;
    private double radiusGenome = 1.0;
    private double populationGenome = 1.0;
    private double foodGenome = 1.0;
    private double jellyGenome = 1.0;
    private double productGenome = 1.0;
    private double hardeningGenome = 1.0;
    private double swarmGenome = 1.0;
    private double mortalityGenome = 1.0;
    private boolean sunGenome = false;
    private boolean nightGenome = false;
    private int genomeResistance = 0;
    private int genomeAdaptive = 0;
    private LevelPollution airPollution = LevelPollution.LOW;
    private LevelPollution soilPollution = LevelPollution.LOW;
    private EnumLevelRadiation radiationPollution = EnumLevelRadiation.LOW;

    public TileEntityApiary(BlockPos pos, BlockState state) {
        super(BlockApiary.apiary, pos, state);
        this.invSlotProduct = new InvSlotOutput(this, 7);
        this.invSlotFood = new InvSlotOutput(this, 1);
        this.invSlotJelly = new InvSlotOutput(this, 1);
        this.foodCellSlot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof ItemFluidCell;
            }
        };
        this.jellyCellSlot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof ItemFluidCell;
            }
        };
        this.frameSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 4){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof IFrameItem;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                this.update();
                return content;
            }

            @Override
            public void update() {
                this.reset();
                for (ItemStack stack : this.contents) {
                    if (stack.isEmpty()) continue;
                    IFrameItem frameItem = (IFrameItem)stack.getItem();
                    FrameAttributeLevel attributeLevel = frameItem.getAttribute(stack.getDamageValue());
                    switch (attributeLevel.getAttribute()) {
                        case STORAGE_FOOD: {
                            TileEntityApiary.this.maxFood = (short)((double)TileEntityApiary.this.maxDefaultFood * attributeLevel.getValue());
                        }
                        case STORAGE_JELLY: {
                            TileEntityApiary.this.maxJelly = (short)((double)TileEntityApiary.this.maxDefaultJelly * attributeLevel.getValue());
                        }
                        case PRODUCING: {
                            TileEntityApiary.this.producing *= attributeLevel.getValue();
                            break;
                        }
                        case SLOW_AGING: {
                            TileEntityApiary.this.slowAging *= attributeLevel.getValue();
                            break;
                        }
                        case SPEED_CROP: {
                            TileEntityApiary.this.speedCrop *= attributeLevel.getValue();
                            break;
                        }
                        case CHANCE_HEALING: {
                            TileEntityApiary.this.chanceHealing *= attributeLevel.getValue();
                            break;
                        }
                        case SPEED_BIRTH_RATE: {
                            TileEntityApiary.this.speedBirthRate *= attributeLevel.getValue();
                            break;
                        }
                        case CHANCE_CROSSING: {
                            TileEntityApiary.this.chanceCrossing = Math.max(TileEntityApiary.this.chanceCrossing, (int)attributeLevel.getValue());
                        }
                    }
                }
                if (TileEntityApiary.this.chanceHealing == 1.0) {
                    TileEntityApiary.this.chanceCrossing = 0;
                }
                if (TileEntityApiary.this.speedBirthRate == 1.0) {
                    TileEntityApiary.this.speedBirthRate = 0.0;
                }
                if (TileEntityApiary.this.speedCrop == 1.0) {
                    TileEntityApiary.this.speedCrop = 0.0;
                }
                if (TileEntityApiary.this.slowAging == 1.0) {
                    TileEntityApiary.this.slowAging = 0.0;
                }
                if (TileEntityApiary.this.producing == 1.0) {
                    TileEntityApiary.this.producing = 0.0;
                }
            }

            public void reset() {
                TileEntityApiary.this.slowAging = 1.0;
                TileEntityApiary.this.producing = 1.0;
                TileEntityApiary.this.maxFood = TileEntityApiary.this.maxDefaultFood;
                TileEntityApiary.this.maxJelly = TileEntityApiary.this.maxDefaultJelly;
                TileEntityApiary.this.speedCrop = 1.0;
                TileEntityApiary.this.speedBirthRate = 1.0;
                TileEntityApiary.this.chanceCrossing = 0;
                TileEntityApiary.this.chanceHealing = 1.0;
            }
        };
    }

    public boolean isWork() {
        return this.work;
    }

    @Override
    public IBee getQueen() {
        return this.queen;
    }

    @Override
    public int getChanceCrossing() {
        return this.queen != null ? this.queen.getChance() + this.chanceCrossing : 0;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.apiary.getBlock();
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockApiary.apiary;
    }

    public Map<Player, Double> getNearbyEntitiesWithWeight() {
        AABB axisAlignedBB = this.axisAlignedBB;
        List<Player> players = this.getEntitiesWithinAABB(axisAlignedBB);
        this.entityWeightMap.clear();
        for (Player player : players) {
            if (this.getComponentPrivate().getPlayers().contains(player.getName().getString()) || player.isCreative()) continue;
            double distance = this.center.distanceTo(player.position());
            double weight = this.calculateWeight(distance, this.maxDistance);
            this.entityWeightMap.put(player, weight);
        }
        return this.entityWeightMap;
    }

    public void set() {
        if (this.genome == null) {
            return;
        }
        if (this.genome.hasGenome(EnumGenetic.WEATHER)) {
            this.weatherGenome = this.genome.getLevelGenome(EnumGenetic.WEATHER, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PEST)) {
            this.pestGenome = this.genome.getLevelGenome(EnumGenetic.PEST, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.BIRTH)) {
            this.birthRateGenome = this.genome.getLevelGenome(EnumGenetic.BIRTH, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIUS)) {
            this.radiusGenome = this.genome.getLevelGenome(EnumGenetic.RADIUS, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.POPULATION)) {
            this.populationGenome = this.genome.getLevelGenome(EnumGenetic.POPULATION, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.FOOD)) {
            this.foodGenome = this.genome.getLevelGenome(EnumGenetic.FOOD, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.JELLY)) {
            this.jellyGenome = this.genome.getLevelGenome(EnumGenetic.JELLY, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PRODUCT)) {
            this.productGenome = this.genome.getLevelGenome(EnumGenetic.PRODUCT, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.HARDENING)) {
            this.hardeningGenome = this.genome.getLevelGenome(EnumGenetic.HARDENING, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SWARM)) {
            this.swarmGenome = this.genome.getLevelGenome(EnumGenetic.SWARM, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.MORTALITY_RATE)) {
            this.mortalityGenome = this.genome.getLevelGenome(EnumGenetic.MORTALITY_RATE, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SUN)) {
            this.sunGenome = this.genome.getLevelGenome(EnumGenetic.SUN, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.NIGHT)) {
            this.nightGenome = this.genome.getLevelGenome(EnumGenetic.NIGHT, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.AIR)) {
            this.airPollution = this.genome.getLevelGenome(EnumGenetic.AIR, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SOIL)) {
            this.soilPollution = this.genome.getLevelGenome(EnumGenetic.SOIL, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIATION)) {
            this.radiationPollution = this.genome.getLevelGenome(EnumGenetic.RADIATION, EnumLevelRadiation.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_RESISTANCE)) {
            this.genomeResistance = this.genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE)) {
            this.genomeAdaptive = this.genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class);
        }
    }

    public void reset() {
        this.weatherGenome = 0;
        this.pestGenome = 1.0;
        this.swarmGenome = 1.0;
        this.mortalityGenome = 1.0;
        this.birthRateGenome = 1.0;
        this.radiusGenome = 1.0;
        this.populationGenome = 1.0;
        this.foodGenome = 1.0;
        this.jellyGenome = 1.0;
        this.productGenome = 1.0;
        this.hardeningGenome = 1.0;
        this.sunGenome = false;
        this.nightGenome = false;
        this.genomeResistance = 0;
        this.genomeAdaptive = 0;
        this.airPollution = LevelPollution.LOW;
        this.soilPollution = LevelPollution.LOW;
        this.radiationPollution = EnumLevelRadiation.LOW;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        long packedData = customPacketBuffer.readLong();
        this.task = (int)(packedData & 0x7FL);
        this.workers = (int)(packedData >> 7 & 0x7FL);
        this.builders = (int)(packedData >> 14 & 0x7FL);
        this.attacks = (int)(packedData >> 21 & 0x7FL);
        this.bees = (int)(packedData >> 28 & 0x7FL);
        this.doctors = (int)(packedData >> 35 & 0x7FL);
        this.death = (int)(packedData >> 42 & 0x7FL);
        this.birth = (int)(packedData >> 49 & 0x7FL);
        this.ill = (int)(packedData >> 56 & 0x7FL);
        this.maxFood = customPacketBuffer.readShort();
        this.maxJelly = customPacketBuffer.readShort();
        this.food = customPacketBuffer.readDouble();
        this.royalJelly = customPacketBuffer.readDouble();
        this.deathTask = customPacketBuffer.readByte();
        this.illTask = customPacketBuffer.readByte();
        this.queen = BeeNetwork.instance.getBee(customPacketBuffer.readInt()).copy();
        int size = customPacketBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            double chance = customPacketBuffer.readDouble();
            ICrop crop = CropNetwork.instance.getCrop(customPacketBuffer.readInt());
            this.queen.addPercentProduct(crop, chance);
        }
        try {
            this.stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            this.genome = new Genome(this.stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer buffer = super.writeContainerPacket();
        long packedData = (long)this.task & 0x7FL | ((long)this.workers & 0x7FL) << 7 | ((long)this.builders & 0x7FL) << 14 | ((long)this.attacks & 0x7FL) << 21 | ((long)this.bees & 0x7FL) << 28 | ((long)this.doctors & 0x7FL) << 35 | ((long)this.death & 0x7FL) << 42 | ((long)this.birth & 0x7FL) << 49 | ((long)this.ill & 0x7FL) << 56;
        buffer.writeLong(packedData);
        buffer.writeShort(this.maxFood);
        buffer.writeShort(this.maxJelly);
        buffer.writeDouble(this.food);
        buffer.writeDouble(this.royalJelly);
        buffer.writeByte(this.deathTask);
        buffer.writeByte(this.illTask);
        if (this.queen != null) {
            buffer.writeInt(this.queen.getId());
        } else {
            buffer.writeInt(0);
        }
        buffer.writeInt(this.queen.getProduct().size());
        for (int i = 0; i < this.queen.getProduct().size(); ++i) {
            Product product = this.queen.getProduct().get(i);
            buffer.writeDouble(product.getChance());
            buffer.writeInt(product.getCrop().getId());
        }
        try {
            EncoderHandler.encode(buffer, this.stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.getWorld().isClientSide) {
            BeeNetwork.instance.removeApiaryFromWorld(this);
        }
    }

    public List<Player> getEntitiesWithinAABB(AABB aabb) {
        ArrayList list = Lists.newArrayList();
        ServerLevel server = (ServerLevel)this.level;
        for (Player player : server.players()) {
            if (!aabb.contains(player.position())) continue;
            list.add(player);
        }
        return list;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            BeeNetwork.instance.addNewApiaryToWorld(this);
            this.frameSlot.update();
            if (this.queen != null) {
                this.genome = new Genome(this.stack);
                this.chunk = this.getWorld().getChunkAt(this.pos);
                this.biome = (Biome)this.getWorld().getBiome(this.pos).value();
                this.reset();
                this.set();
                this.coef = this.queen.canWorkInBiome(this.biome, this.level) || this.genome.hasGenome(EnumGenetic.COEF_BIOME) ? 1.0 : 0.5;
                this.axisAlignedBB = new AABB((double)this.pos.getX() + this.queen.getSizeTerritory().minX * this.radiusGenome, (double)this.pos.getY() + this.queen.getSizeTerritory().minY * this.radiusGenome, (double)this.pos.getZ() + this.queen.getSizeTerritory().minZ * this.radiusGenome, (double)this.pos.getX() + this.queen.getSizeTerritory().maxX * this.radiusGenome, (double)this.pos.getY() + this.queen.getSizeTerritory().maxY * this.radiusGenome, (double)this.pos.getZ() + this.queen.getSizeTerritory().maxZ * this.radiusGenome);
                this.center = new Vec3((this.axisAlignedBB.minX + this.axisAlignedBB.maxX) / 2.0, (this.axisAlignedBB.minY + this.axisAlignedBB.maxY) / 2.0, (this.axisAlignedBB.minZ + this.axisAlignedBB.maxZ) / 2.0);
                AABB aabb = this.axisAlignedBB;
                int j2 = Mth.floor((double)((aabb.minX - 2.0) / 16.0));
                int k2 = Mth.ceil((double)((aabb.maxX + 2.0) / 16.0));
                int l2 = Mth.floor((double)((aabb.minZ - 2.0) / 16.0));
                int i3 = Mth.ceil((double)((aabb.maxZ + 2.0) / 16.0));
                for (int j3 = j2; j3 < k2; ++j3) {
                    for (int k3 = l2; k3 < i3; ++k3) {
                        LevelChunk chunk = this.level.getChunk(j3, k3);
                        if (this.chunks.contains(chunk)) continue;
                        this.chunks.add(chunk);
                    }
                }
                this.chunkPositions.clear();
                this.maxDistance = this.center.distanceTo(new Vec3(this.axisAlignedBB.maxX, this.axisAlignedBB.maxY, this.axisAlignedBB.maxZ));
                int minX = (int)Math.floor(this.axisAlignedBB.minX) >> 4;
                int maxX = (int)Math.floor(this.axisAlignedBB.maxX) >> 4;
                int minZ = (int)Math.floor(this.axisAlignedBB.minZ) >> 4;
                int maxZ = (int)Math.floor(this.axisAlignedBB.maxZ) >> 4;
                for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
                    for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                        this.chunkPositions.add(new ChunkPos(chunkX, chunkZ));
                    }
                }
            }
            this.chunkPos = new ChunkPos(this.pos);
            Radiation radiation1 = RadiationSystem.rad_system.getMap().get(this.chunkPos);
            if (radiation1 == null) {
                radiation1 = new Radiation(this.chunkPos);
                RadiationSystem.rad_system.addRadiation(radiation1);
            }
            this.radLevel = radiation1;
            ChunkLevel chunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(this.chunkPos);
            if (chunkLevel == null) {
                chunkLevel = new ChunkLevel(this.chunkPos, LevelPollution.VERY_LOW, 0.0);
                PollutionManager.pollutionManager.addChunkLevelSoil(chunkLevel);
            }
            for (ChunkPos chunkPos : this.chunkPositions) {
                this.chunkPosListMap.put(chunkPos, CropNetwork.instance.getCropsFromChunk(this.level, chunkPos));
            }
            for (ChunkPos chunkPos : this.chunkPositions) {
                this.chunkPosListMap1.put(chunkPos, BeeNetwork.instance.getApiaryFromChunk(this.level, chunkPos));
            }
            this.chunkLevel = chunkLevel;
            if (this.queen != null) {
                List<Product> products = this.queen.getProduct();
                this.queen = BeeNetwork.instance.getBee(this.queen.getId()).copy();
                this.coef = this.queen.canWorkInBiome(this.biome, this.level) ? 1.0 : 0.5;
                this.coef = this.genome.hasGenome(EnumGenetic.COEF_BIOME) ? 1.0 : this.coef;
                products.forEach(product -> this.queen.addPercentProduct(product.getCrop(), product.getChance()));
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.queen == null) {
            tooltip.add(Localization.translate("iu.use_bee"));
        }
    }

    private double calculateWeight(double distance, double maxDistance) {
        return Math.max(0.0, 1.0 - distance / maxDistance);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ItemJarBees && this.queen == null && !this.getWorld().isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.has(DataComponentsInit.SWARM)) {
                this.stack = stack.copy();
                this.stack.setCount(1);
                int id = (Integer)stack.getOrDefault(DataComponentsInit.BEE, (Object)0);
                this.id = WorldBaseGen.random.nextLong();
                this.queen = BeeNetwork.instance.getBee(id).copy();
                this.genome = new Genome(this.stack);
                this.biome = (Biome)this.getWorld().getBiome(this.pos).value();
                this.coef = this.queen.canWorkInBiome(this.biome, this.level) ? 1.0 : 0.5;
                this.reset();
                this.set();
                this.coef = this.genome.hasGenome(EnumGenetic.COEF_BIOME) ? 1.0 : this.coef;
                int totalBeeCount = (Integer)stack.get(DataComponentsInit.SWARM);
                if (!stack.has(DataComponentsInit.BEE_LIST)) {
                    Bee bee;
                    int i;
                    int attackBeeCount = (int)((double)totalBeeCount * 0.2);
                    int doctorBeeCount = (int)((double)totalBeeCount * 0.2);
                    int workersBeeCount = (int)((double)totalBeeCount * 0.45);
                    int buildersBeeCount = totalBeeCount - (attackBeeCount + doctorBeeCount + workersBeeCount);
                    for (i = 0; i < attackBeeCount; ++i) {
                        bee = new Bee(EnumTypeBee.ATTACK, this.queen, EnumTypeLife.BEE, 25.0, WorldBaseGen.random.nextInt(this.queen.getTickLifecycles() - this.queen.getTickBirthRate()) + this.queen.getTickBirthRate());
                        this.attackBeeList.add(bee);
                        this.apairyBeeList.add(bee);
                    }
                    for (i = 0; i < doctorBeeCount; ++i) {
                        bee = new Bee(EnumTypeBee.DOCTOR, this.queen, EnumTypeLife.BEE, 25.0, WorldBaseGen.random.nextInt(this.queen.getTickLifecycles() - this.queen.getTickBirthRate()) + this.queen.getTickBirthRate());
                        this.doctorBeeList.add(bee);
                        this.apairyBeeList.add(bee);
                    }
                    for (i = 0; i < workersBeeCount; ++i) {
                        bee = new Bee(EnumTypeBee.WORKER, this.queen, EnumTypeLife.BEE, 25.0, WorldBaseGen.random.nextInt(this.queen.getTickLifecycles() - this.queen.getTickBirthRate()) + this.queen.getTickBirthRate());
                        this.workersBeeList.add(bee);
                        this.apairyBeeList.add(bee);
                    }
                    for (i = 0; i < buildersBeeCount; ++i) {
                        bee = new Bee(EnumTypeBee.BUILDER, this.queen, EnumTypeLife.BEE, 25.0, WorldBaseGen.random.nextInt(this.queen.getTickLifecycles() - this.queen.getTickBirthRate()) + this.queen.getTickBirthRate());
                        this.buildersBeeList.add(bee);
                        this.apairyBeeList.add(bee);
                    }
                } else {
                    List list = (List)stack.get(DataComponentsInit.BEE_LIST);
                    for (Bee bee : list) {
                        if (bee.isIll()) {
                            this.illBeeList.add(bee);
                        }
                        if (bee.isChild()) {
                            this.birthBeeList.add(bee);
                        }
                        switch (bee.getTypeBee()) {
                            case BUILDER: {
                                this.buildersBeeList.add(bee);
                                break;
                            }
                            case DOCTOR: {
                                this.doctorBeeList.add(bee);
                                break;
                            }
                            case WORKER: {
                                this.workersBeeList.add(bee);
                                break;
                            }
                            case ATTACK: {
                                this.attackBeeList.add(bee);
                            }
                        }
                        this.apairyBeeList.add(bee);
                    }
                }
                this.axisAlignedBB = new AABB((double)this.pos.getX() + this.queen.getSizeTerritory().minX * this.radiusGenome, (double)this.pos.getY() + this.queen.getSizeTerritory().minY * this.radiusGenome, (double)this.pos.getZ() + this.queen.getSizeTerritory().minZ * this.radiusGenome, (double)this.pos.getX() + this.queen.getSizeTerritory().maxX * this.radiusGenome, (double)this.pos.getY() + this.queen.getSizeTerritory().maxY * this.radiusGenome, (double)this.pos.getZ() + this.queen.getSizeTerritory().maxZ * this.radiusGenome);
                this.center = new Vec3((this.axisAlignedBB.minX + this.axisAlignedBB.maxX) / 2.0, (this.axisAlignedBB.minY + this.axisAlignedBB.maxY) / 2.0, (this.axisAlignedBB.minZ + this.axisAlignedBB.maxZ) / 2.0);
                this.maxDistance = this.center.distanceTo(new Vec3(this.axisAlignedBB.maxX, this.axisAlignedBB.maxY, this.axisAlignedBB.maxZ));
                int minX = (int)Math.floor(this.axisAlignedBB.minX) >> 4;
                int maxX = (int)Math.floor(this.axisAlignedBB.maxX) >> 4;
                int minZ = (int)Math.floor(this.axisAlignedBB.minZ) >> 4;
                int maxZ = (int)Math.floor(this.axisAlignedBB.maxZ) >> 4;
                this.chunkPositions.clear();
                for (int chunkX = minX; chunkX <= maxX; ++chunkX) {
                    for (int chunkZ = minZ; chunkZ <= maxZ; ++chunkZ) {
                        this.chunkPositions.add(new ChunkPos(chunkX, chunkZ));
                    }
                }
                this.chunkPosListMap.clear();
                this.chunkPosListMap1.clear();
                for (ChunkPos chunkPos : this.chunkPositions) {
                    this.chunkPosListMap.put(chunkPos, CropNetwork.instance.getCropsFromChunk(this.level, chunkPos));
                }
                for (ChunkPos chunkPos : this.chunkPositions) {
                    this.chunkPosListMap1.put(chunkPos, BeeNetwork.instance.getApiaryFromChunk(this.level, chunkPos));
                }
                stack.shrink(1);
            }
        } else if (this.queen != null && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ItemNet && !this.getWorld().isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)IUItem.jarBees.getStack(0), 1);
            stack.set(DataComponentsInit.BEE, (Object)this.queen.getId());
            this.genome.writeNBT(stack);
            stack.set(DataComponentsInit.SWARM, (Object)this.apairyBeeList.size());
            stack.set(DataComponentsInit.BEE_LIST, new ArrayList<Bee>(this.apairyBeeList));
            player.addItem(stack);
            this.apairyBeeList.clear();
            this.queen = null;
            this.attackBeeList.clear();
            this.workersBeeList.clear();
            this.doctorBeeList.clear();
            this.buildersBeeList.clear();
            this.illBeeList.clear();
            this.birth = 0;
            this.death = 0;
            this.birthBeeList.clear();
        }
        if (this.queen != null) {
            return super.onActivated(player, hand, side, hitX);
        }
        return false;
    }

    public ContainerApiary getGuiContainer(Player var1) {
        return new ContainerApiary(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player var1, ContainerBase<?> var2) {
        return new GuiApiary((ContainerApiary)var2);
    }

    public void feedBees(List<Bee> beeList) {
        double totalRequiredFood = 0.0;
        for (Bee bee : beeList) {
            totalRequiredFood += 25.0 - bee.getFood();
        }
        if (totalRequiredFood > 0.0) {
            if (this.food >= totalRequiredFood) {
                for (Bee bee : beeList) {
                    double add = 25.0 - bee.getFood();
                    bee.addFood(add);
                    this.food -= add;
                }
            } else {
                double equalFoodShare = this.food / (double)beeList.size();
                for (Bee bee : beeList) {
                    bee.addFood(equalFoodShare);
                }
                this.food = 0.0;
            }
        }
        double totalRequiredJelly = 0.0;
        for (Bee bee : this.birthBeeList) {
            totalRequiredJelly += 2.0 - bee.getJelly();
        }
        if (this.royalJelly >= totalRequiredJelly) {
            for (Bee bee : this.birthBeeList) {
                double add = 2.0 - bee.getJelly();
                bee.addJelly(add);
                this.royalJelly -= add;
            }
        } else {
            double equalFoodShare = this.royalJelly / (double)this.birthBeeList.size();
            for (Bee bee : this.birthBeeList) {
                bee.addJelly(equalFoodShare);
            }
        }
    }

    public void healBees() {
        if (this.illBeeList.isEmpty()) {
            return;
        }
        this.illBeeList.sort(Comparator.comparingInt(bee -> bee.getTypeBee().ordinal()));
        ArrayList<Bee> recoveryList = new ArrayList<Bee>();
        block0: for (Bee bee2 : this.doctorBeeList) {
            if (bee2.isIll() || bee2.isDead()) continue;
            for (Bee illBee : this.illBeeList) {
                if (!illBee.isIll()) continue;
                if (!(this.royalJelly >= 0.1)) continue block0;
                this.royalJelly -= 0.1;
                if (!(WorldBaseGen.random.nextDouble() < 0.25 + this.chanceHealing)) continue;
                illBee.setIll(false);
                recoveryList.add(illBee);
            }
        }
        this.illBeeList.removeAll(recoveryList);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        ListTag tagList;
        nbt = super.writeToNBT(nbt);
        if (this.queen != null) {
            tagList = new ListTag();
            for (Bee bee : this.apairyBeeList) {
                tagList.add((Object)bee.writeToNBT());
            }
            nbt.putByte("bee_id", (byte)this.queen.getId());
            nbt.put("bees", (Tag)tagList);
            nbt.putLong("id_queen", this.id);
            if (this.stack != null) {
                nbt.put("stack", this.stack.save(this.provider));
            }
            ListTag listTag = new ListTag();
            for (Product product : this.queen.getProduct()) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.putDouble("chance", product.getChance());
                compoundTag.putInt("id", product.getCrop().getId());
                listTag.add((Object)compoundTag);
            }
            nbt.put("product", (Tag)listTag);
        }
        nbt.putShort("royalJelly", (short)(this.royalJelly * 10.0));
        nbt.putShort("food", (short)(this.food * 10.0));
        nbt.putByte("harvest", (byte)this.harvest);
        nbt.putInt("birth", this.birth);
        nbt.putInt("generation", this.generation);
        nbt.putInt("death", this.death);
        tagList = new ListTag();
        this.statusMap.forEach((id, status) -> {
            CompoundTag nbt1 = new CompoundTag();
            nbt1.putLong("id", id.longValue());
            nbt1.putByte("status", (byte)status.ordinal());
        });
        nbt.put("status", (Tag)tagList);
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        if (nbt.contains("bees")) {
            byte beeId = nbt.getByte("bee_id");
            this.id = nbt.getLong("id_queen");
            this.queen = BeeNetwork.instance.getBee(beeId).copy();
            ListTag listTag = nbt.getList("product", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.getCompound(i);
                double chance = compoundTag.getDouble("chance");
                int id = compoundTag.getInt("id");
                ICrop crop = CropNetwork.instance.getCrop(id);
                if (crop == null) continue;
                this.queen.addPercentProduct(crop, chance);
            }
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)this.provider, (CompoundTag)nbt.getCompound("stack"));
            ListTag tagList = nbt.getList("bees", 10);
            this.apairyBeeList.clear();
            block7: for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag beeTag = tagList.getCompound(i);
                Bee bee = new Bee(beeTag);
                this.apairyBeeList.add(bee);
                if (bee.isIll()) {
                    this.illBeeList.add(bee);
                }
                if (bee.isChild()) {
                    this.birthBeeList.add(bee);
                }
                switch (bee.getTypeBee()) {
                    case BUILDER: {
                        this.buildersBeeList.add(bee);
                        continue block7;
                    }
                    case WORKER: {
                        this.workersBeeList.add(bee);
                        continue block7;
                    }
                    case DOCTOR: {
                        this.doctorBeeList.add(bee);
                        continue block7;
                    }
                    case ATTACK: {
                        this.attackBeeList.add(bee);
                    }
                }
            }
        }
        this.statusMap.clear();
        ListTag tagList = nbt.getList("status", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbt1 = tagList.getCompound(i);
            long id = nbt1.getLong("id");
            byte statusOrdinal = nbt1.getByte("status");
            EnumStatus status = EnumStatus.values()[statusOrdinal];
            this.statusMap.put(id, status);
        }
        this.royalJelly = (double)nbt.getShort("royalJelly") / 10.0;
        this.food = (double)nbt.getShort("food") / 10.0;
        this.harvest = nbt.getByte("harvest");
        this.birth = nbt.getInt("birth");
        this.death = nbt.getInt("death");
        this.generation = nbt.getInt("generation");
    }

    public void death(Bee bee) {
        ++this.death;
        this.deathTask = 1;
        switch (bee.getTypeBee()) {
            case ATTACK: {
                this.attackBeeList.remove(bee);
                break;
            }
            case DOCTOR: {
                this.doctorBeeList.remove(bee);
                break;
            }
            case WORKER: {
                this.workersBeeList.remove(bee);
                break;
            }
            case BUILDER: {
                this.buildersBeeList.remove(bee);
            }
        }
        this.illBeeList.remove(bee);
        if (bee.getType() == EnumTypeLife.LARVA) {
            this.birthBeeList.remove(bee);
        }
        this.apairyBeeList.remove(bee);
    }

    public byte getTickDrainFood() {
        return this.tickDrainFood;
    }

    public void setTickDrainFood(byte tickDrainFood) {
        this.tickDrainFood = tickDrainFood;
    }

    public byte getTickDrainJelly() {
        return this.tickDrainJelly;
    }

    public void setTickDrainJelly(byte tickDrainJelly) {
        this.tickDrainJelly = tickDrainJelly;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean day = this.getWorld().isDay();
        if (!this.apairyBeeList.isEmpty() && this.getWorld().getGameTime() % 20L == 0L && this.queen != null && (day && (this.queen.isSun() || this.sunGenome) || !day && (this.queen.isNight() || this.nightGenome))) {
            boolean needChangeBuilders;
            for (int i = 0; i < this.frameSlot.size(); ++i) {
                ItemStack stack = this.frameSlot.get(i);
                if (stack.isEmpty() || !((IDamageItem)stack.getItem()).applyCustomDamage(stack, -20, null)) continue;
                this.frameSlot.set(i, ItemStack.EMPTY);
            }
            if (this.getWorld().getGameTime() % 3600L == 0L) {
                ++this.generation;
                this.canAdaptationBee();
            }
            this.rain = this.level.isRaining();
            this.thundering = this.level.isThundering();
            this.feedBees(this.apairyBeeList);
            if (this.food > (double)this.maxFood) {
                this.food = this.maxFood;
            }
            if (this.royalJelly > (double)this.maxJelly) {
                this.royalJelly = this.maxJelly;
            }
            if (this.royalJelly < 0.0) {
                this.royalJelly = 0.0;
            }
            ParticleUtils.spawnApiaryParticles(this.level, this.pos, this.level.random);
            this.massiveNeeds[0] = this.food / ((double)this.maxFood * 1.0);
            this.massiveNeeds[1] = (double)this.apairyBeeList.size() * 1.0 / ((double)this.queen.getMaxSwarm() * this.swarmGenome);
            this.enemy = this.getNearbyEntitiesWithWeight();
            this.problemList.clear();
            double maxValue = this.enemy.values().stream().max(Double::compareTo).orElse(0.0);
            this.bees_nearby = this.getNearbyBees();
            this.massiveNeeds[2] = maxValue = Math.max(this.bees_nearby.values().stream().max(Double::compareTo).orElse(0.0), maxValue);
            this.massiveNeeds[3] = (double)this.illBeeList.size() * 1.0 / (double)(this.apairyBeeList.size() - this.birthBeeList.size());
            this.massiveNeeds[4] = this.royalJelly / ((double)this.maxJelly * 1.0);
            this.task = beeAI.predict(this.massiveNeeds);
            this.workers = this.workersBeeList.size();
            this.builders = this.buildersBeeList.size();
            this.bees = this.apairyBeeList.size();
            this.attacks = this.attackBeeList.size();
            this.doctors = this.doctorBeeList.size();
            this.ill = this.illBeeList.size();
            this.deathTask = 0;
            this.illTask = 0;
            switch (this.task) {
                case 0: {
                    this.queen.removeAllPercent(0.5);
                    this.harvest();
                    if (this.tickDrainJelly > 20) {
                        this.tickDrainJelly = (byte)20;
                    }
                    if (this.tickDrainFood <= 20) break;
                    this.tickDrainFood = (byte)20;
                    break;
                }
                case 1: {
                    this.attackPlayers(this.enemy);
                    this.attackBees();
                    break;
                }
                case 2: {
                    this.healBees();
                    break;
                }
                case 3: {
                    this.birthBees();
                    break;
                }
                case 4: {
                    this.canHelpOtherBees();
                }
            }
            this.problemList.clear();
            if (this.massiveNeeds[0] < 0.3) {
                this.problemList.add(EnumProblem.FOOD);
            }
            if (this.massiveNeeds[1] < 0.3) {
                this.problemList.add(EnumProblem.BEES);
            }
            if (this.massiveNeeds[3] > 0.15) {
                this.problemList.add(EnumProblem.ILL);
            }
            if (this.massiveNeeds[4] < 0.3) {
                this.problemList.add(EnumProblem.JELLY);
            }
            ArrayList<Bee> iterator = new ArrayList<Bee>(this.apairyBeeList);
            ChunkLevel airPollution = PollutionManager.pollutionManager.getChunkLevelAir(this.chunkPos);
            int totalBees = this.apairyBeeList.size() - this.birthBeeList.size();
            int targetWorkers = (int)((double)totalBees * 0.45);
            int targetDoctors = (int)((double)totalBees * 0.2);
            int targetAttackers = (int)((double)totalBees * 0.2);
            int targetBuilders = (int)((double)totalBees * 0.15);
            boolean canChangeWork = targetWorkers > this.workers || targetDoctors > this.doctors || targetAttackers > this.attacks || targetBuilders > this.builders;
            boolean needChangeWorkers = targetWorkers < this.workers;
            boolean needChangeDoctors = targetDoctors < this.doctors;
            boolean needChangeAttacks = targetAttackers < this.attacks;
            boolean bl = needChangeBuilders = targetBuilders < this.builders;
            EnumTypeBee typeBee = needChangeWorkers ? EnumTypeBee.WORKER : (needChangeDoctors ? EnumTypeBee.DOCTOR : (needChangeAttacks ? EnumTypeBee.ATTACK : (needChangeBuilders ? EnumTypeBee.BUILDER : EnumTypeBee.NONE)));
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Bee bee;
                boolean isChild = (bee = (Bee)iterator2.next()).isChild();
                bee.addTick((int)(20.0 + (isChild ? this.speedBirthRate * 20.0 : -20.0 * this.slowAging)), this.populationGenome);
                if (bee.isDead()) {
                    this.death(bee);
                    continue;
                }
                bee.removeFood();
                if (bee.getType() == EnumTypeLife.LARVA) {
                    bee.removeJelly();
                }
                if (bee.isIll() && this.royalJelly >= 0.5) {
                    if (WorldBaseGen.random.nextInt(100) == 0) {
                        this.royalJelly -= 0.5;
                        bee.setIll(false);
                        this.illBeeList.remove(bee);
                    } else {
                        this.royalJelly -= 0.05;
                        if (WorldBaseGen.random.nextDouble() < 0.25 && WorldBaseGen.random.nextDouble() < this.queen.getMaxMortalityRate() * this.mortalityGenome) {
                            bee.setDead(true);
                            this.death(bee);
                            continue;
                        }
                    }
                } else if (WorldBaseGen.random.nextDouble() < 0.1 && WorldBaseGen.random.nextDouble() <= this.queen.getMaxMortalityRate() * this.mortalityGenome) {
                    bee.setDead(true);
                    this.death(bee);
                    continue;
                }
                if (!bee.isChild() && isChild && !bee.isDead()) {
                    this.birthBeeList.remove(bee);
                    this.findWork(bee);
                }
                if (!bee.isChild() && bee.getTypeBee() == typeBee && canChangeWork && WorldBaseGen.random.nextInt(4) == 0) {
                    switch (typeBee) {
                        case ATTACK: {
                            this.attackBeeList.remove(bee);
                            break;
                        }
                        case DOCTOR: {
                            this.doctorBeeList.remove(bee);
                            break;
                        }
                        case WORKER: {
                            this.workersBeeList.remove(bee);
                            break;
                        }
                        case BUILDER: {
                            this.buildersBeeList.remove(bee);
                        }
                    }
                    if (targetWorkers > this.workers) {
                        this.workersBeeList.add(bee);
                        bee.setTypeBee(EnumTypeBee.WORKER);
                    } else if (targetBuilders > this.builders) {
                        this.buildersBeeList.add(bee);
                        bee.setTypeBee(EnumTypeBee.BUILDER);
                    } else if (targetDoctors > this.doctors) {
                        this.doctorBeeList.add(bee);
                        bee.setTypeBee(EnumTypeBee.DOCTOR);
                    } else if (targetAttackers > this.attacks) {
                        this.attackBeeList.add(bee);
                        bee.setTypeBee(EnumTypeBee.ATTACK);
                    }
                    totalBees = this.apairyBeeList.size() - this.birthBeeList.size() + 1;
                    targetWorkers = (int)((double)totalBees * 0.45);
                    targetDoctors = (int)((double)totalBees * 0.2);
                    targetAttackers = (int)((double)totalBees * 0.2);
                    targetBuilders = (int)((double)totalBees * 0.15);
                    boolean bl2 = canChangeWork = targetWorkers > this.workers || targetDoctors > this.doctors || targetAttackers > this.attacks || targetBuilders > this.builders;
                }
                if (bee.isChild() || bee.isIll()) continue;
                int illnessChance = 5 - (bee.getTypeBee() == EnumTypeBee.DOCTOR ? 2 : 0) + (this.chunkLevel.getLevelPollution().ordinal() > this.soilPollution.ordinal() ? 3 * (this.chunkLevel.getLevelPollution().ordinal() - this.soilPollution.ordinal()) : 0);
                if (airPollution != null && airPollution.getLevelPollution().ordinal() > this.airPollution.ordinal()) {
                    illnessChance += 4 * (airPollution.getLevelPollution().ordinal() - this.airPollution.ordinal());
                }
                if (bee.getTypeBee() == EnumTypeBee.DOCTOR) {
                    illnessChance = (int)((double)illnessChance * 0.5);
                }
                if ((double)WorldBaseGen.random.nextInt(1500) < (double)illnessChance * this.hardeningGenome) {
                    bee.setIll(true);
                    this.illTask = 1;
                    this.illBeeList.add(bee);
                }
                if (this.radLevel.getLevel().ordinal() <= this.radiationPollution.ordinal() || WorldBaseGen.random.nextInt(100) >= (this.radLevel.getLevel().ordinal() - this.radiationPollution.ordinal()) * 25) continue;
                bee.setDead(true);
                this.death(bee);
            }
            if (this.apairyBeeList.isEmpty()) {
                this.queen = null;
            }
        } else {
            this.task = 4;
            this.deathTask = 0;
            this.illTask = 0;
            this.workers = this.workersBeeList.size();
            this.builders = this.buildersBeeList.size();
            this.bees = this.apairyBeeList.size();
            this.attacks = this.attackBeeList.size();
            this.doctors = this.doctorBeeList.size();
            this.ill = this.illBeeList.size();
        }
        if (!this.foodCellSlot.isEmpty() && this.tickDrainFood == 20 && this.food > 500.0) {
            this.tickDrainFood = 0;
            this.foodCellSlot.get(0).shrink(1);
            this.invSlotFood.add(ModUtils.getCellFromFluid((Fluid)FluidName.fluidhoney.getInstance().get()));
            this.food -= 500.0;
        }
        if (!this.jellyCellSlot.isEmpty() && this.tickDrainJelly == 20 && this.royalJelly > 50.0) {
            this.tickDrainJelly = 0;
            this.jellyCellSlot.get(0).shrink(1);
            this.invSlotJelly.add(ModUtils.getCellFromFluid((Fluid)FluidName.fluidroyaljelly.getInstance().get()));
            this.royalJelly -= 50.0;
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer packetBuffer) {
        super.readPacket(packetBuffer);
        boolean hasQueen = packetBuffer.readBoolean();
        if (hasQueen) {
            this.queen = BeeNetwork.instance.getBee(packetBuffer.readInt());
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writeUpdatePacket();
        customPacketBuffer.writeBoolean(this.queen != null);
        if (this.queen != null) {
            customPacketBuffer.writeInt(this.queen.getId());
        }
        return customPacketBuffer;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer customPacketBuffer = super.writeUpdatePacket();
        customPacketBuffer.writeBoolean(this.queen != null);
        if (this.queen != null) {
            customPacketBuffer.writeInt(this.queen.getId());
        }
        return customPacketBuffer;
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
        boolean hasQueen = packetBuffer.readBoolean();
        if (hasQueen) {
            this.queen = BeeNetwork.instance.getBee(packetBuffer.readInt());
        }
    }

    private void canAdaptationBee() {
        if (WorldBaseGen.random.nextInt(100) >= this.queen.getChance()) {
            return;
        }
        Genome genome = this.genome;
        int geneticAdaptive = this.genomeAdaptive != 0 ? this.genomeAdaptive : 5;
        int geneticResistance = this.genomeResistance != 0 ? this.genomeResistance : 5;
        block9: for (EnumGenetic enumGenetic : EnumGenetic.values()) {
            boolean canUpgrade;
            List<GeneticTraits> genetic = GeneticsManager.enumGeneticListMap.get((Object)enumGenetic);
            if (WorldBaseGen.random.nextInt(100) > geneticAdaptive || WorldBaseGen.random.nextInt(100) <= geneticResistance) continue;
            boolean hasGenome = genome.hasGenome(enumGenetic);
            if (!hasGenome && WorldBaseGen.random.nextInt(100) == 0) {
                GeneticTraits geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                genome.addGenome(geneticTraits, this.stack);
                continue;
            }
            boolean needRemove = WorldBaseGen.random.nextInt(geneticResistance) > WorldBaseGen.random.nextInt(geneticAdaptive);
            boolean bl = canUpgrade = WorldBaseGen.random.nextInt(geneticAdaptive) > WorldBaseGen.random.nextInt(geneticResistance);
            if ((needRemove || !canUpgrade) && hasGenome) {
                genome.removeGenome(enumGenetic, this.stack);
                continue;
            }
            if (!canUpgrade) continue;
            switch (enumGenetic) {
                case SUN: {
                    if (hasGenome || this.queen.isSun()) break block9;
                    genome.addGenome(genetic.get(0), this.stack);
                    break block9;
                }
                case NIGHT: {
                    if (hasGenome || this.queen.isNight()) break block9;
                    genome.addGenome(genetic.get(0), this.stack);
                    break block9;
                }
                case COEF_BIOME: {
                    boolean canWork = this.queen.canWorkInBiome(this.biome, this.level);
                    if (!hasGenome) {
                        if (canWork || WorldBaseGen.random.nextInt(4) != 0) break block9;
                        genome.addGenome(genetic.get(0), this.stack);
                        break block9;
                    }
                    if (!canWork || WorldBaseGen.random.nextInt(4) != 0) break block9;
                    genome.removeGenome(genetic.get(0), this.stack);
                    break block9;
                }
                case AIR: {
                    if (!hasGenome) {
                        GeneticTraits geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        genome.addGenome(geneticTraits, this.stack);
                        break block9;
                    }
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.stack);
                            genome.addGenome(traits.getPrev(), this.stack);
                            break block9;
                        }
                        genome.removeGenome(traits, this.stack);
                        break block9;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block9;
                    genome.removeGenome(traits, this.stack);
                    genome.addGenome(traits1, this.stack);
                    break block9;
                }
                case SOIL: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        GeneticTraits geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        LevelPollution levelPollution = geneticTraits.getValue(LevelPollution.class);
                        if (levelPollution.ordinal() < this.chunkLevel.getLevelPollution().ordinal()) break block9;
                        genome.addGenome(geneticTraits, this.stack);
                        break block9;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    LevelPollution levelPollution = traits.getValue(LevelPollution.class);
                    boolean bl2 = needDecrease = WorldBaseGen.random.nextBoolean() && this.chunkLevel.getLevelPollution().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.stack);
                            genome.addGenome(traits.getPrev(), this.stack);
                            break block9;
                        }
                        genome.removeGenome(traits, this.stack);
                        break block9;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block9;
                    genome.removeGenome(traits, this.stack);
                    genome.addGenome(traits1, this.stack);
                    break block9;
                }
                case PEST: 
                case MORTALITY_RATE: 
                case FOOD: 
                case JELLY: 
                case PRODUCT: 
                case HARDENING: 
                case POPULATION: 
                case BIRTH: 
                case GENOME_ADAPTIVE: 
                case GENOME_RESISTANCE: 
                case SWARM: 
                case RADIUS: 
                case WEATHER: {
                    if (!hasGenome) {
                        GeneticTraits geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        genome.addGenome(geneticTraits, this.stack);
                        break block9;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    boolean needDecrease = WorldBaseGen.random.nextBoolean();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.stack);
                            genome.addGenome(traits.getPrev(), this.stack);
                            break block9;
                        }
                        genome.removeGenome(traits, this.stack);
                        break block9;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block9;
                    genome.removeGenome(traits, this.stack);
                    genome.addGenome(traits1, this.stack);
                    break block9;
                }
                case RADIATION: {
                    boolean needDecrease;
                    if (!hasGenome) {
                        GeneticTraits geneticTraits = genetic.get(WorldBaseGen.random.nextInt(genetic.size()));
                        EnumLevelRadiation levelPollution = geneticTraits.getValue(EnumLevelRadiation.class);
                        if (levelPollution.ordinal() < this.radLevel.getLevel().ordinal()) break block9;
                        genome.addGenome(geneticTraits, this.stack);
                        break block9;
                    }
                    GeneticTraits traits = genome.getGenome(enumGenetic);
                    EnumLevelRadiation levelPollution = traits.getValue(EnumLevelRadiation.class);
                    boolean bl3 = needDecrease = WorldBaseGen.random.nextBoolean() && this.radLevel.getLevel().ordinal() < levelPollution.ordinal();
                    if (needDecrease) {
                        if (traits.getPrev() != null) {
                            genome.removeGenome(traits, this.stack);
                            genome.addGenome(traits.getPrev(), this.stack);
                            break block9;
                        }
                        genome.removeGenome(traits, this.stack);
                        break block9;
                    }
                    GeneticTraits traits1 = GeneticsManager.geneticTraitsMap.get((Object)traits);
                    if (traits1 == null) break block9;
                    genome.removeGenome(traits, this.stack);
                    genome.addGenome(traits1, this.stack);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        this.reset();
        this.set();
    }

    private void lootApiary(TileEntityApiary apiary) {
        double foodAmount = apiary.food;
        double loot = foodAmount * (0.3 + WorldBaseGen.random.nextDouble() * 0.2);
        this.food += loot;
        apiary.food -= loot;
        if (WorldBaseGen.random.nextDouble() < 0.5) {
            double royalJellyAmount = apiary.royalJelly;
            double loot1 = royalJellyAmount * (0.2 + WorldBaseGen.random.nextDouble() * 0.15);
            this.royalJelly += loot1;
            apiary.royalJelly -= loot1;
        }
    }

    private void attackBees() {
        for (TileEntityApiary apiary : this.bees_nearby.keySet()) {
            EnumStatus status = this.getStatusMap().get(apiary.id);
            EnumStatus status1 = apiary.statusMap.get(this.id);
            double value = this.bees_nearby.get(apiary);
            if (!(value > 0.5) || status != EnumStatus.ANGRY && status1 != EnumStatus.ANGRY) continue;
            List<Bee> attack = this.attackBeeList;
            List<Bee> defenderApiary = apiary.attackBeeList;
            boolean defenseWon = this.performBattle(attack, defenderApiary);
            if (defenseWon) break;
            this.lootApiary(apiary);
            break;
        }
    }

    private boolean performBattle(List<Bee> attackers, List<Bee> defenders) {
        int defenderPower;
        int attackerPower = attackers.size();
        if (attackerPower > (defenderPower = defenders.size())) {
            for (Bee defender : defenders) {
                if (!(WorldBaseGen.random.nextDouble() < 0.5)) continue;
                defender.setDead(true);
            }
            return false;
        }
        for (Bee attacker : attackers) {
            if (!(WorldBaseGen.random.nextDouble() < 0.3)) continue;
            attacker.setDead(true);
        }
        return true;
    }

    private void canHelpOtherBees() {
        boolean helped = false;
        block12: for (TileEntityApiary apiary : this.bees_nearby.keySet()) {
            EnumStatus status = this.getStatusMap().get(apiary.id);
            EnumStatus status1 = apiary.statusMap.get(this.id);
            if (status == EnumStatus.ANGRY || status1 == EnumStatus.ANGRY) continue;
            List<EnumProblem> problems = apiary.problemList;
            if ((status != EnumStatus.NORMAL || !WorldBaseGen.random.nextBoolean()) && status != EnumStatus.FRIENDLY) continue;
            block13: for (EnumProblem problem : problems) {
                if (helped) break block12;
                switch (problem) {
                    case FOOD: {
                        double weight = this.massiveNeeds[0] - (0.3 - apiary.massiveNeeds[0]) - 0.3;
                        if (!(weight >= 0.01)) break;
                        double canFood = 1000.0 * weight;
                        this.food -= canFood;
                        apiary.food += canFood;
                        helped = true;
                        if (status1 != EnumStatus.NORMAL || !(WorldBaseGen.random.nextDouble() < 0.25)) continue block13;
                        apiary.statusMap.replace(this.id, EnumStatus.FRIENDLY);
                        break;
                    }
                    case JELLY: {
                        double weight = this.massiveNeeds[4] - (0.3 - apiary.massiveNeeds[4]) - 0.3;
                        if (!(weight >= 0.01)) break;
                        double canFood = 200.0 * weight;
                        this.royalJelly -= canFood;
                        apiary.royalJelly += canFood;
                        helped = true;
                        if (status1 != EnumStatus.NORMAL || !(WorldBaseGen.random.nextDouble() < 0.25)) continue block13;
                        apiary.statusMap.replace(this.id, EnumStatus.FRIENDLY);
                        break;
                    }
                    case ILL: {
                        apiary.illBeeList.sort(Comparator.comparingInt(bee -> bee.getTypeBee().ordinal()));
                        ArrayList<Bee> recoveryList = new ArrayList<Bee>();
                        block14: for (Bee bee2 : this.doctorBeeList) {
                            if (bee2.isIll() || bee2.isDead()) continue;
                            for (Bee illBee : apiary.illBeeList) {
                                if (!illBee.isIll()) continue;
                                if (!(this.royalJelly >= 0.1)) continue block14;
                                this.royalJelly -= 0.1;
                                if (!(WorldBaseGen.random.nextDouble() < 0.25 + this.chanceHealing)) continue;
                                illBee.setIll(false);
                                recoveryList.add(illBee);
                            }
                        }
                        if (status1 == EnumStatus.NORMAL && WorldBaseGen.random.nextDouble() < 0.25) {
                            apiary.statusMap.replace(this.id, EnumStatus.FRIENDLY);
                        }
                        apiary.illBeeList.removeAll(recoveryList);
                        break;
                    }
                    case BEES: {
                        double weight = this.massiveNeeds[3] - (0.3 - apiary.massiveNeeds[3]) - 0.3;
                        if (!(weight >= 0.01)) break;
                        int col = (int)(weight * (double)this.apairyBeeList.size());
                        for (int i = 0; i < col; ++i) {
                            Bee bee3 = this.apairyBeeList.get(WorldBaseGen.random.nextInt(this.apairyBeeList.size()));
                            while (bee3.isChild()) {
                                bee3 = this.apairyBeeList.get(WorldBaseGen.random.nextInt(this.apairyBeeList.size()));
                            }
                            switch (bee3.getTypeBee()) {
                                case BUILDER: {
                                    this.buildersBeeList.remove(bee3);
                                    apiary.buildersBeeList.add(bee3);
                                    break;
                                }
                                case WORKER: {
                                    this.workersBeeList.remove(bee3);
                                    apiary.workersBeeList.add(bee3);
                                    break;
                                }
                                case DOCTOR: {
                                    this.doctorBeeList.remove(bee3);
                                    apiary.doctorBeeList.add(bee3);
                                    break;
                                }
                                case ATTACK: {
                                    this.attackBeeList.remove(bee3);
                                    apiary.attackBeeList.add(bee3);
                                }
                            }
                            helped = true;
                            this.apairyBeeList.remove(bee3);
                            apiary.apairyBeeList.add(bee3);
                            if (status1 != EnumStatus.NORMAL) continue;
                            apiary.statusMap.replace(this.id, EnumStatus.FRIENDLY);
                        }
                        break;
                    }
                }
            }
            if (!helped) continue;
            break;
        }
    }

    public Map<Long, EnumStatus> getStatusMap() {
        return this.statusMap;
    }

    public long getId() {
        return this.id;
    }

    private Map<TileEntityApiary, Double> getNearbyBees() {
        this.apiaries.clear();
        this.passedApiaries.clear();
        for (ChunkPos chunkPos : this.chunkPositions) {
            this.apiaries.addAll((Collection<TileEntityApiary>)this.chunkPosListMap1.get(chunkPos));
        }
        HashMap<TileEntityApiary, Double> map = new HashMap<TileEntityApiary, Double>();
        this.apiaries = this.apiaries.stream().filter(apiary -> apiary.getQueen() != null && this.contains(apiary.pos) && apiary.id != this.id).collect(Collectors.toList());
        for (TileEntityApiary apiary2 : this.apiaries) {
            EnumStatus status1;
            Map<Long, EnumStatus> statusMap1 = apiary2.getStatusMap();
            EnumStatus status = this.getStatusMap().get(apiary2.id);
            if (status == null) {
                status = EnumStatus.NORMAL;
                if (this.queen.getUnCompatibleBees().contains(apiary2.queen)) {
                    status = EnumStatus.ANGRY;
                }
                this.statusMap.put(apiary2.id, status);
            }
            if ((status1 = statusMap1.computeIfAbsent(this.id, k -> {
                if (apiary.queen.getUnCompatibleBees().contains(this.queen)) {
                    return EnumStatus.ANGRY;
                }
                return EnumStatus.NORMAL;
            })) != EnumStatus.ANGRY && status != EnumStatus.ANGRY) {
                map.put(apiary2, 0.0);
                continue;
            }
            double distance = this.distanceTo(this.center, apiary2.getPos());
            double weight = this.calculateWeight(distance, this.maxDistance);
            map.put(apiary2, weight);
        }
        return map;
    }

    public double distanceTo(Vec3 vec, BlockPos pos) {
        double d0 = (double)pos.getX() - vec.x;
        double d1 = (double)pos.getY() - vec.y;
        double d2 = (double)pos.getZ() - vec.z;
        return Mth.sqrt((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    private void findWork(Bee bee) {
        int totalBees = this.apairyBeeList.size() - this.birthBeeList.size();
        double targetWorkers = Math.ceil((double)totalBees * 0.45);
        double targetDoctors = Math.ceil((double)totalBees * 0.2);
        double targetAttackers = Math.ceil((double)totalBees * 0.2);
        double targetBuilders = Math.ceil((double)totalBees * 0.15);
        if (targetWorkers > (double)this.workersBeeList.size()) {
            bee.setTypeBee(EnumTypeBee.WORKER);
            bee.setType(EnumTypeLife.BEE);
            this.workersBeeList.add(bee);
        } else if (targetDoctors > (double)this.doctorBeeList.size()) {
            bee.setTypeBee(EnumTypeBee.DOCTOR);
            bee.setType(EnumTypeLife.BEE);
            this.doctorBeeList.add(bee);
        } else if (targetBuilders > (double)this.buildersBeeList.size()) {
            bee.setTypeBee(EnumTypeBee.BUILDER);
            bee.setType(EnumTypeLife.BEE);
            this.buildersBeeList.add(bee);
        } else if (targetAttackers > (double)this.attackBeeList.size()) {
            bee.setTypeBee(EnumTypeBee.ATTACK);
            bee.setType(EnumTypeLife.BEE);
            this.attackBeeList.add(bee);
        } else {
            bee.setDead(true);
            this.death(bee);
        }
    }

    private void birthBees() {
        for (Bee bee : this.workersBeeList) {
            if (bee.isIll() || bee.isDead()) continue;
            for (int i = 0; i < WorldBaseGen.random.nextInt((int)((double)this.queen.getOffspring() * this.birthRateGenome)); ++i) {
                if (!((double)this.apairyBeeList.size() < (double)this.queen.getMaxSwarm() * this.swarmGenome) || !(this.royalJelly >= 0.2) || !(this.food >= 2.0)) continue;
                Bee bee1 = new Bee(EnumTypeBee.NONE, this.queen, EnumTypeLife.LARVA, 2.0, 0);
                bee1.addJelly(0.2);
                this.royalJelly -= 0.2;
                this.food -= 2.0;
                this.birthBeeList.add(bee1);
                this.apairyBeeList.add(bee1);
                ++this.birth;
            }
        }
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.getX() > this.axisAlignedBB.minX && (double)vec.getX() < this.axisAlignedBB.maxX) {
            if ((double)vec.getY() > this.axisAlignedBB.minY && (double)vec.getY() < this.axisAlignedBB.maxY) {
                return (double)vec.getZ() > this.axisAlignedBB.minZ && (double)vec.getZ() < this.axisAlignedBB.maxZ;
            }
            return false;
        }
        return false;
    }

    private void harvest() {
        this.passedCrops.clear();
        this.crops.clear();
        for (ChunkPos chunkPos : this.chunkPositions) {
            this.crops.addAll((Collection<TileEntityCrop>)this.chunkPosListMap.get(chunkPos));
        }
        this.crops = this.crops.stream().filter(crop -> crop.getCrop() != null).sorted(Comparator.comparing(crop -> crop.getCrop().getId() != this.queen.getCropFlower().getId())).collect(Collectors.toList());
        boolean addFood = false;
        boolean addJelly = false;
        block1: for (Bee bee : this.workersBeeList) {
            if (bee.isIll() || bee.isDead()) continue;
            if (this.passedCrops.size() == this.crops.size()) break;
            for (TileEntityCrop crop2 : this.crops) {
                boolean needUpdate;
                long beeId = crop2.getBeeId();
                if (crop2.getCrop().getId() == 3 || !this.contains(crop2.getPos()) || this.passedCrops.contains(crop2) || beeId != 0L || !(WorldBaseGen.random.nextDouble() < 0.5)) continue;
                this.passedCrops.add(crop2);
                crop2.setBeeId(this.id);
                int stage = crop2.getCrop().getStage();
                if (crop2.getCrop().getTick() < crop2.getCrop().getMaxTick()) {
                    crop2.getCrop().addTick((int)((double)((int)(crop2.getCrop().getGrowthSpeed() * 10.0 + 10.0 * this.speedCrop)) * this.pestGenome));
                    crop2.setActive(crop2.getCrop().getName().toLowerCase() + "_" + crop2.getCrop().getStage());
                }
                boolean bl = needUpdate = stage != crop2.getCrop().getStage();
                if (needUpdate) {
                    new PacketUpdateFieldTile(crop2, "tick", crop2.getCrop().getTick());
                }
                if (this.queen.getCropFlower().getId() == crop2.getCrop().getId()) {
                    double canRoyalJelly = 0.15;
                    if (!this.birthBeeList.isEmpty() || !this.doctorBeeList.isEmpty() && (double)this.doctorBeeList.size() * 1.0 / (double)this.apiaries.size() > 0.2) {
                        canRoyalJelly = 0.2;
                    }
                    this.royalJelly += canRoyalJelly * (1.0 + this.producing) * this.coef * this.jellyGenome;
                    addJelly = true;
                    if (this.royalJelly > (double)this.maxJelly) {
                        this.royalJelly = this.maxJelly;
                    }
                } else {
                    this.queen.addPercentProduct(crop2.getCrop(), 0.5);
                }
                this.food += 2.0 * (1.0 + this.producing) * this.coef * this.foodGenome;
                addFood = true;
                if (!(this.food > 1000.0)) continue;
                break block1;
            }
            int weatherResistance = this.queen.getWeatherResistance();
            if (this.rain && weatherResistance < 1 && this.weatherGenome < 0) {
                if (!((double)WorldBaseGen.random.nextInt(100) < 5.0 * this.hardeningGenome)) continue;
                bee.setIll(true);
                this.illTask = 1;
                this.illBeeList.add(bee);
                continue;
            }
            if (!this.thundering || weatherResistance >= 2 || this.weatherGenome >= 1 || !((double)WorldBaseGen.random.nextInt(100) < 10.0 * this.hardeningGenome)) continue;
            bee.setIll(true);
            this.illTask = 1;
            this.illBeeList.add(bee);
        }
        for (int i = 0; i < this.level.random.nextInt(Math.max(1, this.passedCrops.size() / 4)) + 1; ++i) {
            SmallBee smallBee = (SmallBee)((EntityType)IUItem.entity_bee.get()).create(this.level);
            smallBee.setCrops(this.passedCrops);
            smallBee.setBee(this.queen);
            smallBee.setCustomHive(this.pos);
            smallBee.moveTo(this.pos.getX(), this.pos.getY(), this.pos.getZ(), 0.0f, 0.0f);
            if (smallBee == null) continue;
            this.level.addFreshEntity((Entity)smallBee);
        }
        if ((double)this.harvest >= 3.0 / this.coef) {
            if (addFood) {
                this.tickDrainFood = (byte)(this.tickDrainFood + 1);
            }
            if (addJelly) {
                this.tickDrainJelly = (byte)(this.tickDrainJelly + 1);
            }
            if (WorldBaseGen.random.nextBoolean()) {
                this.queen.getProduct().forEach(product -> {
                    if ((double)WorldBaseGen.random.nextInt(100) < product.getChance() * this.productGenome) {
                        this.invSlotProduct.add(product.getCrop().getDrop());
                    }
                });
            }
            this.harvest = 0;
        } else {
            ++this.harvest;
        }
    }

    private void attackPlayers(Map<Player, Double> enemy) {
        enemy.forEach((key, value) -> {
            if (value >= 0.7) {
                for (Bee bee : this.attackBeeList) {
                    if (bee.isIll() || WorldBaseGen.random.nextInt(100) >= 20) continue;
                    key.hurt(IUDamageSource.bee, 1.0f);
                }
            }
        });
    }

    public Genome getGenome() {
        return this.genome;
    }

    public void healBeesFromApothecary(TileEntityApothecaryBee apothecaryBee) {
        if (this.illBeeList.isEmpty()) {
            return;
        }
        this.illBeeList.sort(Comparator.comparingInt(bee -> bee.getTypeBee().ordinal()));
        ArrayList<Bee> recoveryList = new ArrayList<Bee>();
        for (Bee illBee : this.illBeeList) {
            if (!illBee.isIll()) continue;
            if (apothecaryBee.energy.getEnergy() < 50.0) break;
            apothecaryBee.energy.useEnergy(50.0);
            illBee.setIll(false);
            recoveryList.add(illBee);
        }
        this.illBeeList.removeAll(recoveryList);
    }
}

