/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.hydroturbine;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.IType;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.water.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.api.water.upgrade.IRotorUpgradeItem;
import com.denfop.api.water.upgrade.RotorUpgradeItemInform;
import com.denfop.api.water.upgrade.RotorUpgradeSystem;
import com.denfop.api.water.upgrade.event.EventRotorItemLoad;
import com.denfop.api.windsystem.EnumLevelGenerators;
import com.denfop.api.windsystem.EnumRotorSide;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.IWindRotor;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.api.windsystem.event.WindGeneratorEvent;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockHydroTurbine;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerHydroTurbineController;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiHydroTurbineController;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotHydroTurbineRotor;
import com.denfop.invslot.InvSlotHydroTurbineRotorBlades;
import com.denfop.items.ItemWindRod;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.render.windgenerator.RotorModel;
import com.denfop.render.windgenerator.WindGeneratorRenderer;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.hydroturbine.ISocket;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.DamageHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector3f;

public class TileEntityHydroTurbineController
extends TileMultiBlockBase
implements IWindMechanism,
IType,
IUpdatableTileEvent {
    public final InvSlotHydroTurbineRotorBlades slot_blades;
    private final EnumLevelGenerators levelGenerators = EnumLevelGenerators.FOUR;
    public ISocket energy;
    public InvSlotHydroTurbineRotor slot = new InvSlotHydroTurbineRotor(this);
    public double generation = 0.0;
    public boolean need_repair;
    public int mind_wind;
    public boolean can_repair;
    public int mind_speed;
    public int timers;
    public double wind_speed;
    public EnumWindSide wind_side;
    public EnumTypeWind enumTypeWind;
    public int coefficient_power = 100;
    boolean space = false;
    private int tick = 0;
    private double addition_power = 0.0;
    private double addition_efficient = 0.0;
    private double addition_strength = 0.0;
    private double coefficient;
    private EnumRotorSide rotorSide;
    private float speed;
    private float angle;
    private long lastcheck;
    private boolean work = true;
    private int time;
    private boolean can_work = true;
    private double biome = 1.0;

    public TileEntityHydroTurbineController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.HydroTurbineMultiBlock, BlockHydroTurbine.hydro_turbine_controller, pos, state);
        this.slot_blades = new InvSlotHydroTurbineRotorBlades(this);
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.WATER_GENERATOR);
    }

    private int getDamageTimeFromWind() {
        switch (this.enumTypeWind) {
            case ONE: {
                return 60;
            }
            case TWO: {
                return 55;
            }
            case THREE: {
                return 50;
            }
            case FOUR: {
                return 45;
            }
            case FIVE: {
                return 40;
            }
            case SIX: {
                return 35;
            }
            case SEVEN: {
                return 30;
            }
            case EIGHT: {
                return 25;
            }
            case NINE: {
                return 20;
            }
            case TEN: {
                return 10;
            }
        }
        return 20;
    }

    private int getDamageRotor() {
        if (this.coefficient_power == 100) {
            return 1;
        }
        return (int)((double)((int)((double)(1 * this.coefficient_power) / 100.0)) * Math.pow((double)this.coefficient_power / 100.0, this.getRotor().getLevel() - 1)) * this.getCoefDamage();
    }

    private int getCoefDamage() {
        switch ((int)(this.coefficient * 10.0)) {
            case 10: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 1;
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockHydroTurbine.hydro_turbine_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.hydroTurbine.getBlock(this.getTeBlock());
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, this.facing);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, this.coefficient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.slot.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), this.getNBTFromSlot(customPacketBuffer));
            this.facing = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("wind.need_level") + "1 " + Localization.translate("wind.need_level1") + "14 " + Localization.translate("wind.need_level2"));
        tooltip.add(Localization.translate("iu.hydroturbine.info"));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
            this.speed = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.slot.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            this.rotorSide = EnumRotorSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.timers = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.wind_speed = (Double)DecoderHandler.decode(customPacketBuffer);
            this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.mind_wind = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.enumTypeWind = EnumTypeWind.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.coefficient_power = (Integer)DecoderHandler.decode(customPacketBuffer);
            if (this.energy != null) {
                this.energy.getEnergy().onNetworkUpdate(customPacketBuffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.coefficient);
            EncoderHandler.encode(packet, Float.valueOf(this.speed));
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, (Object)this.rotorSide);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.timers);
            EncoderHandler.encode(packet, this.wind_speed);
            EncoderHandler.encode(packet, (Object)this.wind_side);
            EncoderHandler.encode(packet, this.mind_wind);
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, (Object)this.enumTypeWind);
            EncoderHandler.encode(packet, this.coefficient_power);
            packet.writeBytes((ByteBuf)this.energy.getEnergy().updateComponent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.getRotor() != null && stack.getItem() instanceof ItemWindRod) {
            ItemStack rotor = this.slot.get(0);
            if (((ItemWindRod)stack.getItem()).getLevel(this.getRotor().getLevel(), ((ISubEnum)((ItemWindRod)stack.getItem()).getElement()).getId()) && (double)rotor.getDamageValue() >= (double)rotor.getMaxDamage() * 0.25) {
                this.slot.damage((int)(-((double)rotor.getMaxDamage() * 0.25)), 0.0);
                stack.shrink(1);
                return true;
            }
        }
        return super.onActivated(player, hand, side, vec3);
    }

    public boolean checkSpace() {
        int box = this.getRotorDiameter() / 2;
        if (box == 0) {
            return false;
        }
        Vector3f vec = this.getFacing().step();
        BlockPos pos1 = this.pos.offset((Vec3i)new BlockPos((int)vec.x(), (int)vec.y(), (int)vec.z()));
        switch (this.getFacing().getAxis()) {
            case Y: {
                return false;
            }
            case X: {
                for (int z = pos1.getZ() - box; z <= pos1.getZ() + box; ++z) {
                    for (int y = pos1.getY() - box; y <= pos1.getY() + box; ++y) {
                        BlockState state = this.level.getBlockState(new BlockPos(pos1.getX(), y, z));
                        if (state.liquid()) continue;
                        return false;
                    }
                }
                return true;
            }
            case Z: {
                for (int x = pos1.getX() - box; x <= pos1.getX() + box; ++x) {
                    for (int y = pos1.getY() - box; y <= pos1.getY() + box; ++y) {
                        BlockState state = this.level.getBlockState(new BlockPos(x, y, pos1.getZ()));
                        if (state.liquid()) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setFacingWrench(Direction facing, Player player) {
        boolean fac = super.setFacingWrench(facing, player);
        new PacketUpdateFieldTile(this, "facing", this.facing);
        return fac;
    }

    @Override
    public EnumRotorSide getRotorSide() {
        return this.rotorSide;
    }

    @Override
    public void setRotorSide(EnumRotorSide rotorSide) {
        this.rotorSide = rotorSide;
        new PacketUpdateFieldTile(this, "rotorSide", (Object)this.rotorSide);
    }

    @Override
    public double getCoefficient() {
        return this.coefficient;
    }

    @Override
    public void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
        new PacketUpdateFieldTile(this, "coefficient", this.coefficient);
    }

    @Override
    public IWindRotor getRotor() {
        return this.slot.isEmpty() ? null : (IWindRotor)this.slot.get(0).getItem();
    }

    @Override
    public ItemStack getItemStack() {
        return this.slot.get(0);
    }

    @Override
    public EnumLevelGenerators getLevelGenerator() {
        return this.levelGenerators;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.need_repair && this.getRotor() != null) {
            this.slot_blades.work();
        }
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.work || !this.can_work) {
            if (this.generation != 0.0) {
                this.generation = 0.0;
            }
            return;
        }
        if (this.can_repair && this.time != 0 && this.level.getGameTime() % ((long)this.time * 20L) == 0L) {
            this.slot.damage(-1, 0.0);
        }
        if (this.level.getGameTime() % 30L == 0L) {
            if (this.getRotor() != null) {
                this.space = this.checkSpace();
                new PacketUpdateFieldTile(this, "space", this.space);
            } else if (this.space) {
                this.space = false;
                new PacketUpdateFieldTile(this, "space", this.space);
            } else {
                this.generation = 0.0;
            }
        }
        ++this.tick;
        if (this.tick >= 40) {
            this.tick = 40;
        }
        if (this.space && this.getRotor() != null && ((ItemDamage)this.slot.get(0).getItem()).getCustomDamage(this.slot.get(0)) <= DamageHandler.getDamage(this.slot.get(0))) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.getRotor() == null) {
                if (this.getActive()) {
                    this.setActive(false);
                }
                if (this.space) {
                    this.space = false;
                    new PacketUpdateFieldTile(this, "space", this.space);
                }
                return;
            }
            this.wind_speed = WindSystem.windSystem.getWind_Strength();
            this.generation = WindSystem.windSystem.getPowerFromWaterRotor(this.level, this, this.getItemStack()) * this.biome * (double)this.coefficient_power / 100.0;
            this.energy.getEnergy().addEnergy(this.generation);
            if (this.level.getGameTime() % (long)this.getDamageTimeFromWind() == 0L) {
                this.slot.damage(this.getDamageRotor(), this.addition_strength);
            }
        } else {
            this.generation = 0.0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(TileMultiBlockBase tileEntityMultiBlockBase, RenderLevelStageEvent event) {
        if (!this.isFull()) {
            super.render(tileEntityMultiBlockBase, event);
        }
        if (this.isFull()) {
            event.getPoseStack().pushPose();
            event.getPoseStack().translate(-0.5, 0.0, -0.5);
            this.renderBlockRotor(this, this.getWorld(), this.getPos(), event);
            event.getPoseStack().popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderBlockRotor(IWindMechanism windGen, Level world, BlockPos pos, RenderLevelStageEvent event) {
        int diameter = windGen.getRotorDiameter();
        if (diameter != 0) {
            float angle = windGen.getAngle();
            ResourceLocation rotorRL = windGen.getRotorRenderTexture();
            WindGeneratorRenderer.rotorModels.clear();
            RotorModel model = WindGeneratorRenderer.rotorModels.get(diameter);
            if (model == null) {
                model = new RotorModel(diameter);
                WindGeneratorRenderer.rotorModels.put(diameter, model);
            }
            Direction facing = windGen.getFacing();
            pos = pos.offset(facing.getNormal());
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(0.5 + (double)facing.getStepX() * 0.35, 0.5, 0.5 + (double)facing.getStepZ() * 0.35);
            switch (facing) {
                case NORTH: {
                    poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                    break;
                }
                case EAST: {
                    poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
                    break;
                }
                case SOUTH: {
                    poseStack.mulPose(Axis.YP.rotationDegrees(-270.0f));
                    break;
                }
                case UP: {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                }
            }
            if (windGen.getSpace()) {
                IWindRotor rotor = this.getRotor();
                if (rotor.getMaxCustomDamage(this.slot.get(0)) - rotor.getCustomDamage(this.slot.get(0)) == 0) {
                    angle = 0.0f;
                }
                if (!Minecraft.getInstance().isPaused()) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(angle));
                }
            }
            poseStack.translate(-0.2f, 0.0f, 0.0f);
            GuiCore.bindTexture(rotorRL);
            VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)rotorRL));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.getLevelRenderer();
            int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)pos);
            model.renderToBuffer(poseStack, consumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
            poseStack.popPose();
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("speed")) {
            try {
                this.speed = ((Float)DecoderHandler.decode(is)).floatValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot")) {
            this.slot.readFromNbt((HolderLookup.Provider)is.registryAccess(), this.getNBTFromSlot(is));
        }
        if (name.equals("space")) {
            try {
                this.space = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("coefficient")) {
            try {
                this.coefficient = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("rotorSide")) {
            try {
                this.rotorSide = EnumRotorSide.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mind_wind")) {
            try {
                this.mind_wind = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("wind_side")) {
            try {
                this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(is)];
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("angle")) {
            try {
                this.angle = ((Float)DecoderHandler.decode(is)).floatValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("generation")) {
            try {
                this.generation = (Double)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mind_speed")) {
            try {
                this.mind_speed = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.getWorld().isClientSide || this.facing == 0 || this.facing == 1) {
            return;
        }
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.slot.isEmpty()) {
            NeoForge.EVENT_BUS.post((Event)new EventRotorItemLoad(this.getWorld(), (IRotorUpgradeItem)this.slot.get(0).getItem(), this.slot.get(0)));
        }
        this.biome = this.getWorld().getBiome(this.pos).is(BiomeTags.IS_OCEAN) || this.getWorld().getBiome(this.pos).is(BiomeTags.IS_RIVER) ? 1.0 : 0.5;
        this.change();
        this.setRotorSide(WindSystem.windSystem.getRotorSide(this.getFacing()));
        NeoForge.EVENT_BUS.post((Event)new WindGeneratorEvent(this, this.getWorld(), true));
        new PacketUpdateFieldTile(this, "speed", Float.valueOf(this.speed));
        new PacketUpdateFieldTile(this, "slot", this.slot);
        new PacketUpdateFieldTile(this, "space", this.space);
        new PacketUpdateFieldTile(this, "coefficient", this.coefficient);
        new PacketUpdateFieldTile(this, "wind_side", (Object)this.wind_side);
        new PacketUpdateFieldTile(this, "angle", Float.valueOf(this.angle));
        new PacketUpdateFieldTile(this, "mind_speed", this.mind_speed);
        new PacketUpdateFieldTile(this, "generation", this.generation);
        this.can_work = this.getWorld().dimensionType().hasSkyLight() && this.getWorld().dimension() != Level.NETHER;
        this.timers = WindSystem.windSystem.getTime();
        this.wind_side = WindSystem.windSystem.getWindSide();
        this.enumTypeWind = WindSystem.windSystem.getEnumTypeWind();
        if (!this.slot.get(0).isEmpty() && (double)DamageHandler.getDamage(this.slot.get(0)) <= (double)DamageHandler.getMaxDamage(this.slot.get(0)) * 0.75) {
            this.need_repair = true;
        }
    }

    @Override
    public void onUnloaded() {
        NeoForge.EVENT_BUS.post((Event)new WindGeneratorEvent(this, this.getWorld(), false));
        super.onUnloaded();
    }

    @Override
    public boolean canPlace(TileEntityBlock te, BlockPos pos, Level world, Direction direction, LivingEntity entity) {
        for (int i = pos.getX() - 4; i <= pos.getX() + 4; ++i) {
            for (int j = pos.getY() - 4; j <= pos.getY() + 4; ++j) {
                for (int k = pos.getZ() - 4; k <= pos.getZ() + 4; ++k) {
                    BlockEntity tile = world.getBlockEntity(new BlockPos(i, j, k));
                    if (!(tile instanceof IWindMechanism)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void onBlockBreak(boolean w) {
        super.onBlockBreak(w);
    }

    @Override
    public void setWork(boolean work) {
        this.work = work;
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.getActive()) {
            new PacketUpdateFieldTile(this, "slot", this.slot);
        }
        super.setActive(active);
    }

    public double getGeneration() {
        return this.generation;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putInt("coef", this.coefficient_power);
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.coefficient_power = nbtTagCompound.getInt("coef");
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, Float.valueOf(this.speed));
            EncoderHandler.encode(packet, this.slot);
            EncoderHandler.encode(packet, this.space);
            EncoderHandler.encode(packet, this.coefficient);
            EncoderHandler.encode(packet, (Object)this.wind_side);
            EncoderHandler.encode(packet, Float.valueOf(this.angle));
            EncoderHandler.encode(packet, this.mind_speed);
            EncoderHandler.encode(packet, this.generation);
            EncoderHandler.encode(packet, this.coefficient_power);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.speed = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.slot.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((InvSlot)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            this.space = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.coefficient = (Double)DecoderHandler.decode(customPacketBuffer);
            this.wind_side = EnumWindSide.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.angle = ((Float)DecoderHandler.decode(customPacketBuffer)).floatValue();
            this.mind_speed = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
            this.coefficient_power = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        this.energy = (ISocket)this.getWorld().getBlockEntity(pos1.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.energy = null;
        }
    }

    @Override
    public float getAngle() {
        if (this.getWorld().dimension() != Level.OVERWORLD) {
            return 0.0f;
        }
        if (this.speed != 0.0f && this.work && this.getRotor() != null && ((ItemDamage)this.slot.get(0).getItem()).getCustomDamage(this.slot.get(0)) <= DamageHandler.getDamage(this.slot.get(0))) {
            long k = System.currentTimeMillis() - this.lastcheck;
            this.angle = this.mind_wind != 0 ? (this.angle += (float)((double)k * WindSystem.windSystem.getSpeed(Math.min(24.7 + (double)this.mind_speed, WindSystem.windSystem.getSpeedFromPower(this.getBlockPos(), this, this.generation)) * this.getCoefficient()))) : (this.angle += (float)((double)((float)k * this.speed) * this.getCoefficient()));
            this.angle %= 360.0f;
        }
        this.lastcheck = System.currentTimeMillis();
        return this.angle;
    }

    @Override
    public void setRotationSpeed(float speed) {
        if (this.speed != speed) {
            this.speed = speed;
            new PacketUpdateFieldTile(this, "speed", Float.valueOf(speed));
        }
    }

    @Override
    public int getRotorDiameter() {
        return this.getRotor() != null ? this.getRotor().getDiameter(this.slot.get(0)) : 0;
    }

    @Override
    public ResourceLocation getRotorRenderTexture() {
        return this.getRotor() != null ? this.getRotor().getRotorRenderTexture(this.slot.get(0)) : null;
    }

    @Override
    public void change() {
        this.addition_power = 0.0;
        this.addition_efficient = 0.0;
        this.addition_strength = 0.0;
        this.time = 0;
        this.mind_speed = 0;
        this.mind_wind = 0;
        if (this.getRotor() != null) {
            RotorUpgradeItemInform modules;
            int i;
            List<RotorUpgradeItemInform> list = RotorUpgradeSystem.instance.getInformation(this.getItemStack());
            for (i = 0; i < 3; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_strength += modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef();
            }
            for (i = 3; i < 6; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_efficient += modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef();
            }
            for (i = 6; i < 9; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.addition_power += modules == null ? 0.0 : (double)modules.number * modules.upgrade.getCoef();
            }
            for (i = 13; i < 16; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.time = modules == null ? 0 : (int)modules.upgrade.getCoef();
            }
            for (i = 10; i < 13; ++i) {
                modules = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(i), list);
                this.mind_wind = modules == null ? 0 : (int)modules.upgrade.getCoef();
            }
            RotorUpgradeItemInform modules2 = RotorUpgradeSystem.instance.getModules(EnumInfoRotorUpgradeModules.getFromID(16), list);
            double d = this.biome = this.getWorld().getBiome(this.pos).is(BiomeTags.IS_OCEAN) || this.getWorld().getBiome(this.pos).is(BiomeTags.IS_RIVER) ? 1.0 : 0.5;
            if (modules2 != null) {
                this.biome = 1.0;
            }
        }
        new PacketUpdateFieldTile(this, "mind_wind", this.mind_wind);
    }

    @Override
    public double getAdditionalCoefficient() {
        return this.addition_efficient;
    }

    @Override
    public double getAdditionalPower() {
        return this.addition_power;
    }

    @Override
    public boolean getAuto() {
        return false;
    }

    @Override
    public boolean getMin() {
        return true;
    }

    @Override
    public boolean getSpace() {
        return this.space;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean need_repair() {
        return this.need_repair;
    }

    @Override
    public boolean can_repair() {
        return this.can_repair;
    }

    @Override
    public int getMinWind() {
        return this.mind_wind;
    }

    @Override
    public int getMinWindSpeed() {
        return this.mind_speed;
    }

    public ContainerHydroTurbineController getGuiContainer(Player entityPlayer) {
        return new ContainerHydroTurbineController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiHydroTurbineController((ContainerHydroTurbineController)menu);
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i != 0.0) {
            this.coefficient_power = (int)i;
            if (this.coefficient_power < 100) {
                this.coefficient_power = 100;
            }
            if (this.coefficient_power > 150) {
                this.coefficient_power = 150;
            }
        }
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }
}

