/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.research.event.RocketPadLoadEvent;
import com.denfop.api.space.research.event.RocketPadReLoadEvent;
import com.denfop.api.space.research.event.RocketPadUnLoadEvent;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerRocketLaunchPad;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiRocketLaunchPad;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.rocketpad.DataRocket;
import com.denfop.render.rocketpad.RocketPadRender;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class TileEntityRocketLaunchPad
extends TileEntityInventory
implements IRocketLaunchPad {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(-1.0, 0.0, -1.0, 2.0, 2.0, 2.0));
    public final InvSlotOutput outputSlot;
    public final InvSlot roverSlot;
    public final Energy energy;
    public final Fluids fluids;
    public final Fluids.InternalFluidTank tank;
    public final Fluids.InternalFluidTank[] tanks;
    public List<DataRocket> rocketList = new ArrayList<DataRocket>();
    boolean added = false;
    private UUID player = new UUID(WorldBaseGen.random.nextLong(), WorldBaseGen.random.nextLong());

    public TileEntityRocketLaunchPad(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.rocket_launch_pad, pos, state);
        this.outputSlot = new InvSlotOutput(this, 27);
        this.roverSlot = new InvSlot(this, this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.getItem() instanceof IRoversItem;
            }
        };
        this.fluids = this.addComponent(new Fluids(this));
        this.tank = this.fluids.addTankInsert("tank", 40000, Fluids.fluidPredicate((Fluid)FluidName.fluidhydrazine.getInstance().get(), (Fluid)FluidName.fluiddimethylhydrazine.getInstance().get(), (Fluid)FluidName.fluiddecane.getInstance().get(), (Fluid)FluidName.fluidxenon.getInstance().get()));
        this.tanks = new Fluids.InternalFluidTank[9];
        for (int i = 0; i < 9; ++i) {
            this.tanks[i] = this.fluids.addTankExtract("tank" + i, 10000);
        }
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 5000000.0, 14));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.rocket_launch_pad;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return aabbs;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 80L == 0L) {
            NeoForge.EVENT_BUS.post((Event)new RocketPadReLoadEvent(this.getWorld(), this));
        }
        if (!this.roverSlot.isEmpty()) {
            this.charge(this.roverSlot.get(0));
            this.refuel(this.roverSlot.get(0), (IRoversItem)this.roverSlot.get(0).getItem());
        }
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            this.player = placer.getUUID();
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.player = nbtTagCompound.getUUID("player");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putUUID("player", this.player);
        return nbtTagCompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.getWorld().isClientSide) {
            GlobalRenderManager.addRender(this.level, this.pos, this.createFunction(this));
        } else if (!this.added) {
            NeoForge.EVENT_BUS.post((Event)new RocketPadLoadEvent(this.getWorld(), this));
            this.added = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Function<RenderLevelStageEvent, Void> createFunction(TileEntityRocketLaunchPad te) {
        Function<RenderLevelStageEvent, Void> function = event -> {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate((float)te.getPos().getX(), (float)te.getPos().getY(), (float)te.getPos().getZ());
            event.getLevelRenderer();
            int combinedLight = LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.pos);
            RocketPadRender.render(te, event.getPartialTick().getGameTimeDeltaTicks(), event.getPoseStack(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), combinedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            return null;
        };
        return function;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.added) {
            NeoForge.EVENT_BUS.post((Event)new RocketPadUnLoadEvent(this.getWorld(), this));
            this.added = false;
        }
        if (this.getWorld().isClientSide) {
            GlobalRenderManager.removeRender(this.level, this.pos);
        }
    }

    @Override
    public void refuel(ItemStack itemStack, IRoversItem roversItem) {
        IFluidHandlerItem fluidHandler = roversItem.getFluidHandler(itemStack);
        if (this.tank.getFluidAmount() > 0 && fluidHandler.fill(this.tank.getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0) {
            this.tank.drain(fluidHandler.fill(this.tank.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void charge(ItemStack itemStack) {
        if (this.energy.getEnergy() > 0.0) {
            this.energy.useEnergy(ElectricItem.manager.charge(itemStack, this.energy.getEnergy(), 14, true, false));
        }
    }

    @Override
    public ItemStack getRoverStack() {
        return this.roverSlot.get(0);
    }

    @Override
    public InvSlot getRoverSlot() {
        return this.roverSlot;
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    @Override
    public Level getWorldPad() {
        return this.level;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = super.writePacket();
        packetBuffer.writeBoolean(this.roverSlot.isEmpty());
        if (!this.roverSlot.isEmpty()) {
            try {
                EncoderHandler.encode(packetBuffer, this.roverSlot.get(0));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return packetBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        boolean isNotEmpty = customPacketBuffer.readBoolean();
        if (!isNotEmpty) {
            try {
                this.roverSlot.set(0, (ItemStack)DecoderHandler.decode(customPacketBuffer));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("datarocket")) {
            ItemStack stack = ItemStack.EMPTY;
            try {
                stack = (ItemStack)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.rocketList.add(new DataRocket((IRoversItem)stack.getItem(), this.pos.getY()));
            this.roverSlot.set(0, ItemStack.EMPTY);
        }
    }

    @Override
    public void addDataRocket(ItemStack stack) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer(this.level.registryAccess());
        packetBuffer.writeString("datarocket");
        try {
            EncoderHandler.encode(packetBuffer, stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IUCore.network.getServer().addTileFieldToUpdate(this, packetBuffer);
    }

    @Override
    public InvSlotOutput getSlotOutput() {
        return this.outputSlot;
    }

    @Override
    public void addFluidStack(FluidStack fluidStack) {
        for (int i = 0; i < 9; ++i) {
            Fluids.InternalFluidTank tank = this.tanks[i];
            if (tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packetBuffer = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packetBuffer, this.roverSlot.get(0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packetBuffer;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
        try {
            this.roverSlot.set(0, (ItemStack)DecoderHandler.decode(packetBuffer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    public ContainerRocketLaunchPad getGuiContainer(Player var1) {
        return new ContainerRocketLaunchPad(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiRocketLaunchPad((ContainerRocketLaunchPad)menu);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().isClientSide && FluidHandlerFix.hasFluidHandler(player.getItemInHand(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(Capabilities.FluidHandler.BLOCK, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public IRoversItem getRover() {
        if (this.roverSlot.get(0).isEmpty()) {
            return null;
        }
        return (IRoversItem)this.roverSlot.get(0).getItem();
    }

    @Override
    public void consumeRover() {
        this.roverSlot.set(0, ItemStack.EMPTY);
    }
}

