/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.Vein;
import com.denfop.api.vein.VeinSystem;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerWirelessMineralQuarry;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.VeinInfo;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiWirelessMineralQuarry;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemVeinSensor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.Keyboard;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TileEntityWirelessMineralQuarry
extends TileEntityInventory
implements IManufacturerBlock {
    public final Energy energy;
    public final InvSlot invslot;
    public final InvSlotOutput output;
    public List<Vein> veinList = new LinkedList<Vein>();
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public int levelBlock;

    public TileEntityWirelessMineralQuarry(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3.wireless_mineral_quarry, pos, state);
        this.output = new InvSlotOutput(this, 18);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, 50000.0, 14));
        this.invslot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 4){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityWirelessMineralQuarry.this.updateList();
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (!(stack.getItem() instanceof ItemVeinSensor)) {
                    return false;
                }
                if (stack.has(DataComponentsInit.VEIN_INFO)) {
                    return !((VeinInfo)stack.get(DataComponentsInit.VEIN_INFO)).type().equals("oil") && !((VeinInfo)stack.get(DataComponentsInit.VEIN_INFO)).type().equals("gas");
                }
                return false;
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerWirelessMineralQuarry getGuiContainer(Player var1) {
        return new ContainerWirelessMineralQuarry(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiWirelessMineralQuarry((ContainerWirelessMineralQuarry)menu);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.wireless_mineral_quarry;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.levelBlock = nbtTagCompound.getInt("level");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putInt("level", this.levelBlock);
        return nbtTagCompound;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.levelBlock < 10) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.getItem().equals(IUItem.upgrade_speed_creation.getItem())) {
                return super.onActivated(player, hand, side, vec3);
            }
            stack.shrink(1);
            ++this.levelBlock;
            return true;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean active = false;
        for (int i = 0; i < this.veinList.size(); ++i) {
            Vein vein = this.veinList.get(i);
            ItemStack stack = this.itemStacks.get(i);
            if (!(this.energy.getEnergy() >= 10.0) || !vein.isFind() || vein.getCol() < 1) continue;
            int size = Math.min((this.levelBlock + 1) * 2, vein.getCol());
            stack.setCount(size);
            int prev = this.output.addExperimental(stack);
            if ((size -= prev) == 0) continue;
            vein.removeCol(size);
            active = true;
            this.energy.useEnergy(10.0);
        }
        this.setActive(active);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.levelBlock != 0) {
            ret.add(new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), this.levelBlock));
            this.levelBlock = 0;
        }
        return ret;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "10" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        int i;
        super.readContainerPacket(customPacketBuffer);
        this.veinList.clear();
        this.itemStacks.clear();
        int col = customPacketBuffer.readInt();
        for (i = 0; i < col; ++i) {
            try {
                this.veinList.add((Vein)DecoderHandler.decode(customPacketBuffer));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < col; ++i) {
            try {
                this.itemStacks.add((ItemStack)DecoderHandler.decode(customPacketBuffer));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.veinList.size());
        for (Vein vein : this.veinList) {
            try {
                EncoderHandler.encode(customPacketBuffer, vein);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (ItemStack itemStack : this.itemStacks) {
            try {
                EncoderHandler.encode(customPacketBuffer, itemStack);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.updateList();
        }
    }

    public void updateList() {
        this.veinList.clear();
        this.itemStacks.clear();
        for (ItemStack stack : this.invslot) {
            int z;
            VeinInfo veinInfo;
            int x;
            ChunkPos chunkPos;
            Vein vein;
            if (stack.isEmpty() || !(vein = VeinSystem.system.getVein(chunkPos = new ChunkPos((x = (veinInfo = (VeinInfo)stack.get(DataComponentsInit.VEIN_INFO)).x()) >> 4, (z = veinInfo.z()) >> 4))).isFind() || vein.getType() != Type.VEIN) continue;
            this.veinList.add(vein);
            if (vein.isOldMineral()) {
                this.itemStacks.add(new ItemStack((ItemLike)IUItem.heavyore.getItem(vein.getMeta()), 1));
                continue;
            }
            this.itemStacks.add(new ItemStack((ItemLike)IUItem.mineral.getItem(vein.getMeta()), 1));
        }
    }

    @Override
    public int getLevelMechanism() {
        return this.levelBlock;
    }

    @Override
    public void setLevelMech(int level) {
        this.levelBlock = level;
    }

    @Override
    public void removeLevel(int level) {
        this.levelBlock -= level;
    }
}

